/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.bst.BstLexer;
import net.sf.jabref.bst.BstParser;
import net.sf.jabref.bst.ChangeCaseFunction;
import net.sf.jabref.bst.FormatNameFunction;
import net.sf.jabref.bst.PurifyFunction;
import net.sf.jabref.bst.TextPrefixFunction;
import net.sf.jabref.bst.VMException;
import net.sf.jabref.bst.Warn;
import net.sf.jabref.bst.WidthFunction;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class VM
implements Warn {
    PrintStream out = System.out;
    public static final Integer FALSE = new Integer(0);
    public static final Integer TRUE = new Integer(1);
    private HashMap<String, BstFunction> buildInFunctions;
    public File file;
    CommonTree tree;
    private StringBuffer bbl;
    String preamble;
    Vector<BstEntry> entries;
    Map<String, String> strings = new HashMap<String, String>();
    Map<String, Integer> integers = new HashMap<String, Integer>();
    Map<String, BstFunction> functions = new HashMap<String, BstFunction>();
    Stack<Object> stack = new Stack();

    public VM(File f) throws RecognitionException, IOException {
        this(new ANTLRFileStream(f.getPath()));
        this.file = f;
    }

    public VM(String s) throws RecognitionException {
        this(new ANTLRStringStream(s));
    }

    public static CommonTree charStream2CommonTree(CharStream bst) throws RecognitionException {
        BstLexer lex = new BstLexer(bst);
        CommonTokenStream tokens = new CommonTokenStream(lex);
        BstParser parser = new BstParser(tokens);
        BstParser.program_return r = parser.program();
        return (CommonTree)r.getTree();
    }

    public VM(CharStream bst) throws RecognitionException {
        this(VM.charStream2CommonTree(bst));
    }

    public VM(CommonTree tree) {
        this.tree = tree;
        this.buildInFunctions = new HashMap(37);
        this.buildInFunctions.put(">", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation >");
                }
                Object o2 = VM.this.stack.pop();
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                    throw new VMException("Can only compare two integers with >");
                }
                if (o1 == o2) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                VM.this.stack.push(((Integer)o1).compareTo((Integer)o2) > 0 ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("<", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation <");
                }
                Object o2 = VM.this.stack.pop();
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                    throw new VMException("Can only compare two integers with <");
                }
                if (o1 == o2) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                VM.this.stack.push(((Integer)o1).compareTo((Integer)o2) < 0 ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("=", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                Object o2;
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation =");
                }
                Object o1 = VM.this.stack.pop();
                if (o1 == null ^ (o2 = VM.this.stack.pop()) == null) {
                    VM.this.stack.push(FALSE);
                    return;
                }
                if (o1 == o2) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                VM.this.stack.push(o1.equals(o2) ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("+", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation +");
                }
                Object o2 = VM.this.stack.pop();
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                    throw new VMException("Can only compare two integers with +");
                }
                VM.this.stack.push(new Integer((Integer)o1 + (Integer)o2));
            }
        });
        this.buildInFunctions.put("-", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation -");
                }
                Object o2 = VM.this.stack.pop();
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer) || !(o2 instanceof Integer)) {
                    throw new VMException("Can only subtract two integers with -");
                }
                VM.this.stack.push(new Integer((Integer)o1 - (Integer)o2));
            }
        });
        this.buildInFunctions.put("*", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation *");
                }
                Object o2 = VM.this.stack.pop();
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof String) || !(o2 instanceof String)) {
                    throw new VMException("Can only concatenate two String with *");
                }
                VM.this.stack.push((String)o1 + (String)o2);
            }
        });
        this.buildInFunctions.put(":=", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Invalid call to operation :=");
                }
                Object o1 = VM.this.stack.pop();
                Object o2 = VM.this.stack.pop();
                VM.this.assign(context, o1, o2);
            }
        });
        this.buildInFunctions.put("add.period$", new BstFunction(){
            Pattern p = Pattern.compile("([^\\.\\?\\!\\}\\s])(\\}|\\s)*$");

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation add.period$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof String)) {
                    throw new VMException("Can only add a period to a string for add.period$");
                }
                String s = (String)o1;
                Matcher m = this.p.matcher(s);
                if (m.find()) {
                    StringBuffer sb = new StringBuffer();
                    m.appendReplacement(sb, m.group(1));
                    sb.append('.');
                    String group2 = m.group(2);
                    if (group2 != null) {
                        sb.append(m.group(2));
                    }
                    VM.this.stack.push(sb.toString());
                } else {
                    VM.this.stack.push(s);
                }
            }
        });
        this.buildInFunctions.put("call.type$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (context == null) {
                    throw new VMException("Call.type$ can only be called from within a context (ITERATE or REVERSE).");
                }
                VM.this.execute(context.entry.getType().getName().toLowerCase(), context);
            }
        });
        this.buildInFunctions.put("change.case$", new ChangeCaseFunction(this));
        this.buildInFunctions.put("chr.to.int$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation chr.to.int$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof String) || ((String)o1).length() != 1) {
                    throw new VMException("Can only perform chr.to.int$ on string with length 1");
                }
                String s = (String)o1;
                VM.this.stack.push(new Integer(s.charAt(0)));
            }
        });
        this.buildInFunctions.put("cite$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                VM.this.stack.push(context.entry.getCiteKey());
            }
        });
        this.buildInFunctions.put("duplicate$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation duplicate$");
                }
                Object o1 = VM.this.stack.pop();
                VM.this.stack.push(o1);
                VM.this.stack.push(o1);
            }
        });
        this.buildInFunctions.put("empty$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation empty$");
                }
                Object o1 = VM.this.stack.pop();
                if (o1 == null) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                if (!(o1 instanceof String)) {
                    throw new VMException("Operand does not match function empty$");
                }
                String s = (String)o1;
                VM.this.stack.push(s.trim().equals("") ? TRUE : FALSE);
            }
        });
        this.buildInFunctions.put("format.name$", new FormatNameFunction(this));
        this.buildInFunctions.put("if$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 3) {
                    throw new VMException("Not enough operands on stack for operation =");
                }
                Object f1 = VM.this.stack.pop();
                Object f2 = VM.this.stack.pop();
                Object i = VM.this.stack.pop();
                if (!(f1 instanceof Identifier) && !(f1 instanceof Tree) && (f2 instanceof Identifier || f2 instanceof Tree) && i instanceof Integer) {
                    throw new VMException("Expecting two functions and an integer for if$.");
                }
                Object toExe = (Integer)i > 0 ? f2 : f1;
                VM.this.executeInContext(toExe, context);
            }
        });
        this.buildInFunctions.put("int.to.chr$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation int.to.chr$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer)) {
                    throw new VMException("Can only perform operation int.to.chr$ on an Integer");
                }
                Integer i = (Integer)o1;
                VM.this.stack.push(String.valueOf((char)i.intValue()));
            }
        });
        this.buildInFunctions.put("int.to.str$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation int.to.str$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof Integer)) {
                    throw new VMException("Can only transform an integer to an string using int.to.str$");
                }
                VM.this.stack.push(((Integer)o1).toString());
            }
        });
        this.buildInFunctions.put("missing$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation missing$");
                }
                Object o1 = VM.this.stack.pop();
                if (o1 == null) {
                    VM.this.stack.push(TRUE);
                    return;
                }
                if (!(o1 instanceof String)) {
                    VM.this.warn("Not a string or missing field in operation missing$");
                    VM.this.stack.push(TRUE);
                    return;
                }
                VM.this.stack.push(FALSE);
            }
        });
        this.buildInFunctions.put("newline$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                VM.this.bbl.append('\n');
            }
        });
        this.buildInFunctions.put("num.names$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation num.names$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof String)) {
                    throw new VMException("Need a string at the top of the stack for num.names$");
                }
                String s = (String)o1;
                VM.this.stack.push(new Integer(AuthorList.getAuthorList(s).size()));
            }
        });
        this.buildInFunctions.put("pop$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                VM.this.stack.pop();
            }
        });
        this.buildInFunctions.put("preamble$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.preamble != null) {
                    VM.this.stack.push(VM.this.preamble);
                } else {
                    VM.this.stack.push("");
                }
            }
        });
        this.buildInFunctions.put("purify$", new PurifyFunction(this));
        this.buildInFunctions.put("quote$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                VM.this.stack.push("\"");
            }
        });
        this.buildInFunctions.put("skip$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
            }
        });
        this.buildInFunctions.put("stack$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                while (!VM.this.stack.empty()) {
                    System.out.println(VM.this.stack.pop());
                }
            }
        });
        this.buildInFunctions.put("substring$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 3) {
                    throw new VMException("Not enough operands on stack for operation substring$");
                }
                Object o1 = VM.this.stack.pop();
                Object o2 = VM.this.stack.pop();
                Object o3 = VM.this.stack.pop();
                if (!(o1 instanceof Integer && o2 instanceof Integer && o3 instanceof String)) {
                    throw new VMException("Expecting two integers and a string for substring$");
                }
                Integer len = (Integer)o1;
                Integer start = (Integer)o2;
                int lenI = len;
                int startI = start;
                if (lenI > 0x3FFFFFFF) {
                    lenI = 0x3FFFFFFF;
                }
                if (startI > 0x3FFFFFFF) {
                    startI = 0x3FFFFFFF;
                }
                if (startI < -1073741824) {
                    startI = -1073741824;
                }
                String s = (String)o3;
                if (startI < 0) {
                    startI += s.length() + 1;
                    startI = Math.max(1, startI + 1 - lenI);
                }
                VM.this.stack.push(s.substring(startI - 1, Math.min(startI - 1 + lenI, s.length())));
            }
        });
        this.buildInFunctions.put("swap$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation swap$");
                }
                Object f1 = VM.this.stack.pop();
                Object f2 = VM.this.stack.pop();
                VM.this.stack.push(f1);
                VM.this.stack.push(f2);
            }
        });
        this.buildInFunctions.put("text.length$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 1) {
                    throw new VMException("Not enough operands on stack for operation text.length$");
                }
                Object o1 = VM.this.stack.pop();
                if (!(o1 instanceof String)) {
                    throw new VMException("Can only perform operation on a string text.length$");
                }
                String s = (String)o1;
                char[] c = s.toCharArray();
                int result = 0;
                int i = 0;
                int n = s.length();
                int braceLevel = 0;
                while (i < n) {
                    if (c[++i - 1] == '{') {
                        if (++braceLevel != 1 || i >= n || c[i] != '\\') continue;
                        ++i;
                        while (i < n && braceLevel > 0) {
                            if (c[i] == '}') {
                                --braceLevel;
                            } else if (c[i] == '{') {
                                ++braceLevel;
                            }
                            ++i;
                        }
                        ++result;
                        continue;
                    }
                    if (c[i - 1] == '}') {
                        if (braceLevel <= 0) continue;
                        --braceLevel;
                        continue;
                    }
                    ++result;
                }
                VM.this.stack.push(new Integer(result));
            }
        });
        this.buildInFunctions.put("text.prefix$", new TextPrefixFunction(this));
        this.buildInFunctions.put("top$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                System.out.println(VM.this.stack.pop());
            }
        });
        this.buildInFunctions.put("type$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                VM.this.stack.push(context.entry.getType().getName());
            }
        });
        this.buildInFunctions.put("warning$", new BstFunction(){
            int warning = 1;

            @Override
            public void execute(BstEntry context) {
                VM.this.out.println("Warning (#" + this.warning++ + "): " + VM.this.stack.pop());
            }
        });
        this.buildInFunctions.put("while$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                if (VM.this.stack.size() < 2) {
                    throw new VMException("Not enough operands on stack for operation while$");
                }
                Object f2 = VM.this.stack.pop();
                Object f1 = VM.this.stack.pop();
                if (!(f1 instanceof Identifier) && !(f1 instanceof Tree) && (f2 instanceof Identifier || f2 instanceof Tree)) {
                    throw new VMException("Expecting two functions for while$.");
                }
                while (true) {
                    VM.this.executeInContext(f1, context);
                    Object i = VM.this.stack.pop();
                    if (!(i instanceof Integer)) {
                        throw new VMException("First parameter to while has to return an integer but was " + i);
                    }
                    if ((Integer)i <= 0) break;
                    VM.this.executeInContext(f2, context);
                }
            }
        });
        this.buildInFunctions.put("width$", new WidthFunction(this));
        this.buildInFunctions.put("write$", new BstFunction(){

            @Override
            public void execute(BstEntry context) {
                String s = (String)VM.this.stack.pop();
                System.out.println(s);
                VM.this.bbl.append(s);
            }
        });
    }

    protected boolean assign(BstEntry context, Object o1, Object o2) {
        if (!(o1 instanceof Identifier) || !(o2 instanceof String) && !(o2 instanceof Integer)) {
            throw new VMException("Invalid parameters");
        }
        String name = ((Identifier)o1).getName();
        if (o2 instanceof String) {
            if (context != null && context.strings.containsKey(name)) {
                context.strings.put(name, (String)o2);
                return true;
            }
            if (this.strings.containsKey(name)) {
                this.strings.put(name, (String)o2);
                return true;
            }
            return false;
        }
        if (o2 instanceof Integer) {
            if (context != null && context.integers.containsKey(name)) {
                context.integers.put(name, (Integer)o2);
                return true;
            }
            if (this.integers.containsKey(name)) {
                this.integers.put(name, (Integer)o2);
                return true;
            }
            return false;
        }
        return false;
    }

    public String run(BibtexDatabase db) {
        this.preamble = db.getPreamble();
        return this.run(db.getEntries());
    }

    public String run(Collection<BibtexEntry> bibtex) {
        this.reset();
        this.entries = new Vector(bibtex.size());
        ListIterator<BstEntry> i = this.entries.listIterator();
        for (BibtexEntry entry : bibtex) {
            i.add(new BstEntry(entry));
        }
        block13: for (int i2 = 0; i2 < this.tree.getChildCount(); ++i2) {
            Tree child = this.tree.getChild(i2);
            switch (child.getType()) {
                case 23: {
                    this.strings(child);
                    continue block13;
                }
                case 11: {
                    this.integers(child);
                    continue block13;
                }
                case 7: {
                    this.function(child);
                    continue block13;
                }
                case 6: {
                    this.execute(child);
                    continue block13;
                }
                case 20: {
                    this.sort(child);
                    continue block13;
                }
                case 12: {
                    this.iterate(child);
                    continue block13;
                }
                case 19: {
                    this.reverse(child);
                    continue block13;
                }
                case 5: {
                    this.entry(child);
                    continue block13;
                }
                case 18: {
                    this.read();
                    continue block13;
                }
                case 15: {
                    this.macro(child);
                }
            }
        }
        return this.bbl.toString();
    }

    private void reset() {
        this.bbl = new StringBuffer();
        this.entries = null;
        this.strings = new HashMap<String, String>();
        this.integers = new HashMap<String, Integer>();
        this.integers.put("entry.max$", new Integer(Integer.MAX_VALUE));
        this.integers.put("global.max$", new Integer(Integer.MAX_VALUE));
        this.functions = new HashMap<String, BstFunction>();
        this.functions.putAll(this.buildInFunctions);
        this.stack = new Stack();
    }

    private void read() {
        for (BstEntry e : this.entries) {
            Iterator<Map.Entry<String, String>> i$ = e.fields.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> mEntry;
                String fieldValue = e.entry.getField((mEntry = i$.next()).getKey());
                mEntry.setValue(fieldValue == null ? null : fieldValue.toString());
            }
        }
        for (BstEntry e : this.entries) {
            if (e.fields.containsKey("crossref")) continue;
            e.fields.put("crossref", null);
        }
    }

    private void macro(Tree child) {
        String name = child.getChild(0).getText();
        String replacement = child.getChild(1).getText();
        this.functions.put(name, new MacroFunction(replacement));
    }

    private void entry(Tree child) {
        String name;
        int i;
        Tree t = child.getChild(0);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.fields.put(name, null);
            }
        }
        t = child.getChild(1);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.integers.put(name, new Integer(0));
            }
        }
        t = child.getChild(2);
        for (i = 0; i < t.getChildCount(); ++i) {
            name = t.getChild(i).getText();
            for (BstEntry entry : this.entries) {
                entry.strings.put(name, null);
            }
        }
        for (BstEntry entry : this.entries) {
            entry.strings.put("sort.key$", null);
        }
    }

    private void reverse(Tree child) {
        BstFunction f = this.functions.get(child.getChild(0).getText());
        ListIterator<BstEntry> i = this.entries.listIterator(this.entries.size());
        while (i.hasPrevious()) {
            f.execute(i.previous());
        }
    }

    private void iterate(Tree child) {
        BstFunction f = this.functions.get(child.getChild(0).getText());
        Iterator<BstEntry> i = this.entries.iterator();
        while (i.hasNext()) {
            f.execute(i.next());
        }
    }

    private void sort(Tree child) {
        Collections.sort(this.entries, new Comparator<BstEntry>(){

            @Override
            public int compare(BstEntry o1, BstEntry o2) {
                return o1.strings.get("sort.key$").compareTo(o2.strings.get("sort.key$"));
            }
        });
    }

    public void executeInContext(Object o, BstEntry context) {
        if (o instanceof Tree) {
            Tree t = (Tree)o;
            new StackFunction(t).execute(context);
        } else if (o instanceof Identifier) {
            this.execute(((Identifier)o).getName(), context);
        }
    }

    public void execute(Tree child) {
        this.execute(child.getChild(0).getText(), null);
    }

    private void push(Tree t) {
        this.stack.push(t);
    }

    public void execute(String name, BstEntry context) {
        if (context != null) {
            if (context.fields.containsKey(name)) {
                this.stack.push(context.fields.get(name));
                return;
            }
            if (context.strings.containsKey(name)) {
                this.stack.push(context.strings.get(name));
                return;
            }
            if (context.integers.containsKey(name)) {
                this.stack.push(context.integers.get(name));
                return;
            }
        }
        if (this.strings.containsKey(name)) {
            this.stack.push(this.strings.get(name));
            return;
        }
        if (this.integers.containsKey(name)) {
            this.stack.push(this.integers.get(name));
            return;
        }
        if (this.functions.containsKey(name)) {
            this.functions.get(name).execute(context);
            return;
        }
        throw new VMException("No matching identifier found: " + name);
    }

    private void function(Tree child) {
        String name = child.getChild(0).getText();
        Tree stack = child.getChild(1);
        this.functions.put(name, new StackFunction(stack));
    }

    private void integers(Tree child) {
        Tree t = child.getChild(0);
        for (int i = 0; i < t.getChildCount(); ++i) {
            String name = t.getChild(i).getText();
            this.integers.put(name, new Integer(0));
        }
    }

    private void strings(Tree child) {
        Tree t = child.getChild(0);
        for (int i = 0; i < t.getChildCount(); ++i) {
            String name = t.getChild(i).getText();
            this.strings.put(name, null);
        }
    }

    public void push(Integer integer) {
        this.stack.push(integer);
    }

    public void push(String string) {
        this.stack.push(string);
    }

    public void push(Identifier identifier) {
        this.stack.push(identifier);
    }

    public Map<String, String> getStrings() {
        return this.strings;
    }

    public Map<String, Integer> getIntegers() {
        return this.integers;
    }

    public Vector<BstEntry> getEntries() {
        return this.entries;
    }

    public Map<String, BstFunction> getFunctions() {
        return this.functions;
    }

    public Stack<Object> getStack() {
        return this.stack;
    }

    @Override
    public void warn(String string) {
        System.out.println(string);
    }

    public class BstEntry {
        BibtexEntry entry;
        Map<String, String> strings = new HashMap<String, String>();
        Map<String, String> fields = new HashMap<String, String>();
        Map<String, Integer> integers = new HashMap<String, Integer>();

        public BstEntry(BibtexEntry e) {
            this.entry = e;
        }

        public Map<String, String> getFields() {
            return this.fields;
        }

        public BibtexEntry getBibtexEntry() {
            return this.entry;
        }
    }

    public class StackFunction
    implements BstFunction {
        Tree tree;

        public Tree getTree() {
            return this.tree;
        }

        public StackFunction(Tree stack) {
            this.tree = stack;
        }

        @Override
        public void execute(BstEntry context) {
            for (int i = 0; i < this.tree.getChildCount(); ++i) {
                Tree c = this.tree.getChild(i);
                try {
                    switch (c.getType()) {
                        case 22: {
                            String s = c.getText();
                            VM.this.push(s.substring(1, s.length() - 1));
                            break;
                        }
                        case 10: {
                            VM.this.push(new Integer(Integer.parseInt(c.getText().substring(1))));
                            break;
                        }
                        case 17: {
                            VM.this.push(new Identifier(c.getText().substring(1)));
                            break;
                        }
                        case 21: {
                            VM.this.push(c);
                            break;
                        }
                        default: {
                            VM.this.execute(c.getText(), context);
                            break;
                        }
                    }
                    continue;
                }
                catch (VMException e) {
                    if (VM.this.file != null) {
                        System.err.println("ERROR " + e.getMessage() + " (" + VM.this.file.getPath() + ":" + c.getLine() + ")");
                    } else {
                        System.err.println("ERROR " + e.getMessage() + " (" + c.getLine() + ")");
                    }
                    throw e;
                }
            }
        }
    }

    public class MacroFunction
    implements BstFunction {
        String replacement;

        public MacroFunction(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public void execute(BstEntry context) {
            VM.this.push(this.replacement);
        }
    }

    public static interface BstFunction {
        public void execute(BstEntry var1);
    }

    public class Variable {
        public String name;

        public Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public class Identifier {
        public String name;

        public Identifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

