/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
import org.apache.tools.ant.*;

import java.io.*;
import java.util.*;

public class GenerateFelixConfigs
    extends Task
{
    private File baseConfig;

    private String os;

    private File libdir;

    private File bundledir;

    private File output;

    public void setFile(File f)
    {
        baseConfig = f;
    }

    public void setOs(String os)
    {
        this.os = os;
    }

    public void setBundledir(File bundledir)
    {
        this.bundledir = bundledir;
    }

    public void setLibdir(File libdir)
    {
        this.libdir = libdir;
    }

    public void setOutput(File output)
    {
        this.output = output;
    }

    public void execute() throws BuildException
    {
        try
        {
            execute0();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    public void execute0() throws BuildException
    {
        Properties pIn = new Properties();
        Properties pOut = new Properties();
        try
        {
            pIn.load(new FileInputStream(baseConfig));
        }
        catch (FileNotFoundException e)
        {
            throw new BuildException(e);
        }
        catch (IOException e)
        {
            throw new BuildException(e);
        }

        for (Map.Entry<Object, Object> e : pIn.entrySet())
        {
            if (((String) e.getKey()).startsWith("felix.auto.start."))
            {
                String[] refs = ((String) e.getValue()).split("\\s");
                StringBuilder value = new StringBuilder();
                for (String jar : refs)
                {
                    if (jar.startsWith("reference:file:sc-bundles/"))
                    {
                        String name =
                            jar.substring("reference:file:sc-bundles/".length());
                        if (contains(
                            new File(bundledir, "os-specific/" + os).list(),
                            name))
                        {
                            value.append("@URL@/sc-bundles/");
                            value.append("os-specific/");
                            value.append(os);
                            value.append("/");
                            value.append(name);
                        }
                        else if (contains(bundledir.list(), name))
                        {
                            value.append("@URL@/sc-bundles/");
                            value.append(name);
                        }
                        else
                        {
                            log("Bundle <" + name + "> not found in <"
                                + bundledir.getName()
                                + ">. Seems like this bundle was ignored.");
                        }
                    }
                    else if (jar.startsWith("reference:file:lib/bundle/"))
                    {
                        String name =
                            jar.substring("reference:file:lib/bundle/".length());
                        if (contains(libdir.list(), name))
                        {
                            value.append("@URL@/lib/bundle/");
                            value.append(name);
                        }
                        else
                        {
                            log("Lib <" + name + "> not found in <" + libdir
                                + ">. Seems like this lib was ignored.");
                        }
                    }
                    else
                    {
                        throw new BuildException(
                            "unsupported reference prefix: " + jar);
                    }
                    value.append(" ");
                }
                pOut.put(e.getKey(), value.toString());
            }
            else
            {
                pOut.put(e.getKey(), e.getValue());
            }
        }
        try
        {
            pOut.store(new FileOutputStream(output),
                "--- autogenerated by GenerateFelixConfigs, do not edit! ---");
        }
        catch (FileNotFoundException e)
        {
            throw new BuildException(e);
        }
        catch (IOException e)
        {
            throw new BuildException(e);
        }
    }

    private boolean contains(String[] files, String file)
    {
        return Arrays.asList(files).contains(file);
    }
}
