/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.Email;
import net.sf.jml.MsnProtocol;
import net.sf.jml.Telephone;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

public class IncomingLST
extends MsnIncomingMessage {
    public IncomingLST(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    protected boolean isSupportTransactionId() {
        return false;
    }

    public Email getEmail() {
        String string = this.getParam(0);
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return Email.parseStr(string);
        }
        return Email.parseStr(string.substring(2));
    }

    public Telephone getTelephone() {
        String string = this.getParam(0);
        return Telephone.parseStr(string.substring(2));
    }

    public String getFriendlyName() {
        String string = this.getParam(1);
        if (!this.protocol.before(MsnProtocol.MSNP10)) {
            String string2 = this.getParam(1);
            if (string2 != null && string2.startsWith("F=")) {
                string = string2.substring(2);
            } else {
                if (this.getEmail() != null) {
                    return this.getEmail().getEmailAddress();
                }
                if (this.getTelephone() != null) {
                    return this.getTelephone().getTelephoneNumber();
                }
                return this.getId();
            }
        }
        return StringUtils.urlDecode(string);
    }

    public String getId() {
        String string;
        if (this.protocol.after(MsnProtocol.MSNP9) && (string = this.getParam(2)) != null && string.startsWith("C=")) {
            return string.substring(2);
        }
        return null;
    }

    public int getListNum() {
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return NumberUtils.stringToInt(this.getParam(2));
        }
        String string = this.getParam(1);
        if (string != null && string.startsWith("F=")) {
            return NumberUtils.stringToInt(this.getParam(3));
        }
        return NumberUtils.stringToInt(this.getParam(1));
    }

    public String[] getGroupId() {
        int n = this.getParamCount();
        if (n < 1) {
            return new String[0];
        }
        String string = this.getParam(this.getParamCount() - 1);
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)msnSession.getMessenger().getContactList();
        String[] stringArray = this.getGroupId();
        String string = this.getId();
        MsnContactImpl msnContactImpl = new MsnContactImpl(msnContactListImpl);
        msnContactImpl.setEmail(this.getEmail());
        msnContactImpl.setTelephone(this.getTelephone());
        if (string != null) {
            msnContactImpl.setId(string);
        } else if (msnContactImpl.getEmail() != null) {
            msnContactImpl.setId(msnContactImpl.getEmail().getEmailAddress());
        } else if (msnContactImpl.getTelephone() != null) {
            msnContactImpl.setId(msnContactImpl.getTelephone().getTelephoneNumber());
        }
        msnContactImpl.setFriendlyName(this.getFriendlyName());
        msnContactImpl.setDisplayName(msnContactImpl.getFriendlyName());
        msnContactImpl.setListNumber(this.getListNum());
        for (String string2 : stringArray) {
            msnContactImpl.addBelongGroup(string2);
        }
        msnContactListImpl.addContact(msnContactImpl);
        if (msnContactListImpl.getCurrentContactCount() == msnContactListImpl.getContactCount() && msnContactListImpl.getCurrentGroupCount() == msnContactListImpl.getGroupCount()) {
            ((AbstractMessenger)msnSession.getMessenger()).fireContactListSyncCompleted();
        }
    }
}

