/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import com.sun.media.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.media.CaptureDeviceInfo;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.RGBFormat;
import javax.media.protocol.DataSource;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.impl.neomedia.HardwareVolumeControl;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.VideoMediaStreamImpl;
import org.jitsi.impl.neomedia.codec.EncodingConfigurationConfigImpl;
import org.jitsi.impl.neomedia.codec.EncodingConfigurationImpl;
import org.jitsi.impl.neomedia.codec.FMJPlugInConfiguration;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.HFlip;
import org.jitsi.impl.neomedia.codec.video.SwScale;
import org.jitsi.impl.neomedia.device.AudioMediaDeviceImpl;
import org.jitsi.impl.neomedia.device.AudioMixerMediaDevice;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.ScreenDeviceImpl;
import org.jitsi.impl.neomedia.device.VideoTranslatorMediaDevice;
import org.jitsi.impl.neomedia.format.MediaFormatFactoryImpl;
import org.jitsi.impl.neomedia.recording.RecorderEventHandlerJSONImpl;
import org.jitsi.impl.neomedia.recording.RecorderImpl;
import org.jitsi.impl.neomedia.recording.RecorderRtpImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.sdes.SDesControlImpl;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpControlImpl;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpFortunaEntropyGatherer;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.ScreenDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.MediaFormatFactory;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.util.swing.VideoContainer;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class MediaServiceImpl
extends PropertyChangeNotifier
implements MediaService {
    private static final Logger logger = Logger.getLogger(MediaServiceImpl.class);
    public static final String DISABLE_AUDIO_SUPPORT_PNAME = "net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT";
    public static final String DISABLE_SET_AUDIO_SYSTEM_PNAME = "net.java.sip.communicator.impl.neomedia.audiosystem.DISABLED";
    public static final String DISABLE_VIDEO_SUPPORT_PNAME = "net.java.sip.communicator.service.media.DISABLE_VIDEO_SUPPORT";
    private static final String DYNAMIC_PAYLOAD_TYPE_PREFERENCES_PNAME_PREFIX = "net.java.sip.communicator.impl.neomedia.dynamicPayloadTypePreferences";
    private static final List<MediaDevice> EMPTY_DEVICES = Collections.emptyList();
    private static final String JMF_REGISTRY_DISABLE_COMMIT = "net.sf.fmj.utility.JmfRegistry.disableCommit";
    private static final String JMF_REGISTRY_DISABLE_LOAD = "net.sf.fmj.utility.JmfRegistry.disableLoad";
    private static boolean jmfRegistryDisableLoad;
    private static boolean postInitializeOnce;
    private static final String ENCODING_CONFIG_PROP_PREFIX = "net.java.sip.communicator.impl.neomedia.codec.EncodingConfiguration";
    private static final String rtpCname;
    private final DeviceConfiguration deviceConfiguration = new DeviceConfiguration();
    private final PropertyChangeListener deviceConfigurationPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            MediaServiceImpl.this.deviceConfigurationPropertyChange(event);
        }
    };
    private final List<MediaDeviceImpl> audioDevices = new ArrayList<MediaDeviceImpl>();
    private final EncodingConfiguration currentEncodingConfiguration;
    private MediaFormatFactory formatFactory;
    private MediaDevice nonSendAudioDevice;
    private MediaDevice nonSendVideoDevice;
    private final List<MediaDeviceImpl> videoDevices = new ArrayList<MediaDeviceImpl>();
    private static Map<MediaFormat, Byte> dynamicPayloadTypePreferences;
    private static VolumeControl outputVolumeControl;
    private static VolumeControl inputVolumeControl;
    private final List<Recorder.Listener> recorderListeners = new ArrayList<Recorder.Listener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaServiceImpl() {
        this.deviceConfiguration.addPropertyChangeListener(this.deviceConfigurationPropertyChangeListener);
        this.currentEncodingConfiguration = new EncodingConfigurationConfigImpl(ENCODING_CONFIG_PROP_PREFIX);
        Class<MediaServiceImpl> clazz = MediaServiceImpl.class;
        synchronized (MediaServiceImpl.class) {
            if (!postInitializeOnce) {
                postInitializeOnce = true;
                MediaServiceImpl.postInitializeOnce(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public MediaStream createMediaStream(MediaDevice device) {
        return this.createMediaStream(null, device);
    }

    @Override
    public MediaStream createMediaStream(MediaType mediaType) {
        return this.createMediaStream(mediaType, null, null, null);
    }

    @Override
    public MediaStream createMediaStream(StreamConnector connector, MediaDevice device) {
        return this.createMediaStream(connector, device, null);
    }

    @Override
    public MediaStream createMediaStream(StreamConnector connector, MediaType mediaType) {
        return this.createMediaStream(connector, mediaType, null);
    }

    @Override
    public MediaStream createMediaStream(StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        return this.createMediaStream(null, connector, device, srtpControl);
    }

    @Override
    public MediaStream createMediaStream(StreamConnector connector, MediaType mediaType, SrtpControl srtpControl) {
        return this.createMediaStream(mediaType, connector, null, srtpControl);
    }

    private MediaStream createMediaStream(MediaType mediaType, StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        if (mediaType == null) {
            if (device == null) {
                throw new NullPointerException("device");
            }
            mediaType = device.getMediaType();
        } else if (device != null && !mediaType.equals((Object)device.getMediaType())) {
            throw new IllegalArgumentException("device");
        }
        switch (mediaType) {
            case AUDIO: {
                return new AudioMediaStreamImpl(connector, device, srtpControl);
            }
            case VIDEO: {
                return new VideoMediaStreamImpl(connector, device, srtpControl);
            }
        }
        return null;
    }

    @Override
    public MediaDevice createMixer(MediaDevice device) {
        switch (device.getMediaType()) {
            case AUDIO: {
                return new AudioMixerMediaDevice((AudioMediaDeviceImpl)device);
            }
            case VIDEO: {
                return new VideoTranslatorMediaDevice((MediaDeviceImpl)device);
            }
        }
        return null;
    }

    @Override
    public MediaDevice getDefaultDevice(MediaType mediaType, MediaUseCase useCase) {
        CaptureDeviceInfo2 captureDeviceInfo;
        switch (mediaType) {
            case AUDIO: {
                captureDeviceInfo = this.getDeviceConfiguration().getAudioCaptureDevice();
                break;
            }
            case VIDEO: {
                captureDeviceInfo = this.getDeviceConfiguration().getVideoCaptureDevice(useCase);
                break;
            }
            default: {
                captureDeviceInfo = null;
            }
        }
        MediaDevice defaultDevice = null;
        if (captureDeviceInfo != null) {
            for (MediaDevice device : this.getDevices(mediaType, useCase)) {
                if (!(device instanceof MediaDeviceImpl) || !captureDeviceInfo.equals(((MediaDeviceImpl)device).getCaptureDeviceInfo())) continue;
                defaultDevice = device;
                break;
            }
        }
        if (defaultDevice == null) {
            switch (mediaType) {
                case AUDIO: {
                    defaultDevice = this.getNonSendAudioDevice();
                    break;
                }
                case VIDEO: {
                    defaultDevice = this.getNonSendVideoDevice();
                    break;
                }
            }
        }
        return defaultDevice;
    }

    public DeviceConfiguration getDeviceConfiguration() {
        return this.deviceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MediaDevice> getDevices(MediaType mediaType, MediaUseCase useCase) {
        ArrayList<MediaDevice> publicDevices;
        List<MediaDeviceImpl> privateDevices;
        List<CaptureDeviceInfo2> cdis;
        if (MediaType.VIDEO.equals((Object)mediaType)) {
            DeviceSystem.initializeDeviceSystems(MediaType.VIDEO);
        }
        switch (mediaType) {
            case AUDIO: {
                cdis = this.getDeviceConfiguration().getAvailableAudioCaptureDevices();
                privateDevices = this.audioDevices;
                break;
            }
            case VIDEO: {
                cdis = this.getDeviceConfiguration().getAvailableVideoCaptureDevices(useCase);
                privateDevices = this.videoDevices;
                break;
            }
            default: {
                return EMPTY_DEVICES;
            }
        }
        List<MediaDeviceImpl> list = privateDevices;
        synchronized (list) {
            if (cdis == null || cdis.size() <= 0) {
                privateDevices.clear();
            } else {
                Iterator<MediaDeviceImpl> deviceIter = privateDevices.iterator();
                while (deviceIter.hasNext()) {
                    Iterator<CaptureDeviceInfo2> cdiIter = cdis.iterator();
                    CaptureDeviceInfo captureDeviceInfo = deviceIter.next().getCaptureDeviceInfo();
                    boolean deviceIsFound = false;
                    while (cdiIter.hasNext()) {
                        if (!captureDeviceInfo.equals((Object)cdiIter.next())) continue;
                        deviceIsFound = true;
                        cdiIter.remove();
                        break;
                    }
                    if (deviceIsFound) continue;
                    deviceIter.remove();
                }
                for (CaptureDeviceInfo captureDeviceInfo : cdis) {
                    MediaDeviceImpl device;
                    if (captureDeviceInfo == null) continue;
                    switch (mediaType) {
                        case AUDIO: {
                            device = new AudioMediaDeviceImpl(captureDeviceInfo);
                            break;
                        }
                        case VIDEO: {
                            device = new MediaDeviceImpl(captureDeviceInfo, mediaType);
                            break;
                        }
                        default: {
                            device = null;
                        }
                    }
                    if (device == null) continue;
                    privateDevices.add(device);
                }
            }
            publicDevices = new ArrayList<MediaDevice>(privateDevices);
        }
        if (publicDevices.isEmpty()) {
            MediaDevice nonSendDevice;
            switch (mediaType) {
                case AUDIO: {
                    nonSendDevice = this.getNonSendAudioDevice();
                    break;
                }
                case VIDEO: {
                    nonSendDevice = this.getNonSendVideoDevice();
                    break;
                }
                default: {
                    nonSendDevice = null;
                }
            }
            if (nonSendDevice != null) {
                publicDevices.add(nonSendDevice);
            }
        }
        return publicDevices;
    }

    @Override
    public EncodingConfiguration getCurrentEncodingConfiguration() {
        return this.currentEncodingConfiguration;
    }

    @Override
    public MediaFormatFactory getFormatFactory() {
        if (this.formatFactory == null) {
            this.formatFactory = new MediaFormatFactoryImpl();
        }
        return this.formatFactory;
    }

    private MediaDevice getNonSendAudioDevice() {
        if (this.nonSendAudioDevice == null) {
            this.nonSendAudioDevice = new AudioMediaDeviceImpl();
        }
        return this.nonSendAudioDevice;
    }

    private MediaDevice getNonSendVideoDevice() {
        if (this.nonSendVideoDevice == null) {
            this.nonSendVideoDevice = new MediaDeviceImpl(MediaType.VIDEO);
        }
        return this.nonSendVideoDevice;
    }

    @Override
    public SrtpControl createSrtpControl(SrtpControlType srtpControlType) {
        switch (srtpControlType) {
            case DTLS_SRTP: {
                return new DtlsControlImpl();
            }
            case SDES: {
                return new SDesControlImpl();
            }
            case ZRTP: {
                return new ZrtpControlImpl();
            }
        }
        return null;
    }

    @Override
    public VolumeControl getOutputVolumeControl() {
        if (outputVolumeControl == null) {
            outputVolumeControl = new BasicVolumeControl("net.java.sip.communicator.service.media.PLAYBACK_VOLUME_LEVEL");
        }
        return outputVolumeControl;
    }

    @Override
    public VolumeControl getInputVolumeControl() {
        if (inputVolumeControl == null) {
            block5: {
                try {
                    inputVolumeControl = new HardwareVolumeControl(this, "net.java.sip.communicator.service.media.CAPTURE_VOLUME_LEVEL");
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (!(t instanceof InterruptedException)) break block5;
                    Thread.currentThread().interrupt();
                }
            }
            if (inputVolumeControl == null) {
                inputVolumeControl = new BasicVolumeControl("net.java.sip.communicator.service.media.CAPTURE_VOLUME_LEVEL");
            }
        }
        return inputVolumeControl;
    }

    @Override
    public List<ScreenDevice> getAvailableScreenDevices() {
        ScreenDevice[] screens = ScreenDeviceImpl.getAvailableScreenDevices();
        List<ScreenDevice> screenList = screens != null && screens.length != 0 ? new ArrayList<ScreenDevice>(Arrays.asList(screens)) : Collections.emptyList();
        return screenList;
    }

    @Override
    public ScreenDevice getDefaultScreenDevice() {
        return ScreenDeviceImpl.getDefaultScreenDevice();
    }

    @Override
    public Recorder createRecorder(MediaDevice device) {
        if (device instanceof AudioMixerMediaDevice) {
            return new RecorderImpl((AudioMixerMediaDevice)device);
        }
        return null;
    }

    @Override
    public Recorder createRecorder(RTPTranslator translator) {
        return new RecorderRtpImpl(translator);
    }

    @Override
    public Map<MediaFormat, Byte> getDynamicPayloadTypePreferences() {
        if (dynamicPayloadTypePreferences == null) {
            ConfigurationService cfg;
            MediaFormat h264;
            dynamicPayloadTypePreferences = new HashMap<MediaFormat, Byte>();
            MediaFormat telephoneEvent = MediaUtils.getMediaFormat("telephone-event", 8000.0);
            if (telephoneEvent != null) {
                dynamicPayloadTypePreferences.put(telephoneEvent, (byte)101);
            }
            if ((h264 = MediaUtils.getMediaFormat("H264", 90000.0)) != null) {
                dynamicPayloadTypePreferences.put(h264, (byte)99);
            }
            if ((cfg = LibJitsi.getConfigurationService()) != null) {
                String prefix = DYNAMIC_PAYLOAD_TYPE_PREFERENCES_PNAME_PREFIX;
                List<String> propertyNames = cfg.getPropertyNamesByPrefix(prefix, true);
                for (String propertyName : propertyNames) {
                    byte dynamicPayloadTypePreference = 0;
                    RuntimeException exception = null;
                    try {
                        dynamicPayloadTypePreference = Byte.parseByte(propertyName.substring(prefix.length() + 1));
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        exception = ioobe;
                    }
                    catch (NumberFormatException nfe) {
                        exception = nfe;
                    }
                    if (exception != null) {
                        logger.warn("Ignoring dynamic payload type preference which could not be parsed: " + propertyName, exception);
                        continue;
                    }
                    String source = cfg.getString(propertyName);
                    if (source == null || source.length() == 0) continue;
                    try {
                        MediaFormat mediaFormat;
                        JSONObject json = (JSONObject)JSONValue.parseWithException((String)source);
                        String encoding = (String)json.get((Object)"encoding");
                        long clockRate = (Long)json.get((Object)"clockRate");
                        HashMap<String, String> fmtps = new HashMap<String, String>();
                        if (json.containsKey((Object)"fmtps")) {
                            JSONObject jsonFmtps = (JSONObject)json.get((Object)"fmtps");
                            Iterator jsonFmtpsIter = jsonFmtps.keySet().iterator();
                            while (jsonFmtpsIter.hasNext()) {
                                String key = jsonFmtpsIter.next().toString();
                                String value = (String)jsonFmtps.get((Object)key);
                                fmtps.put(key, value);
                            }
                        }
                        if ((mediaFormat = MediaUtils.getMediaFormat(encoding, clockRate, fmtps)) == null) continue;
                        dynamicPayloadTypePreferences.put(mediaFormat, dynamicPayloadTypePreference);
                    }
                    catch (Throwable jsone) {
                        logger.warn("Ignoring dynamic payload type preference which could not be parsed: " + source, jsone);
                    }
                }
            }
        }
        return dynamicPayloadTypePreferences;
    }

    @Override
    public Object getVideoPreviewComponent(MediaDevice device, int preferredWidth, int preferredHeight) {
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        String noPreviewText = resources == null ? "" : resources.getI18NString("impl.media.configform.NO_PREVIEW");
        JLabel noPreview = new JLabel(noPreviewText);
        noPreview.setHorizontalAlignment(0);
        noPreview.setVerticalAlignment(0);
        final VideoContainer videoContainer = new VideoContainer(noPreview, false);
        if (preferredWidth > 0 && preferredHeight > 0) {
            videoContainer.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        }
        try {
            CaptureDeviceInfo captureDeviceInfo;
            if (device != null && (captureDeviceInfo = ((MediaDeviceImpl)device).getCaptureDeviceInfo()) != null) {
                DataSource dataSource = Manager.createDataSource((MediaLocator)captureDeviceInfo.getLocator());
                if (preferredWidth < 128 || preferredHeight < 96) {
                    preferredWidth = 128;
                    preferredHeight = 96;
                }
                VideoMediaStreamImpl.selectVideoSize(dataSource, preferredWidth, preferredHeight);
                dataSource.connect();
                Processor player = Manager.createProcessor((DataSource)dataSource);
                final VideoContainerHierarchyListener listener = new VideoContainerHierarchyListener(videoContainer, (Player)player);
                videoContainer.addHierarchyListener(listener);
                final MediaLocator locator = dataSource.getLocator();
                player.addControllerListener(new ControllerListener(){

                    public void controllerUpdate(ControllerEvent event) {
                        MediaServiceImpl.controllerUpdateForPreview(event, videoContainer, locator, listener);
                    }
                });
                player.configure();
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error("Failed to create video preview", t);
        }
        return videoContainer;
    }

    private static void controllerUpdateForPreview(ControllerEvent event, JComponent videoContainer, MediaLocator locator, VideoContainerHierarchyListener listener) {
        if (event instanceof ConfigureCompleteEvent) {
            Processor player = (Processor)event.getSourceController();
            TrackControl[] trackControls = player.getTrackControls();
            if (trackControls != null && trackControls.length != 0) {
                try {
                    TrackControl[] trackControlArray = trackControls;
                    int n = trackControlArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        TrackControl trackControl = trackControlArray[n2];
                        Codec[] codecs = null;
                        SwScale scaler = new SwScale();
                        codecs = "imgstreaming".equals(locator.getProtocol()) ? new Codec[]{scaler} : new Codec[]{new HFlip(), scaler};
                        trackControl.setCodecChain(codecs);
                    }
                }
                catch (UnsupportedPlugInException upiex) {
                    logger.warn("Failed to add SwScale/VideoFlipEffect to codec chain", upiex);
                }
            }
            try {
                player.setContentDescriptor(null);
            }
            catch (NotConfiguredError nce) {
                logger.error("Failed to set ContentDescriptor of Processor", nce);
            }
            player.realize();
        } else if (event instanceof RealizeCompleteEvent) {
            Player player = (Player)event.getSourceController();
            Component video = player.getVisualComponent();
            listener.setPreview(video);
            MediaServiceImpl.showPreview(videoContainer, video, player);
        }
    }

    private static void showPreview(final JComponent previewContainer, final Component preview, final Player player) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MediaServiceImpl.showPreview(previewContainer, preview, player);
                }
            });
            return;
        }
        previewContainer.removeAll();
        if (preview != null) {
            previewContainer.add(preview);
            player.start();
            if (previewContainer.isDisplayable()) {
                previewContainer.revalidate();
                previewContainer.repaint();
            } else {
                previewContainer.doLayout();
            }
        } else {
            MediaServiceImpl.disposePlayer(player);
        }
    }

    private static void disposePlayer(final Player player) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                player.stop();
                player.deallocate();
                player.close();
            }
        }).start();
    }

    @Override
    public MediaDevice getMediaDeviceForPartialDesktopStreaming(int width, int height, int x, int y) {
        MediaDeviceImpl device = null;
        String name = "Partial desktop streaming";
        Dimension size = null;
        int multiple = 0;
        Point p = new Point(x < 0 ? 0 : x, y < 0 ? 0 : y);
        ScreenDevice dev = this.getScreenForPoint(p);
        int display = -1;
        if (dev == null) {
            return null;
        }
        display = dev.getIndex();
        if (OSUtils.IS_MAC) {
            multiple = Math.round((float)width / 16.0f);
            width = multiple * 16;
        } else {
            multiple = Math.round((float)width / 2.0f);
            width = multiple * 2;
        }
        multiple = Math.round((float)height / 2.0f);
        height = multiple * 2;
        size = new Dimension(width, height);
        Format[] formats = new Format[]{new AVFrameFormat(size, -1.0f, 27, -1), new RGBFormat(size, -1, Format.byteArray, -1.0f, 32, 2, 3, 4)};
        Rectangle bounds = ((ScreenDeviceImpl)dev).getBounds();
        CaptureDeviceInfo devInfo = new CaptureDeviceInfo(name + " " + display, new MediaLocator("imgstreaming:" + display + "," + (x -= bounds.x) + "," + (y -= bounds.y)), formats);
        device = new MediaDeviceImpl(devInfo, MediaType.VIDEO);
        return device;
    }

    @Override
    public boolean isPartialStreaming(MediaDevice mediaDevice) {
        if (mediaDevice == null) {
            return false;
        }
        MediaDeviceImpl dev = (MediaDeviceImpl)mediaDevice;
        CaptureDeviceInfo cdi = dev.getCaptureDeviceInfo();
        return cdi != null && cdi.getName().startsWith("Partial desktop streaming");
    }

    public ScreenDevice getScreenForPoint(Point p) {
        for (ScreenDevice dev : this.getAvailableScreenDevices()) {
            if (!dev.containsPoint(p)) continue;
            return dev;
        }
        return null;
    }

    @Override
    public Point getOriginForDesktopStreamingDevice(MediaDevice mediaDevice) {
        MediaDeviceImpl dev = (MediaDeviceImpl)mediaDevice;
        CaptureDeviceInfo cdi = dev.getCaptureDeviceInfo();
        if (cdi == null) {
            return null;
        }
        MediaLocator locator = cdi.getLocator();
        if (!"imgstreaming".equals(locator.getProtocol())) {
            return null;
        }
        String remainder = locator.getRemainder();
        String[] split = remainder.split(",");
        int index = Integer.parseInt(split != null && split.length > 1 ? split[0] : remainder);
        List<ScreenDevice> devs = this.getAvailableScreenDevices();
        if (devs.size() - 1 >= index) {
            Rectangle r = ((ScreenDeviceImpl)devs.get(index)).getBounds();
            return new Point(r.x, r.y);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecorderListener(Recorder.Listener listener) {
        List<Recorder.Listener> list = this.recorderListeners;
        synchronized (list) {
            if (!this.recorderListeners.contains(listener)) {
                this.recorderListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRecorderListener(Recorder.Listener listener) {
        List<Recorder.Listener> list = this.recorderListeners;
        synchronized (list) {
            this.recorderListeners.remove(listener);
        }
    }

    @Override
    public Iterator<Recorder.Listener> getRecorderListeners() {
        return this.recorderListeners.iterator();
    }

    private void deviceConfigurationPropertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("captureDevice".equals(propertyName) || "notifyDevice".equals(propertyName) || "playbackDevice".equals(propertyName) || "VIDEO_CAPTURE_DEVICE".equals(propertyName)) {
            this.firePropertyChange("defaultDevice", null, null);
        }
    }

    @Override
    public RTPTranslator createRTPTranslator() {
        return new RTPTranslatorImpl();
    }

    public static boolean isJmfRegistryDisableLoad() {
        return jmfRegistryDisableLoad;
    }

    private static void postInitializeOnce(MediaServiceImpl mediaServiceImpl) {
        new ZrtpFortunaEntropyGatherer(mediaServiceImpl.getDeviceConfiguration()).setEntropy();
    }

    private static void setupFMJ() {
        ConfigurationService cfg;
        String scHomeDirName;
        String scHomeDirLocation;
        Registry.set((String)"allowLogging", (Object)true);
        if (System.getProperty(JMF_REGISTRY_DISABLE_LOAD) == null) {
            System.setProperty(JMF_REGISTRY_DISABLE_LOAD, "true");
        }
        jmfRegistryDisableLoad = "true".equalsIgnoreCase(System.getProperty(JMF_REGISTRY_DISABLE_LOAD));
        if (System.getProperty(JMF_REGISTRY_DISABLE_COMMIT) == null) {
            System.setProperty(JMF_REGISTRY_DISABLE_COMMIT, "true");
        }
        if ((scHomeDirLocation = System.getProperty("net.java.sip.communicator.SC_CACHE_DIR_LOCATION")) != null && (scHomeDirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME")) != null) {
            File scHomeDir = new File(scHomeDirLocation, scHomeDirName);
            Registry.set((String)"secure.logDir", (Object)new File(scHomeDir, "log").getPath());
            String jmfRegistryFilename = "net.sf.fmj.utility.JmfRegistry.filename";
            if (System.getProperty(jmfRegistryFilename) == null) {
                System.setProperty(jmfRegistryFilename, new File(scHomeDir, ".fmj.registry").getAbsolutePath());
            }
        }
        if ((cfg = LibJitsi.getConfigurationService()) != null) {
            for (String prop : cfg.getPropertyNamesByPrefix("net.java.sip.communicator.impl.neomedia.adaptive_jitter_buffer", true)) {
                String suffix = prop.substring(prop.lastIndexOf(".") + 1);
                Registry.set((String)("adaptive_jitter_buffer_" + suffix), (Object)cfg.getString(prop));
            }
        }
        FMJPlugInConfiguration.registerCustomPackages();
        FMJPlugInConfiguration.registerCustomCodecs();
        FMJPlugInConfiguration.registerCustomMultiplexers();
    }

    @Override
    public EncodingConfiguration createEmptyEncodingConfiguration() {
        return new EncodingConfigurationImpl();
    }

    public static boolean isMediaTypeSupportEnabled(MediaType mediaType) {
        String propertyName;
        switch (mediaType) {
            case AUDIO: {
                propertyName = DISABLE_AUDIO_SUPPORT_PNAME;
                break;
            }
            case VIDEO: {
                propertyName = DISABLE_VIDEO_SUPPORT_PNAME;
                break;
            }
            default: {
                return true;
            }
        }
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        return (cfg == null || !cfg.getBoolean(propertyName, false)) && !Boolean.getBoolean(propertyName);
    }

    @Override
    public String getRtpCname() {
        return rtpCname;
    }

    @Override
    public RecorderEventHandler createRecorderEventHandlerJson(String filename) throws IOException {
        return new RecorderEventHandlerJSONImpl(filename);
    }

    static {
        rtpCname = UUID.randomUUID().toString();
        MediaServiceImpl.setupFMJ();
    }

    private static class VideoContainerHierarchyListener
    implements HierarchyListener {
        private Window window;
        private WindowListener windowListener;
        private JComponent container;
        private Player player;
        private Component preview = null;

        VideoContainerHierarchyListener(JComponent container, Player player) {
            this.container = container;
            this.player = player;
        }

        void setPreview(Component preview) {
            this.preview = preview;
        }

        public void dispose() {
            if (this.windowListener != null) {
                if (this.window != null) {
                    this.window.removeWindowListener(this.windowListener);
                    this.window = null;
                }
                this.windowListener = null;
            }
            this.container.removeHierarchyListener(this);
            MediaServiceImpl.disposePlayer(this.player);
            if (this.preview != null) {
                this.container.remove(this.preview);
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent event) {
            if ((event.getChangeFlags() & 2L) == 0L) {
                return;
            }
            if (!this.container.isDisplayable()) {
                this.dispose();
                return;
            }
            if (this.preview != null) {
                this.player.start();
            }
            if (this.windowListener == null) {
                this.window = SwingUtilities.windowForComponent(this.container);
                if (this.window != null) {
                    this.windowListener = new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent event) {
                            VideoContainerHierarchyListener.this.dispose();
                        }
                    };
                    this.window.addWindowListener(this.windowListener);
                }
            }
        }
    }
}

