/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.profiler4j.agent.ThreadInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    private ServerUtil() {
    }

    public static ThreadInfo[] makeSerializable(java.lang.management.ThreadInfo[] mti) {
        ThreadInfo[] ti = new ThreadInfo[mti.length];
        for (int i = 0; i < ti.length; ++i) {
            ti[i] = new ThreadInfo(mti[i]);
        }
        return ti;
    }

    public static void writeStringList(ObjectOutputStream out, List<String> list) throws IOException {
        out.writeInt(list.size());
        for (String v : list) {
            out.writeUTF(v);
        }
    }

    public static List<String> readStringList(ObjectInputStream in) throws IOException {
        int n = in.readInt();
        ArrayList<String> list = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            list.add(in.readUTF());
        }
        return list;
    }

    public static Map<String, String> readStringMap(ObjectInputStream in) throws IOException {
        int n = in.readInt();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            map.put(in.readUTF(), in.readUTF());
        }
        return map;
    }

    public static void writeStringMap(ObjectOutputStream out, Map<String, String> map) throws IOException {
        out.writeInt(map.size());
        for (String v : map.keySet()) {
            out.writeUTF(v);
            out.writeUTF(map.get(v));
        }
    }

    public static void writeMemoryUsage(ObjectOutputStream out, MemoryUsage mu) throws IOException {
        out.writeLong(mu.getInit());
        out.writeLong(mu.getUsed());
        out.writeLong(mu.getCommitted());
        out.writeLong(mu.getMax());
    }

    public static MemoryUsage readMemoryUsage(ObjectInputStream in) throws IOException {
        return new MemoryUsage(in.readLong(), in.readLong(), in.readLong(), in.readLong());
    }
}

