/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardServer;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class EngineConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Lifecycle event data object {0} is not an Engine", level="WARNING")
    public static final String LIFECYCLE_EVENT_DATA_IS_NOT_ENGINE_EXCEPTION = "AS-WEB-CORE-00440";
    @LogMessageInfo(message="EngineConfig: {0}", level="WARNING")
    public static final String ENGINE_CONFIG = "AS-WEB-CORE-00441";
    @LogMessageInfo(message="EngineConfig: Processing START", level="INFO")
    public static final String ENGINE_CONFIG_PROCESSING_START_INFO = "AS-WEB-CORE-00442";
    @LogMessageInfo(message="EngineConfig: Processing STOP", level="INFO")
    public static final String ENGINE_CONFIG_PROCESSING_STOP_INFO = "AS-WEB-CORE-00443";
    private int debug = 0;
    private Engine engine = null;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            int engineDebug;
            this.engine = (Engine)((Object)event.getLifecycle());
            if (this.engine instanceof StandardEngine && (engineDebug = ((StandardEngine)this.engine).getDebug()) > this.debug) {
                this.debug = engineDebug;
            }
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString(LIFECYCLE_EVENT_DATA_IS_NOT_ENGINE_EXCEPTION), event.getLifecycle());
            this.log(msg, e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, ENGINE_CONFIG, message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + message, t, 2);
        } else {
            String msg = MessageFormat.format(rb.getString(ENGINE_CONFIG), message);
            log.log(Level.WARNING, msg, t);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(rb.getString(ENGINE_CONFIG_PROCESSING_START_INFO));
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(rb.getString(ENGINE_CONFIG_PROCESSING_STOP_INFO));
        }
    }
}

