/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

public abstract class StdKeyDeserializer
extends KeyDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _keyClass;

    protected StdKeyDeserializer(Class<?> clazz) {
        this._keyClass = clazz;
    }

    @Override
    public final Object deserializeKey(String string, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (string == null) {
            return null;
        }
        try {
            Object object = this._parse(string, deserializationContext);
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation: " + exception.getMessage());
        }
        if (this._keyClass.isEnum() && deserializationContext.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation");
    }

    public Class<?> getKeyClass() {
        return this._keyClass;
    }

    protected abstract Object _parse(String var1, DeserializationContext var2) throws Exception;

    protected int _parseInt(String string) throws IllegalArgumentException {
        return Integer.parseInt(string);
    }

    protected long _parseLong(String string) throws IllegalArgumentException {
        return Long.parseLong(string);
    }

    protected double _parseDouble(String string) throws IllegalArgumentException {
        return NumberInput.parseDouble((String)string);
    }

    @JacksonStdImpl
    static final class BoolKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        BoolKD() {
            super(Boolean.class);
        }

        @Override
        public Boolean _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            throw deserializationContext.weirdKeyException(this._keyClass, string, "value not 'true' or 'false'");
        }
    }

    @JacksonStdImpl
    static final class ByteKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        ByteKD() {
            super(Byte.class);
        }

        @Override
        public Byte _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            int n = this._parseInt(string);
            if (n < -128 || n > 255) {
                throw deserializationContext.weirdKeyException(this._keyClass, string, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)n;
        }
    }

    @JacksonStdImpl
    static final class CalendarKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected CalendarKD() {
            super(Calendar.class);
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws IllegalArgumentException, JsonMappingException {
            Date date = deserializationContext.parseDate(string);
            return date == null ? null : deserializationContext.constructCalendar(date);
        }
    }

    @JacksonStdImpl
    static final class CharKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        CharKD() {
            super(Character.class);
        }

        @Override
        public Character _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw deserializationContext.weirdKeyException(this._keyClass, string, "can only convert 1-character Strings");
        }
    }

    @JacksonStdImpl
    static final class DateKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected DateKD() {
            super(Date.class);
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws IllegalArgumentException, JsonMappingException {
            return deserializationContext.parseDate(string);
        }
    }

    static final class DelegatingKD
    extends KeyDeserializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _keyClass;
        protected final JsonDeserializer<?> _delegate;

        protected DelegatingKD(Class<?> clazz, JsonDeserializer<?> jsonDeserializer) {
            this._keyClass = clazz;
            this._delegate = jsonDeserializer;
        }

        @Override
        public final Object deserializeKey(String string, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (string == null) {
                return null;
            }
            try {
                Object obj = this._delegate.deserialize(deserializationContext.getParser(), deserializationContext);
                if (obj != null) {
                    return obj;
                }
            }
            catch (Exception exception) {
                throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation: " + exception.getMessage());
            }
            throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation");
        }

        public Class<?> getKeyClass() {
            return this._keyClass;
        }
    }

    @JacksonStdImpl
    static final class DoubleKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        DoubleKD() {
            super(Double.class);
        }

        @Override
        public Double _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            return this._parseDouble(string);
        }
    }

    @JacksonStdImpl
    static final class EnumKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final EnumResolver<?> _resolver;
        protected final AnnotatedMethod _factory;

        protected EnumKD(EnumResolver<?> enumResolver, AnnotatedMethod annotatedMethod) {
            super(enumResolver.getEnumClass());
            this._resolver = enumResolver;
            this._factory = annotatedMethod;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            Object obj;
            if (this._factory != null) {
                try {
                    return this._factory.call1(string);
                }
                catch (Exception exception) {
                    ClassUtil.unwrapAndThrowAsIAE(exception);
                }
            }
            if ((obj = this._resolver.findEnum(string)) == null && !deserializationContext.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                throw deserializationContext.weirdKeyException(this._keyClass, string, "not one of values for Enum class");
            }
            return obj;
        }
    }

    @JacksonStdImpl
    static final class FloatKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        FloatKD() {
            super(Float.class);
        }

        @Override
        public Float _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            return Float.valueOf((float)this._parseDouble(string));
        }
    }

    @JacksonStdImpl
    static final class IntKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        IntKD() {
            super(Integer.class);
        }

        @Override
        public Integer _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            return this._parseInt(string);
        }
    }

    @JacksonStdImpl
    static final class LocaleKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected JdkDeserializers.LocaleDeserializer _localeDeserializer = new JdkDeserializers.LocaleDeserializer();

        LocaleKD() {
            super(Locale.class);
        }

        @Override
        protected Locale _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            try {
                return this._localeDeserializer._deserialize(string, deserializationContext);
            }
            catch (IOException iOException) {
                throw deserializationContext.weirdKeyException(this._keyClass, string, "unable to parse key as locale");
            }
        }
    }

    @JacksonStdImpl
    static final class LongKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        LongKD() {
            super(Long.class);
        }

        @Override
        public Long _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            return this._parseLong(string);
        }
    }

    @JacksonStdImpl
    static final class ShortKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        ShortKD() {
            super(Integer.class);
        }

        @Override
        public Short _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            int n = this._parseInt(string);
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                throw deserializationContext.weirdKeyException(this._keyClass, string, "overflow, value can not be represented as 16-bit value");
            }
            return (short)n;
        }
    }

    static final class StringCtorKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final Constructor<?> _ctor;

        public StringCtorKeyDeserializer(Constructor<?> constructor) {
            super(constructor.getDeclaringClass());
            this._ctor = constructor;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws Exception {
            return this._ctor.newInstance(string);
        }
    }

    static final class StringFactoryKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        final Method _factoryMethod;

        public StringFactoryKeyDeserializer(Method method) {
            super(method.getDeclaringClass());
            this._factoryMethod = method;
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws Exception {
            return this._factoryMethod.invoke(null, string);
        }
    }

    @JacksonStdImpl
    static final class StringKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        private static final StringKD sString = new StringKD(String.class);
        private static final StringKD sObject = new StringKD(Object.class);

        private StringKD(Class<?> clazz) {
            super(clazz);
        }

        public static StringKD forType(Class<?> clazz) {
            if (clazz == String.class) {
                return sString;
            }
            if (clazz == Object.class) {
                return sObject;
            }
            return new StringKD(clazz);
        }

        @Override
        public String _parse(String string, DeserializationContext deserializationContext) throws JsonMappingException {
            return string;
        }
    }

    @JacksonStdImpl
    static final class UuidKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;

        protected UuidKD() {
            super(UUID.class);
        }

        @Override
        public Object _parse(String string, DeserializationContext deserializationContext) throws IllegalArgumentException, JsonMappingException {
            return UUID.fromString(string);
        }
    }
}

