/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.JarTheme;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeConfigurationException;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeFactory;
import com.sun.webui.theme.ThemeManager;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;

public class JarThemeFactory
implements ThemeFactory {
    private ThemeManager themeManager;
    private static final String WARNING_LOAD = "WARNING: the Sun Web Components could not load any themes.";
    private static final String WARNING_BADFILE = "WARNING: the Sun Web Components detected a corrupted theme configuration file:\n\t";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String FILENAME = "manifest-file";
    public static final String COMPONENTS_SECTION = "com/sun/webui/jsf/";
    public static final String THEME_SECTION = "com/sun/webui/jsf/theme/";
    public static final String THEME_VERSION_REQUIRED = "X-SJWUIC-Theme-Version-Required";
    public static final String THEME_VERSION = "X-SJWUIC-Theme-Version";
    public static final String NAME = "X-SJWUIC-Theme-Name";
    public static final String PREFIX = "X-SJWUIC-Theme-Prefix";
    public static final String DEFAULT = "X-SJWUIC-Theme-Default";
    public static final String STYLESHEETS = "X-SJWUIC-Theme-Stylesheets";
    public static final String JSFILES = "X-SJWUIC-Theme-JavaScript";
    public static final String CLASSMAPPER = "X-SJWUIC-Theme-ClassMapper";
    public static final String IMAGES = "X-SJWUIC-Theme-Images";
    public static final String MESSAGES = "X-SJWUIC-Theme-Messages";
    public static final String TEMPLATES = "X-SJWUIC-Theme-Templates";
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getThemeAttributes(ClassLoader classLoader) {
        Enumeration manifests = this.getManifests(classLoader);
        if (!manifests.hasMoreElements()) {
            String msg = "No Themes in the classpath!";
            throw new ThemeConfigurationException(msg);
        }
        URL url = null;
        URLConnection conn = null;
        InputStream in = null;
        Manifest manifest = null;
        Attributes themeAttributes = null;
        ArrayList<Attributes> themeProps = new ArrayList<Attributes>();
        while (manifests.hasMoreElements()) {
            url = (URL)manifests.nextElement();
            try {
                conn = url.openConnection();
                in = conn.getInputStream();
                manifest = new Manifest(in);
                themeAttributes = manifest.getAttributes(THEME_SECTION);
                if (themeAttributes == null) continue;
                themeAttributes.putValue(FILENAME, url.toString());
                themeProps.add(themeAttributes);
            }
            catch (IOException ioex) {}
            continue;
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
        }
        return themeProps.iterator();
    }

    private String readAttribute(Attributes themeAttributes, String propName) {
        String name = themeAttributes.getValue(propName);
        if (name == null || name.length() == 0) {
            String propFile = themeAttributes.getValue(FILENAME);
            StringBuffer msgBuffer = new StringBuffer(300);
            msgBuffer.append("ThemeConfiguration file ");
            if (propFile != null) {
                msgBuffer.append(propFile);
                msgBuffer.append(" ");
            }
            msgBuffer.append("does not contain required property \"");
            msgBuffer.append(propName);
            msgBuffer.append("\".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
        return name;
    }

    private void throwVersionException(String name, String version, String requiredThemeVersion) {
        StringBuffer msgBuffer = new StringBuffer(300);
        msgBuffer.append("\n\nTheme \"");
        msgBuffer.append(name);
        msgBuffer.append("\" is not up to date with the component library.\n");
        msgBuffer.append("Its version is ");
        msgBuffer.append(version);
        msgBuffer.append(". Version ");
        msgBuffer.append(requiredThemeVersion);
        msgBuffer.append(" or higher required.\n");
        throw new ThemeConfigurationException(msgBuffer.toString());
    }

    private static Application getApplication() {
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        if (factory == null) {
            return null;
        }
        return factory.getApplication();
    }

    private static Set getLocales(Application application) {
        Iterator localeIterator;
        HashSet<Locale> localeSet = new HashSet<Locale>();
        Locale locale = application.getDefaultLocale();
        if (locale != null) {
            localeSet.add(locale);
        }
        if ((localeIterator = application.getSupportedLocales()) != null) {
            while (localeIterator.hasNext()) {
                Object localeObject = localeIterator.next();
                localeSet.add((Locale)localeObject);
            }
        }
        if (localeSet.isEmpty()) {
            localeSet.add(Locale.getDefault());
        }
        return localeSet;
    }

    private String missingResourceBundleMessage(Attributes themeAttributes, String bundleName) {
        String propFile = themeAttributes.getValue(FILENAME);
        StringBuffer msgBuffer = new StringBuffer("Invalid theme configuration file for theme ");
        msgBuffer.append(themeAttributes.getValue(NAME));
        if (propFile != null) {
            msgBuffer.append(" configured by property file ");
            msgBuffer.append(propFile);
            msgBuffer.append(".");
        }
        msgBuffer.append("JarThemeFactory could not locate resource bundle at ");
        msgBuffer.append(bundleName);
        msgBuffer.append(".");
        return msgBuffer.toString();
    }

    private static String processInitParameter(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequiredThemeVersion(ClassLoader classLoader) {
        Enumeration manifests = this.getManifests(classLoader);
        if (!manifests.hasMoreElements()) {
            return null;
        }
        URL url = null;
        InputStream in = null;
        Manifest manifest = null;
        String themeVersion = null;
        while (themeVersion == null && manifests.hasMoreElements()) {
            url = (URL)manifests.nextElement();
            if (url.toString().indexOf("webui") == -1) continue;
            try {
                in = url.openConnection().getInputStream();
                manifest = new Manifest(in);
                Attributes attr = manifest.getAttributes(COMPONENTS_SECTION);
                if (attr == null) continue;
                themeVersion = attr.getValue(THEME_VERSION_REQUIRED);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
        }
        return themeVersion;
    }

    private Enumeration getManifests(ClassLoader classLoader) {
        Enumeration<URL> manifests = null;
        if (Beans.isDesignTime() && classLoader instanceof URLClassLoader) {
            Vector<URL> v = new Vector<URL>();
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                try {
                    URL manifest = new URL(url, MANIFEST);
                    InputStream is = manifest.openStream();
                    v.addElement(manifest);
                    is.close();
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return v.elements();
        }
        try {
            manifests = classLoader.getResources(MANIFEST);
        }
        catch (IOException ioex) {
            // empty catch block
        }
        if (!manifests.hasMoreElements()) {
            try {
                manifests = classLoader.getResources(MANIFEST);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return manifests;
    }

    private static void log(String s) {
        System.out.println("JarThemeFactory::" + s);
    }

    public Theme getTheme(Locale locale, ThemeContext themeContext) {
        return this.getTheme(null, locale, themeContext);
    }

    public Theme getTheme(String themeName, Locale locale, ThemeContext themeContext) {
        if (this.themeManager == null) {
            this.themeManager = this.createThemeManager(themeContext);
        }
        JarTheme theme = this.themeManager.getTheme(themeName, locale);
        theme.setThemeContext(themeContext);
        return theme;
    }

    public String getDefaultThemeName(ThemeContext themeContext) {
        if (this.themeManager == null) {
            this.themeManager = this.createThemeManager(themeContext);
        }
        return this.themeManager.getDefaultThemeName();
    }

    private ThemeManager createThemeManager(ThemeContext themeContext) {
        String defaultThemeName = themeContext.getDefaultTheme();
        String name = null;
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        String requiredThemeVersion = this.getRequiredThemeVersion(classLoader);
        Iterator themeAttributesIterator = this.getThemeAttributes(classLoader);
        if (!themeAttributesIterator.hasNext()) {
            throw new ThemeConfigurationException(WARNING_LOAD);
        }
        ThemeManager themeManager = new ThemeManager();
        while (themeAttributesIterator.hasNext()) {
            String isDefault;
            FacesContext ctx;
            Attributes themeAttributes = (Attributes)themeAttributesIterator.next();
            name = this.readAttribute(themeAttributes, NAME);
            String version = this.readAttribute(themeAttributes, THEME_VERSION);
            if (requiredThemeVersion != null && requiredThemeVersion.compareTo(version) > 0) {
                this.throwVersionException(name, version, requiredThemeVersion);
            }
            HashMap<Locale, Theme> map = new HashMap<Locale, Theme>();
            Set<Locale> localeSet = themeContext.getSupportedLocales();
            if (localeSet == null && (ctx = FacesContext.getCurrentInstance()) != null) {
                localeSet = JarThemeFactory.getLocales(ctx.getApplication());
            }
            if (localeSet == null) {
                localeSet = new HashSet<Locale>();
                localeSet.add(themeContext.getDefaultLocale());
            }
            for (Locale locale : localeSet) {
                map.put(locale, this.createTheme(themeAttributes, locale, themeContext));
            }
            themeManager.addThemeMap(name, map);
            if (defaultThemeName != null || (isDefault = themeAttributes.getValue(DEFAULT)) == null || !isDefault.toLowerCase().equals("true")) continue;
            defaultThemeName = name;
        }
        themeManager.setDefaultThemeName(defaultThemeName);
        return themeManager;
    }

    private Theme createTheme(Attributes themeAttributes, Locale locale, ThemeContext themeContext) throws ThemeConfigurationException {
        if (themeContext.getThemeServletContext() == null) {
            String prefix = this.readAttribute(themeAttributes, PREFIX);
            if (!prefix.startsWith("/")) {
                prefix = "/".concat(prefix);
            }
            themeContext.setThemeServletContext(prefix);
        }
        JarTheme theme = new JarTheme(locale);
        ResourceBundle override = null;
        ClassLoader classLoader = themeContext.getDefaultClassLoader();
        ResourceBundle bundle = this.createResourceBundle(themeAttributes, MESSAGES, locale, classLoader);
        String messageOverride = themeContext.getMessages();
        if (messageOverride != null) {
            try {
                override = ResourceBundle.getBundle(messageOverride, locale);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        theme.configureMessages(bundle, override);
        bundle = this.createResourceBundle(themeAttributes, IMAGES, locale, classLoader);
        theme.configureImages(bundle);
        bundle = this.createResourceBundle(themeAttributes, JSFILES, locale, classLoader);
        String jsFiles = this.readAttribute(themeAttributes, JSFILES);
        theme.configureJSFiles(bundle);
        bundle = this.createResourceBundle(themeAttributes, STYLESHEETS, locale, classLoader);
        theme.configureStylesheets(bundle);
        bundle = this.createResourceBundle(themeAttributes, TEMPLATES, locale, classLoader);
        theme.configureTemplates(bundle);
        String classMapper = themeAttributes.getValue(CLASSMAPPER);
        if (classMapper != null && classMapper.length() > 0) {
            bundle = this.createResourceBundle(themeAttributes, CLASSMAPPER, locale, classLoader);
            theme.configureClassMapper(bundle);
        }
        return theme;
    }

    private ResourceBundle createResourceBundle(Attributes themeAttributes, String propName, Locale locale, ClassLoader classLoader) {
        String bundleName = this.readAttribute(themeAttributes, propName);
        try {
            return ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException mre) {
            StringBuffer msgBuffer = new StringBuffer(300);
            msgBuffer.append("Invalid theme configuration file for theme ");
            msgBuffer.append(themeAttributes.getValue(NAME));
            msgBuffer.append(".\nJarThemeFactory could not locate resource bundle at ");
            msgBuffer.append(bundleName);
            msgBuffer.append(".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
    }
}

