/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.CColumnLayoutData;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.LayoutUtils;

public class WebsiteListDialog
extends Dialog {
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private TableViewer fViewer;
    private Text fWebsiteInput;
    private Button fRemoveSelectedButton;

    public WebsiteListDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label infoLabel = new Label(composite, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        infoLabel.setText(Messages.WebsiteListDialog_ENTER_WEBSITE);
        this.fWebsiteInput = new Text(composite, 2052);
        this.fWebsiteInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fWebsiteInput.setFocus();
        Button addWebsiteButton = new Button(composite, 8);
        addWebsiteButton.getShell().setDefaultButton(addWebsiteButton);
        addWebsiteButton.setText(Messages.WebsiteListDialog_ADD);
        WebsiteListDialog.applyDialogFont((Control)addWebsiteButton);
        this.setButtonLayoutData(addWebsiteButton);
        addWebsiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebsiteListDialog.this.onAdd();
            }
        });
        Composite tableContainer = new Composite(composite, 0);
        tableContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        CTable cTable = new CTable(tableContainer, 67586);
        this.fViewer = new TableViewer(cTable.getControl());
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getTable().setHeaderVisible(true);
        ((GridData)this.fViewer.getTable().getLayoutData()).heightHint = this.fViewer.getTable().getItemHeight() * 10;
        this.fViewer.getTable().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        TableColumn nameCol = new TableColumn(this.fViewer.getTable(), 0);
        CColumnLayoutData data = new CColumnLayoutData(CColumnLayoutData.Size.FILL, 100);
        cTable.manageColumn(nameCol, data, Messages.WebsiteListDialog_WEBSITE, null, null, false, false);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().toString());
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WebsiteListDialog.this.fRemoveSelectedButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.fViewer.setInput((Object)this.fPreferences.getStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS));
        WebsiteListDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        ((GridLayout)buttonBar.getLayout()).marginHeight = 0;
        ((GridLayout)buttonBar.getLayout()).marginBottom = 10;
        ((GridLayout)buttonBar.getLayout()).makeColumnsEqualWidth = false;
        ((GridData)buttonBar.getLayoutData()).horizontalAlignment = 4;
        return buttonBar;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WebsiteListDialog_JS_EXCEPTIONS);
    }

    protected int getShellStyle() {
        int style = 0x10870 | WebsiteListDialog.getDefaultOrientation();
        return style;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fRemoveSelectedButton = this.createButton(parent, -1, Messages.WebsiteListDialog_REMOVE_WEBSITE, false);
        ((GridData)this.fRemoveSelectedButton.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.fRemoveSelectedButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.fRemoveSelectedButton.setEnabled(false);
        this.fRemoveSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebsiteListDialog.this.onRemoveSelected();
            }
        });
        Button removeAllButton = this.createButton(parent, -2, Messages.WebsiteListDialog_REMOVE_ALL_WEBSITES, false);
        ((GridData)removeAllButton.getLayoutData()).horizontalAlignment = 1;
        ((GridData)removeAllButton.getLayoutData()).grabExcessHorizontalSpace = false;
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebsiteListDialog.this.onRemoveAll();
            }
        });
        Button closeButton = this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, false);
        int widthHint = ((GridData)closeButton.getLayoutData()).widthHint;
        closeButton.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        ((GridData)closeButton.getLayoutData()).widthHint = widthHint;
    }

    private void onAdd() {
        String website = StringUtils.normalizeString((String)this.fWebsiteInput.getText());
        if (StringUtils.isSet((String)website)) {
            ArrayList<String> newWebsites;
            String[] websites = this.fPreferences.getStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS);
            if (websites == null) {
                websites = new String[]{};
            }
            if (!(newWebsites = new ArrayList<String>(Arrays.asList(websites))).contains(website)) {
                newWebsites.add(website);
            }
            String[] newWebsitesArray = newWebsites.toArray(new String[newWebsites.size()]);
            this.fPreferences.putStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS, newWebsitesArray);
            this.fViewer.setInput((Object)newWebsitesArray);
        }
        this.fWebsiteInput.setText("");
        this.fWebsiteInput.setFocus();
    }

    private void onRemoveAll() {
        this.fPreferences.delete(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS);
        this.fViewer.setInput((Object)new String[0]);
    }

    private void onRemoveSelected() {
        String[] websites = this.fPreferences.getStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS);
        ArrayList<String> newWebsites = new ArrayList<String>(Arrays.asList(websites));
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List list = selection.toList();
        for (Object object : list) {
            String website = (String)object;
            newWebsites.remove(website);
        }
        String[] newWebsitesArray = newWebsites.toArray(new String[newWebsites.size()]);
        this.fPreferences.putStrings(DefaultPreferences.DISABLE_JAVASCRIPT_EXCEPTIONS, newWebsitesArray);
        this.fViewer.setInput((Object)newWebsitesArray);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

