/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.URIUtils;

public class OPMLInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("OPML");
        this.processFeed(root, feed);
    }

    private void processFeed(Element element, IFeed feed) {
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (this.processAttributeExtern(attribute, feed) || !"version".equals(name)) continue;
            feed.setFormat(this.buildFormat("OPML", attribute.getValue()));
        }
        List feedChildren = element.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("head".equals(name)) {
                this.processHead(child, feed);
                continue;
            }
            if (!"body".equals(name)) continue;
            this.processBody(child, feed);
        }
    }

    private void processHead(Element element, IFeed feed) {
        this.processNamespaceAttributes(element, feed);
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("title".equals(name)) {
                feed.setTitle(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("datecreated".equals(name)) {
                feed.setLastBuildDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("datemodified".equals(name)) {
                feed.setLastModifiedDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("owneremail".equals(name)) {
                URI uri;
                if (feed.getAuthor() == null) {
                    Owl.getModelFactory().createPerson(null, feed);
                }
                if ((uri = URIUtils.createURI(child.getText())) != null) {
                    feed.getAuthor().setEmail(uri);
                }
                this.processNamespaceAttributes(child, feed.getAuthor());
                continue;
            }
            if (!"ownername".equals(name)) continue;
            if (feed.getAuthor() == null) {
                Owl.getModelFactory().createPerson(null, feed);
            }
            feed.getAuthor().setName(child.getText());
            this.processNamespaceAttributes(child, feed.getAuthor());
        }
    }

    private void processBody(Element element, IFeed feed) {
        this.processNamespaceAttributes(element, feed);
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed) || !"outline".equals(name)) continue;
            this.processOutline(child, feed);
        }
    }

    private void processOutline(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        List outlineAttributes = element.getAttributes();
        for (Attribute attribute : outlineAttributes) {
            URI uri;
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, news)) continue;
            if ("title".equals(name)) {
                news.setTitle(attribute.getValue());
                continue;
            }
            if ("url".equals(name)) {
                uri = URIUtils.createURI(attribute.getValue());
                if (uri == null) continue;
                news.setLink(uri);
                continue;
            }
            if ("htmlurl".equals(name) && news.getLinkAsText() == null) {
                uri = URIUtils.createURI(attribute.getValue());
                if (uri == null) continue;
                news.setLink(uri);
                continue;
            }
            if ("xmlurl".equals(name)) {
                uri = URIUtils.createURI(attribute.getValue());
                if (uri == null) continue;
                ISource source = Owl.getModelFactory().createSource(news);
                source.setLink(uri);
                continue;
            }
            if ("text".equals(name)) {
                news.setDescription(attribute.getValue());
                continue;
            }
            if (!"description".equals(name)) continue;
            news.setDescription(attribute.getValue());
        }
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed) || !"outline".equals(name)) continue;
            this.processOutline(child, feed);
        }
    }
}

