/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.interpreter.EncodingException;
import org.rssowl.core.interpreter.IXMLParser;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.EntityResolver2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxParserImpl
implements IXMLParser {
    private static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    private static final String DEFAULT_DTD = "entities.dtd";

    @Override
    public void init() {
    }

    @Override
    public Document parse(InputStream inS, Map<Object, Object> properties) throws ParserException {
        Document document = null;
        Throwable ex = null;
        SAXBuilder builder = this.getBuilder();
        boolean encodingIssue = false;
        boolean usePlatformEncoding = properties != null && properties.containsKey("org.rssowl.core.internal.connection.DefaultProtocolHandler.UsePlatformEncoding");
        KeepAliveInputStream keepAliveIns = new KeepAliveInputStream(inS);
        keepAliveIns.mark(0);
        try {
            document = !usePlatformEncoding ? builder.build((InputStream)keepAliveIns) : builder.build((Reader)new InputStreamReader(keepAliveIns));
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        if (!usePlatformEncoding && this.isEncodingIssue((Exception)ex)) {
            encodingIssue = true;
            boolean reset = false;
            try {
                keepAliveIns.reset();
                reset = true;
            }
            catch (IOException iOException) {}
            if (reset) {
                try {
                    document = builder.build((Reader)new InputStreamReader(keepAliveIns));
                }
                catch (JDOMException e) {
                    ex = e;
                }
                catch (IOException e) {
                    ex = e;
                }
            }
        }
        try {
            if (ex != null && inS instanceof IAbortable) {
                ((IAbortable)((Object)inS)).abort();
            } else {
                keepAliveIns.reallyClose();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null && document == null && Activator.getDefault() != null) {
            if (!usePlatformEncoding && encodingIssue) {
                throw new EncodingException(Activator.getDefault().createErrorStatus(ex.getMessage(), ex));
            }
            throw new ParserException(Activator.getDefault().createErrorStatus(ex.getMessage(), ex));
        }
        return document;
    }

    private boolean isEncodingIssue(Exception ex) {
        if (ex == null) {
            return false;
        }
        if (ex instanceof JDOMParseException || ex instanceof UnsupportedEncodingException) {
            return true;
        }
        String name = ex.getClass().getName();
        return StringUtils.isSet(name) && name.contains("MalformedByteSequenceException");
    }

    private SAXBuilder getBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature(ALLOW_JAVA_ENCODINGS, true);
        builder.setEntityResolver((EntityResolver)new EntityResolver2(){

            public InputSource getExternalSubset(String name, String baseURI) {
                return new InputSource(this.getClass().getResourceAsStream(DefaultSaxParserImpl.DEFAULT_DTD));
            }

            public InputSource resolveEntity(String publicId, String systemId) {
                return this.resolveEntity(null, publicId, null, systemId);
            }

            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
                return new InputSource(this.getClass().getResourceAsStream(DefaultSaxParserImpl.DEFAULT_DTD));
            }
        });
        return builder;
    }

    private static class KeepAliveInputStream
    extends BufferedInputStream {
        KeepAliveInputStream(InputStream in) {
            super(in);
        }

        public void close() {
        }

        void reallyClose() throws IOException {
            super.close();
        }
    }
}

