/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.rssowl.core.IApplicationService;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.IConnectionService;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.connection.ConnectionServiceImpl;
import org.rssowl.core.internal.interpreter.InterpreterServiceImpl;
import org.rssowl.core.internal.persist.service.PersistenceServiceImpl;
import org.rssowl.core.internal.persist.service.PreferenceServiceImpl;
import org.rssowl.core.interpreter.IInterpreterService;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.service.IPersistenceService;
import org.rssowl.core.persist.service.IPreferenceService;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ExtensionUtils;
import org.rssowl.core.util.LongOperationMonitor;
import org.rssowl.core.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalOwl {
    private static final InternalOwl INSTANCE = new InternalOwl();
    private static final String MODEL_TYPESFACTORY_EXTENSION_POINT = "org.rssowl.core.ModelFactory";
    private static final String PERSISTENCE_SERVICE_EXTENSION_POINT = "org.rssowl.core.PersistenceService";
    private static final String MODEL_APPLICATION_SERVICE_EXTENSION_POINT = "org.rssowl.core.ApplicationService";
    private volatile IPreferenceService fPreferencesService;
    private volatile IConnectionService fConnectionService;
    private volatile IInterpreterService fInterpreterService;
    private volatile IPersistenceService fPersistenceService;
    private volatile IApplicationService fApplicationService;
    private volatile IModelFactory fModelFactory;
    private volatile boolean fShuttingDown;
    private volatile boolean fStarted;
    private volatile Owl.StartLevel fStartLevel = Owl.StartLevel.NOT_STARTED;
    public static volatile boolean PERF_TESTING = false;
    public static volatile boolean TESTING = false;
    public static final boolean IS_ECLIPSE = false;

    private InternalOwl() {
    }

    public void startup(LongOperationMonitor monitor, boolean emergency, boolean forRestore) {
        if (this.fStartLevel == Owl.StartLevel.NOT_STARTED) {
            this.fStartLevel = Owl.StartLevel.STARTING;
        }
        System.setErr(new PrintStream(new ByteArrayOutputStream()){

            public void write(byte[] buf, int off, int len) {
                if (buf != null && len >= 0 && off >= 0 && off <= buf.length - len) {
                    CoreUtils.appendLogMessage(new String(buf, off, len));
                }
            }
        });
        if (this.fModelFactory == null) {
            this.fModelFactory = this.loadTypesFactory();
        }
        if (this.fPersistenceService == null) {
            this.fPersistenceService = this.loadPersistenceService();
        }
        if (this.fApplicationService == null) {
            this.fApplicationService = this.loadApplicationService();
        }
        this.fPersistenceService.startup(monitor, emergency, forRestore);
        if (this.fConnectionService == null) {
            this.fConnectionService = new ConnectionServiceImpl();
        }
        if (this.fInterpreterService == null) {
            this.fInterpreterService = new InterpreterServiceImpl();
        }
        if (this.fPreferencesService == null) {
            this.fPreferencesService = new PreferenceServiceImpl();
        }
        this.fStarted = true;
        this.fStartLevel = Owl.StartLevel.STARTED;
    }

    public void setStartLevel(Owl.StartLevel level) {
        if (level.ordinal() > this.fStartLevel.ordinal()) {
            this.fStartLevel = level;
        }
    }

    public Owl.StartLevel getStartLevel() {
        return this.fStartLevel;
    }

    public static InternalOwl getDefault() {
        return INSTANCE;
    }

    public boolean isStarted() {
        return this.fStarted;
    }

    public void shutdown(boolean emergency) {
        this.fShuttingDown = true;
        if (!emergency && this.fConnectionService != null) {
            try {
                this.fConnectionService.shutdown();
            }
            catch (Exception e) {
                Activator.safeLogError(e.getMessage(), e);
            }
        }
        if (this.fPersistenceService != null) {
            this.fPersistenceService.shutdown(emergency);
        }
        this.fStartLevel = Owl.StartLevel.NOT_STARTED;
    }

    public boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    public IApplicationService getApplicationService() {
        return this.fApplicationService;
    }

    private IApplicationService loadApplicationService() {
        return (IApplicationService)ExtensionUtils.loadSingletonExecutableExtension(MODEL_APPLICATION_SERVICE_EXTENSION_POINT);
    }

    public IPreferenceService getPreferenceService() {
        return this.fPreferencesService;
    }

    public IPersistenceService getPersistenceService() {
        return this.fPersistenceService;
    }

    private IPersistenceService loadPersistenceService() {
        return (IPersistenceService)ExtensionUtils.loadSingletonExecutableExtension(PERSISTENCE_SERVICE_EXTENSION_POINT);
    }

    public IConnectionService getConnectionService() {
        return this.fConnectionService;
    }

    public IInterpreterService getInterpreter() {
        return this.fInterpreterService;
    }

    public IModelFactory getModelFactory() {
        return this.fModelFactory;
    }

    public Pair<File, Long> getProfile() {
        return ((PersistenceServiceImpl)this.fPersistenceService).getProfile();
    }

    public List<File> getProfileBackups() {
        return ((PersistenceServiceImpl)this.fPersistenceService).getProfileBackups();
    }

    public void restoreProfile(File backup) throws PersistenceException {
        ((PersistenceServiceImpl)this.fPersistenceService).restoreProfile(backup);
        this.fPersistenceService.getModelSearch().reIndexOnNextStartup();
    }

    public void recreateProfile(boolean needsEmergencyStartup) throws PersistenceException {
        ((PersistenceServiceImpl)this.fPersistenceService).recreateProfile(needsEmergencyStartup);
    }

    private IModelFactory loadTypesFactory() {
        return (IModelFactory)ExtensionUtils.loadSingletonExecutableExtension(MODEL_TYPESFACTORY_EXTENSION_POINT);
    }
}

