/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal;

import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.rssowl.core.Owl;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;

public class Activator
extends Plugin {
    private static final String CORE_NET_BUNDLE = "org.eclipse.core.net";
    private static Activator fgPlugin;
    private BundleContext fContext;
    private String fVersion;
    private IProxyService fProxyService;
    private String fNl;

    public Activator() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fContext = context;
        this.fVersion = (String)fgPlugin.getBundle().getHeaders().get("Bundle-Version");
        this.fNl = System.getProperty("line.separator");
        if (!StringUtils.isSet(this.fNl)) {
            this.fNl = "\n";
        }
        System.setProperty("org.apache.commons.logging.Log", "org.rssowl.core.internal.LogBridge");
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                Activator.this.fProxyService = Activator.this.loadProxyService();
            }
        });
    }

    private IProxyService loadProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)CORE_NET_BUNDLE);
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName())) != null) {
            return (IProxyService)bundle.getBundleContext().getService(ref);
        }
        if (this.fProxyService == null) {
            this.logError("Proxy service could not be found.", null);
        }
        return null;
    }

    public IProxyService getProxyService() {
        return this.fProxyService;
    }

    public void stop(BundleContext context) throws Exception {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                Owl.shutdown(false);
            }
        });
        String logMessages = CoreUtils.getAndFlushLogMessages();
        if (logMessages != null && logMessages.length() > 0) {
            Activator.safeLogError(logMessages, null);
        }
        this.logInfo("RSSOwl Shutting Down (normal)" + this.fNl);
        super.stop(context);
        this.fContext = null;
        fgPlugin = null;
    }

    public static Activator getDefault() {
        return fgPlugin;
    }

    public BundleContext getContext() {
        return this.fContext;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public static void safeLogError(String msg, Throwable e) {
        if (fgPlugin != null) {
            fgPlugin.logError(msg, e);
        }
    }

    public static void safeLogInfo(String msg) {
        if (fgPlugin != null) {
            fgPlugin.logInfo(msg);
        }
    }

    public void logError(String msg, Throwable e) {
        if (msg == null) {
            msg = "";
        }
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 4, msg, e));
    }

    public void logInfo(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.getLog().log((IStatus)new Status(1, this.getBundle().getSymbolicName(), 0, msg, null));
    }

    public IStatus createInfoStatus(String msg, Exception e) {
        return new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, msg, (Throwable)e);
    }

    public IStatus createWarningStatus(String msg, Exception e) {
        return new Status(2, this.getBundle().getSymbolicName(), 2, msg, (Throwable)e);
    }

    public IStatus createErrorStatus(String msg, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 4, msg, e);
    }
}

