/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelManager
implements EventDispatcher,
EventListener,
StartLevel {
    protected static Framework framework;
    protected static EventManager eventManager;
    protected static EventListeners startLevelListeners;
    protected int frameworkBeginningStartLevel = 1;
    protected int initialBundleStartLevel = 1;
    private int activeSL = 0;
    private final Object lock = new Object();
    private volatile boolean settingStartLevel = false;

    protected StartLevelManager(Framework framework) {
        StartLevelManager.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = StartLevelManager.framework.adaptor.getInitialBundleStartLevel();
        String value = framework.getProperty("osgi.framework.beginningstartlevel");
        if (value == null) {
            value = "1";
        } else {
            try {
                if (Integer.parseInt(value) <= 0) {
                    System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                    value = "1";
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                value = "1";
            }
        }
        framework.setProperty("osgi.framework.beginningstartlevel", value);
        this.frameworkBeginningStartLevel = Integer.parseInt(value);
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new EventListeners();
        startLevelListeners.addListener(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.removeAllListeners();
        startLevelListeners = null;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkBeginningStartLevel;
    }

    public void setInitialBundleStartLevel(int startlevel) {
        framework.checkAdminPermission(StartLevelManager.framework.systemBundle, "startlevel");
        if (startlevel <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialBundleStartLevel = startlevel;
        StartLevelManager.framework.adaptor.setInitialBundleStartLevel(startlevel);
    }

    public int getStartLevel() {
        return this.activeSL;
    }

    public void setStartLevel(int newSL, Bundle callerBundle) {
        if (newSL <= 0) {
            throw new IllegalArgumentException(NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + newSL));
        }
        framework.checkAdminPermission(StartLevelManager.framework.systemBundle, "startlevel");
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("StartLevelImpl: setStartLevel: " + newSL + "; callerBundle = " + callerBundle.getBundleId());
        }
        this.issueEvent(new StartLevelEvent(1, newSL, (AbstractBundle)callerBundle));
    }

    public void setStartLevel(int newSL) {
        this.setStartLevel(newSL, StartLevelManager.framework.systemBundle);
    }

    protected void launch(int startlevel) {
        this.doSetStartLevel(startlevel);
    }

    protected void shutdown() {
        this.doSetStartLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetStartLevel(int newSL) {
        Object object = this.lock;
        synchronized (object) {
            this.settingStartLevel = true;
            try {
                int tempSL = this.activeSL;
                if (newSL > tempSL) {
                    boolean launching;
                    boolean bl = launching = tempSL == 0;
                    if (launching) {
                        this.loadInstalledBundles(this.getInstalledBundles(StartLevelManager.framework.bundles, false));
                        try {
                            StartLevelManager.framework.systemBundle.state = 8;
                            StartLevelManager.framework.systemBundle.context.start();
                            framework.publishBundleEvent(128, StartLevelManager.framework.systemBundle);
                            StartLevelManager.framework.systemBundle.state = 32;
                        }
                        catch (BundleException be) {
                            if (Debug.DEBUG_STARTLEVEL) {
                                Debug.println("SLL: Bundle resume exception: " + be.getMessage());
                                Debug.printStackTrace(be.getNestedException() == null ? be : be.getNestedException());
                            }
                            framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, be);
                            throw new RuntimeException(be.getMessage());
                        }
                    }
                    int i = tempSL;
                    while (i < newSL) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - incrementing Startlevel from " + tempSL);
                        }
                        ++tempSL;
                        this.incFWSL(i + 1, this.getInstalledBundles(StartLevelManager.framework.bundles, false));
                        ++i;
                    }
                    if (launching) {
                        framework.publishBundleEvent(2, StartLevelManager.framework.systemBundle);
                        framework.publishFrameworkEvent(1, StartLevelManager.framework.systemBundle, null);
                    }
                } else {
                    AbstractBundle[] sortedBundles = this.getInstalledBundles(StartLevelManager.framework.bundles, true);
                    int i = tempSL;
                    while (i > newSL) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - decrementing Startlevel from " + tempSL);
                        }
                        --tempSL;
                        this.decFWSL(i - 1, sortedBundles);
                        --i;
                    }
                }
                framework.publishFrameworkEvent(8, StartLevelManager.framework.systemBundle, null);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
                }
            }
            finally {
                this.settingStartLevel = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveActiveStartLevel(int newSL) {
        Object object = this.lock;
        synchronized (object) {
            this.activeSL = newSL;
        }
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return (((AbstractBundle)bundle).getBundleData().getStatus() & 1) != 0;
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return (((AbstractBundle)bundle).getBundleData().getStatus() & 4) != 0;
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return ((AbstractBundle)bundle).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, int newSL) {
        block11: {
            String exceptionText = null;
            if (bundle.getBundleId() == 0L) {
                exceptionText = Msg.STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL;
            } else if (bundle.getState() == 1) {
                exceptionText = NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation());
            } else if (newSL <= 0) {
                exceptionText = NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + newSL);
            }
            if (exceptionText != null) {
                throw new IllegalArgumentException(exceptionText);
            }
            framework.checkAdminPermission(bundle, "execute");
            try {
                if (newSL == ((AbstractBundle)bundle).getStartLevel()) break block11;
                final AbstractBundle b = (AbstractBundle)bundle;
                b.getBundleData().setStartLevel(newSL);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            b.getBundleData().save();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (e.getException() instanceof IOException) {
                        throw (IOException)e.getException();
                    }
                    throw (RuntimeException)e.getException();
                }
                this.issueEvent(new StartLevelEvent(0, newSL, (AbstractBundle)bundle));
            }
            catch (IOException e) {
                framework.publishFrameworkEvent(2, bundle, e);
            }
        }
    }

    private void issueEvent(StartLevelEvent sle) {
        ListenerQueue queue = new ListenerQueue(eventManager);
        queue.queueListeners(startLevelListeners, this);
        queue.dispatchEventAsynchronous(sle.getType(), sle);
    }

    public void dispatchEvent(Object listener, Object listenerObject, int eventAction, Object eventObject) {
        try {
            switch (eventAction) {
                case 0: {
                    this.setBundleSL((StartLevelEvent)eventObject);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(((StartLevelEvent)eventObject).getNewSL());
                }
            }
        }
        catch (Throwable t) {
            StartLevelManager.framework.adaptor.handleRuntimeError(t);
        }
    }

    protected void incFWSL(int incToSL, AbstractBundle[] launchBundles) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: incFWSL: saving activeSL of " + incToSL);
        }
        this.saveActiveStartLevel(incToSL);
        this.resumeBundles(launchBundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBundle[] getInstalledBundles(BundleRepository bundles, boolean sortByDependency) {
        Object[] installedBundles;
        BundleRepository bundleRepository = bundles;
        synchronized (bundleRepository) {
            List allBundles = bundles.getBundles();
            installedBundles = new AbstractBundle[allBundles.size()];
            allBundles.toArray(installedBundles);
            Util.sort(installedBundles, 0, installedBundles.length);
            if (sortByDependency) {
                StartLevelManager.sortByDependency((AbstractBundle[])installedBundles);
            }
        }
        return installedBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sortByDependency(AbstractBundle[] bundles) {
        BundleRepository bundleRepository = StartLevelManager.framework.bundles;
        synchronized (bundleRepository) {
            if (bundles.length <= 1) {
                return;
            }
            int currentSL = bundles[0].getStartLevel();
            int currentSLindex = 0;
            boolean lazy = false;
            int i = 0;
            while (i < bundles.length) {
                if (currentSL != bundles[i].getStartLevel()) {
                    if (lazy) {
                        StartLevelManager.sortByDependencies(bundles, currentSLindex, i);
                    }
                    currentSL = bundles[i].getStartLevel();
                    currentSLindex = i;
                    lazy = false;
                }
                lazy |= (bundles[i].getBundleData().getStatus() & 2) != 0;
                ++i;
            }
            if (lazy) {
                StartLevelManager.sortByDependencies(bundles, currentSLindex, bundles.length);
            }
        }
    }

    private static void sortByDependencies(AbstractBundle[] bundles, int start, int end) {
        if (end - start <= 1) {
            return;
        }
        ArrayList<BundleDescription> descList = new ArrayList<BundleDescription>(end - start);
        ArrayList<AbstractBundle> missingDescs = new ArrayList<AbstractBundle>(0);
        int i = start;
        while (i < end) {
            BundleDescription desc = bundles[i].getBundleDescription();
            if (desc != null) {
                descList.add(desc);
            } else {
                missingDescs.add(bundles[i]);
            }
            ++i;
        }
        if (descList.size() <= 1) {
            return;
        }
        BundleDescription[] descriptions = descList.toArray(new BundleDescription[descList.size()]);
        StartLevelManager.framework.adaptor.getPlatformAdmin().getStateHelper().sortBundles(descriptions);
        int i2 = start;
        while (i2 < descriptions.length + start) {
            bundles[i2] = StartLevelManager.framework.bundles.getBundle(descriptions[i2 - start].getBundleId());
            ++i2;
        }
        if (missingDescs.size() > 0) {
            Iterator missing = missingDescs.iterator();
            int i3 = start + descriptions.length;
            while (i3 < end && missing.hasNext()) {
                bundles[i3] = (AbstractBundle)missing.next();
                ++i3;
            }
        }
    }

    private void loadInstalledBundles(AbstractBundle[] installedBundles) {
        int i = 0;
        while (i < installedBundles.length) {
            AbstractBundle bundle = installedBundles[i];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Trying to load bundle " + bundle);
            }
            bundle.load();
            ++i;
        }
    }

    private void resumeBundles(AbstractBundle[] launch) {
        int fwsl = this.getStartLevel();
        int i = 0;
        while (i < launch.length && !framework.isForcedRestart()) {
            int bsl = launch[i].getStartLevel();
            if (bsl >= fwsl) {
                if (bsl != fwsl) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Active sl = " + fwsl + "; Bundle " + launch[i].getBundleId() + " sl = " + bsl);
                }
                framework.resumeBundle(launch[i]);
            }
            ++i;
        }
    }

    protected void decFWSL(int decToSL, AbstractBundle[] shutdown) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: decFWSL: saving activeSL of " + decToSL);
        }
        this.saveActiveStartLevel(decToSL);
        if (decToSL == 0) {
            this.suspendAllBundles(StartLevelManager.framework.bundles);
            this.unloadAllBundles(StartLevelManager.framework.bundles);
            return;
        }
        int i = shutdown.length - 1;
        while (i >= 0) {
            int bsl = shutdown[i].getStartLevel();
            if (bsl <= decToSL + 1) {
                if (bsl <= decToSL) break;
                if (shutdown[i].isActive()) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopping bundle " + shutdown[i].getBundleId());
                    }
                    framework.suspendBundle(shutdown[i], false);
                }
            }
            --i;
        }
    }

    private void suspendAllBundles(BundleRepository bundles) {
        boolean changed;
        do {
            changed = false;
            AbstractBundle[] shutdown = this.getInstalledBundles(bundles, false);
            int i = shutdown.length - 1;
            while (i >= 0) {
                AbstractBundle bundle = shutdown[i];
                if (framework.suspendBundle(bundle, false)) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopped bundle " + bundle.getBundleId());
                    }
                    changed = true;
                }
                --i;
            }
        } while (changed);
        try {
            StartLevelManager.framework.systemBundle.context.stop();
        }
        catch (BundleException sbe) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle suspend exception: " + sbe.getMessage());
                Debug.printStackTrace(sbe.getNestedException() == null ? sbe : sbe.getNestedException());
            }
            framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, sbe);
        }
        StartLevelManager.framework.systemBundle.state = 4;
        framework.publishBundleEvent(4, StartLevelManager.framework.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllBundles(BundleRepository bundles) {
        BundleRepository bundleRepository = bundles;
        synchronized (bundleRepository) {
            List allBundles = bundles.getBundles();
            int size = allBundles.size();
            int i = 0;
            while (i < size) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to unload bundle " + bundle);
                }
                bundle.refresh();
                try {
                    bundle.getBundleData().close();
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = this.lock;
        synchronized (object) {
            int currentSL = this.getStartLevel();
            int newSL = startLevelEvent.getNewSL();
            AbstractBundle bundle = startLevelEvent.getBundle();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print("SLL: bundle active=" + bundle.isActive());
                Debug.print("; newSL = " + newSL);
                Debug.println("; activeSL = " + currentSL);
            }
            if (bundle.isActive() && newSL > currentSL) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: stopping bundle " + bundle.getBundleId());
                }
                framework.suspendBundle(bundle, false);
            } else if (!bundle.isActive() && newSL <= currentSL) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: starting bundle " + bundle.getBundleId());
                }
                framework.resumeBundle(bundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle Startlevel set to " + newSL);
            }
        }
    }

    public boolean isSettingStartLevel() {
        return this.settingStartLevel;
    }
}

