/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.convert.conversions;

import com.db4o.MetaIndex;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.convert.Conversion;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.FileHeader0;

public class FieldIndexesToBTrees_5_7
extends Conversion {
    public static final int VERSION = 6;

    public void convert(ConversionStage.SystemUpStage systemUpStage) {
        systemUpStage.file().classCollection().writeAllClasses();
        this.rebuildUUIDIndex(systemUpStage.file());
        this.freeOldUUIDMetaIndex(systemUpStage.file());
    }

    private void rebuildUUIDIndex(LocalObjectContainer localObjectContainer) {
        UUIDFieldMetadata uUIDFieldMetadata = localObjectContainer.getUUIDIndex();
        ClassMetadataIterator classMetadataIterator = localObjectContainer.classCollection().iterator();
        while (classMetadataIterator.moveNext()) {
            ClassMetadata classMetadata = classMetadataIterator.currentClass();
            if (!classMetadata.generateUUIDs()) continue;
            uUIDFieldMetadata.rebuildIndexForClass(localObjectContainer, classMetadata);
        }
    }

    private void freeOldUUIDMetaIndex(LocalObjectContainer localObjectContainer) {
        FileHeader fileHeader = localObjectContainer.getFileHeader();
        if (!(fileHeader instanceof FileHeader0)) {
            return;
        }
        MetaIndex metaIndex = ((FileHeader0)fileHeader).getUUIDMetaIndex();
        if (metaIndex == null) {
            return;
        }
        localObjectContainer.free(metaIndex.indexAddress, metaIndex.indexLength);
    }
}

