/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.BlobStatus;
import com.db4o.BlobTransport;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.types.Blob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class BlobImpl
implements Blob,
Cloneable,
Db4oTypeImpl {
    public static final int COPYBUFFER_LENGTH = 4096;
    public String fileName;
    public String i_ext;
    private transient File i_file;
    private transient BlobStatus i_getStatusFrom;
    public int i_length;
    private transient double i_status = -1.0;
    private transient ObjectContainerBase i_stream;
    private transient Transaction i_trans;

    public int adjustReadDepth(int n) {
        return 1;
    }

    public boolean canBind() {
        return true;
    }

    private String checkExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            this.i_ext = string.substring(n);
            return string.substring(0, n);
        }
        this.i_ext = "";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, File file2) throws IOException {
        file2.delete();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                byte[] byArray = new byte[4096];
                int n = -1;
                while ((n = bufferedInputStream.read(byArray)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            bufferedInputStream.close();
        }
    }

    public Object createDefault(Transaction transaction) {
        BlobImpl blobImpl = null;
        try {
            blobImpl = (BlobImpl)this.clone();
            blobImpl.setTrans(transaction);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return blobImpl;
    }

    public FileInputStream getClientInputStream() throws Exception {
        return new FileInputStream(this.i_file);
    }

    public FileOutputStream getClientOutputStream() throws Exception {
        return new FileOutputStream(this.i_file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLength() {
        return this.i_length;
    }

    public double getStatus() {
        if (this.i_status == -5.0 && this.i_getStatusFrom != null) {
            return this.i_getStatusFrom.getStatus();
        }
        if (this.i_status == -1.0 && this.i_length > 0) {
            this.i_status = -2.0;
        }
        return this.i_status;
    }

    public void getStatusFrom(BlobStatus blobStatus) {
        this.i_getStatusFrom = blobStatus;
    }

    public boolean hasClassIndex() {
        return false;
    }

    public void readFrom(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(Messages.get(41, file.getAbsolutePath()));
        }
        this.i_length = (int)file.length();
        this.checkExt(file);
        if (this.i_stream.isClient()) {
            this.i_file = file;
            ((BlobTransport)((Object)this.i_stream)).readBlobFrom(this.i_trans, this, file);
        } else {
            this.readLocal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLocal(File file) throws IOException {
        Object object;
        boolean bl = false;
        if (this.fileName == null && !((File)(object = new File(this.serverPath(), file.getName()))).exists()) {
            this.copy(file, (File)object);
            bl = true;
            this.fileName = ((File)object).getName();
        }
        if (!bl) {
            this.copy(file, this.serverFile(this.checkExt(file), true));
        }
        object = this.i_stream.i_lock;
        synchronized (object) {
            this.i_stream.setInternal(this.i_trans, this, false);
        }
        this.i_status = -4.0;
    }

    public void preDeactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File serverFile(String string, boolean bl) throws IOException {
        String string2;
        Object object = this.i_stream.i_lock;
        synchronized (object) {
            this.i_stream.activate1(this.i_trans, this, 2);
        }
        object = this.serverPath();
        this.i_stream.configImpl().ensureDirExists((String)object);
        if (bl) {
            if (this.fileName == null) {
                this.fileName = string != null ? string : "b_" + System.currentTimeMillis();
                string2 = this.fileName + this.i_ext;
                int n = 0;
                while (new File((String)object, string2).exists()) {
                    string2 = this.fileName + "_" + n++ + this.i_ext;
                    if (n != 99) continue;
                    this.i_status = -99.0;
                    throw new IOException(Messages.get(40));
                }
                this.fileName = string2;
                Object object2 = this.i_stream.i_lock;
                synchronized (object2) {
                    this.i_stream.setInternal(this.i_trans, this, false);
                }
            }
        } else if (this.fileName == null) {
            throw new IOException(Messages.get(38));
        }
        string2 = (String)object + File.separator + this.fileName;
        if (!bl && !new File(string2).exists()) {
            throw new IOException(Messages.get(39));
        }
        return new File(string2);
    }

    private String serverPath() throws IOException {
        String string = this.i_stream.configImpl().blobPath();
        if (string == null) {
            string = "blobs";
        }
        this.i_stream.configImpl().ensureDirExists(string);
        return string;
    }

    public void setStatus(double d) {
        this.i_status = d;
    }

    public void setTrans(Transaction transaction) {
        this.i_trans = transaction;
        this.i_stream = transaction.stream();
    }

    public void writeLocal(File file) throws IOException {
        this.copy(this.serverFile(null, false), file);
        this.i_status = -4.0;
    }

    public void writeTo(File file) throws IOException {
        if (this.getStatus() == -1.0) {
            throw new IOException(Messages.get(43));
        }
        if (this.i_stream.isClient()) {
            this.i_file = file;
            this.i_status = -3.0;
            ((BlobTransport)((Object)this.i_stream)).writeBlobTo(this.i_trans, this, file);
        } else {
            this.writeLocal(file);
        }
    }

    public void replicateFrom(Object object) {
    }

    public Object storedTo(Transaction transaction) {
        return this;
    }

    public void setYapObject(ObjectReference objectReference) {
    }
}

