/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSUtils;
import org.jsampler.LSConsoleModel;
import org.jsampler.Server;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.SessionViewConfig;
import org.jsampler.view.fantasia.A4n;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.LSConsoleFrame;
import org.jsampler.view.fantasia.LSConsolePane;
import org.jsampler.view.fantasia.LeftSidePane;
import org.jsampler.view.fantasia.MainPane;
import org.jsampler.view.fantasia.MenuManager;
import org.jsampler.view.fantasia.PianoKeyboardPane;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.RightSidePane;
import org.jsampler.view.fantasia.StandardBar;
import org.jsampler.view.fantasia.ViewConfig;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;
import org.jsampler.view.std.JSBackendLogFrame;
import org.jsampler.view.std.JSConnectDlg;
import org.jsampler.view.std.JSDetailedErrorDlg;
import org.jsampler.view.std.JSQuitDlg;
import org.jsampler.view.std.JSamplerHomeChooser;
import org.jsampler.view.std.StdA4n;
import org.jsampler.view.std.StdMainFrame;
import org.jsampler.view.std.StdUtils;

public class MainFrame
extends StdMainFrame {
    public static final int MAX_CHANNEL_LANE_NUMBER = 8;
    private final StandardBar standardBar = new StandardBar();
    private final FantasiaMenuBar menuBar = new FantasiaMenuBar();
    private final JPanel rootPane = new RootPane();
    private final BottomPane bottomPane;
    private final MainPane mainPane;
    private final PianoKeyboardPane pianoKeyboardPane;
    private final JMenu recentScriptsMenu = new JMenu(FantasiaI18n.i18n.getMenuLabel("actions.recentScripts"));
    private final JSplitPane hSplitPane;
    private final LeftSidePane leftSidePane;
    private final RightSidePane rightSidePane;
    private final JPanel rightPane;
    private final LSConsoleFrame lsConsoleFrame = new LSConsoleFrame();
    private final Vector<String> recentScripts = new Vector();
    private final JSBackendLogFrame backendLogFrame = new JSBackendLogFrame();
    private final JCheckBoxMenuItem cbmiToolBarVisible = new JCheckBoxMenuItem(FantasiaI18n.i18n.getMenuLabel("view.toolBar"));
    private final JCheckBoxMenuItem cbmiLeftSidePaneVisible = new JCheckBoxMenuItem(FantasiaI18n.i18n.getMenuLabel("view.leftSidePane"));
    private final JCheckBoxMenuItem cbmiRightSidePaneVisible = new JCheckBoxMenuItem(FantasiaI18n.i18n.getMenuLabel("view.rightSidePane"));
    private final JCheckBoxMenuItem cbmiMidiKeyboardVisible = new JCheckBoxMenuItem(FantasiaI18n.i18n.getMenuLabel("view.midiKeyboard"));
    private final Timer guiTimer = new Timer(1000, null);

    public MainFrame() {
        this.setTitle(FantasiaI18n.i18n.getLabel("MainFrame.title"));
        if (Res.iconAppIcon != null) {
            this.setIconImage(Res.iconAppIcon.getImage());
        }
        CC.setMainFrame(this);
        this.mainPane = new MainPane();
        this.leftSidePane = new LeftSidePane();
        this.rightSidePane = new RightSidePane();
        this.setSelectedChannelsPane(this.mainPane.getChannelsPane(0));
        this.getContentPane().add((Component)this.standardBar, "North");
        this.rightPane = this.createRightPane();
        this.hSplitPane = new JSplitPane(1, true, this.leftSidePane, this.rightPane);
        this.hSplitPane.setResizeWeight(0.5);
        this.pianoKeyboardPane = new PianoKeyboardPane();
        for (int i = 0; i < this.mainPane.getChannelsPaneCount(); ++i) {
            this.addChannelsPane(this.mainPane.getChannelsPane(i));
            this.getChannelsPane(i).addListSelectionListener(this.pianoKeyboardPane);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MainFrame.this.onChangeChannelLaneCount();
            }
        };
        FantasiaPrefs.preferences().addPropertyChangeListener("channelLanes.count", propertyChangeListener);
        int n = FantasiaPrefs.preferences().getIntProperty("midiKeyboard.height");
        this.setMidiKeyboardHeight(n);
        propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = FantasiaPrefs.preferences().getIntProperty("midiKeyboard.height");
                MainFrame.this.setMidiKeyboardHeight(n);
            }
        };
        CC.preferences().addPropertyChangeListener("midiKeyboard.height", propertyChangeListener);
        this.bottomPane = new BottomPane();
        this.hSplitPane.setOpaque(false);
        this.rootPane.add(this.hSplitPane);
        this.rootPane.add((Component)this.bottomPane, "South");
        this.add(this.rootPane);
        if (CC.isMacOS()) {
            try {
                String string = "org.jsampler.view.fantasia.MacOSApplicationHandler";
                Class.forName(string).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.addMenu();
        if (CC.getViewConfig().isUsingScreenMenuBar()) {
            ((ViewConfig)CC.getViewConfig()).restoreMenuProperties();
        }
        int n2 = FantasiaPrefs.preferences().getIntProperty("MainFrame.hSplitDividerLocation", 220);
        this.hSplitPane.setDividerLocation(n2);
        this.setSavedSize();
        this.guiTimer.start();
    }

    private JPanel createRightPane() {
        FantasiaPanel fantasiaPanel = new FantasiaPanel();
        fantasiaPanel.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        fantasiaPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagLayout.setConstraints(this.rightSidePane, gridBagConstraints);
        fantasiaPanel.add(this.rightSidePane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.fill = 3;
        gridBagLayout.setConstraints(this.mainPane, gridBagConstraints);
        fantasiaPanel.add(this.mainPane);
        return fantasiaPanel;
    }

    private void setSavedSize() {
        Rectangle rectangle = StdUtils.getWindowBounds("MainFrame");
        if (rectangle == null) {
            this.setDefaultSizeAndLocation();
            return;
        }
        this.setBounds(rectangle);
    }

    private void setDefaultSizeAndLocation() {
        this.setPreferredSize(new Dimension(900, 600));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void onWindowClose() {
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("confirmAppQuit");
        if (bl && CC.getSamplerModel().isModified()) {
            JSQuitDlg jSQuitDlg = new JSQuitDlg(Res.iconQuestion32);
            jSQuitDlg.setVisible(true);
            if (jSQuitDlg.isCancelled()) {
                return;
            }
        }
        this.leftSidePane.savePreferences();
        this.rightSidePane.savePreferences();
        int n = this.hSplitPane.getDividerLocation();
        FantasiaPrefs.preferences().setIntProperty("MainFrame.hSplitDividerLocation", n);
        FantasiaPrefs.preferences().setBoolProperty("MainFrame.windowMaximized", (this.getExtendedState() & 6) == 6);
        if (FantasiaPrefs.preferences().getBoolProperty("MainFrame.windowMaximized")) {
            super.onWindowClose();
            return;
        }
        StdUtils.saveWindowBounds("MainFrame", this.getBounds());
        String[] stringArray = this.recentScripts.toArray(new String[this.recentScripts.size()]);
        FantasiaPrefs.preferences().setStringListProperty("recentLscpScripts", stringArray);
        if (FantasiaPrefs.preferences().getBoolProperty("LSConsole.saveCommandHistory") && this.lsConsoleFrame != null) {
            this.getLSConsolePane().saveConsoleHistory();
        }
        if (this.getBackendLogFrame() != null) {
            this.getBackendLogFrame().stopTimer();
        }
        if (this.getLSConsolePane() != null) {
            this.getLSConsolePane().disconnect();
        }
        super.onWindowClose();
    }

    private void onChangeChannelLaneCount() {
        int n = FantasiaPrefs.preferences().getIntProperty("channelLanes.count");
        if (n < 1 || n > 8) {
            return;
        }
        if (n == this.getChannelsPaneCount()) {
            return;
        }
        int n2 = this.getChannelsPaneIndex(this.getSelectedChannelsPane());
        if (n > this.getChannelsPaneCount()) {
            int n3 = n - this.getChannelsPaneCount();
            for (int i = 0; i < n3; ++i) {
                JSChannelsPane jSChannelsPane = this.mainPane.addChannelsPane();
                this.addChannelsPane(jSChannelsPane);
                jSChannelsPane.addListSelectionListener(this.pianoKeyboardPane);
            }
        } else {
            int n4;
            int n5;
            int n6 = this.getChannelsPaneCount() - n;
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = this.getChannelsPaneCount() - 1 - n5;
                if (this.getChannelsPane(n4).getChannelCount() <= 0) continue;
                String string = FantasiaI18n.i18n.getError("MainFrame.notEmptyChannelLane!", n4 + 1);
                HF.showErrorMessage(string);
                return;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = this.getChannelsPaneCount() - 1;
                JSChannelsPane jSChannelsPane = this.getChannelsPane(n4);
                this.removeChannelsPane(jSChannelsPane);
                jSChannelsPane.removeListSelectionListener(this.pianoKeyboardPane);
                this.mainPane.removeChannelsPane(n4);
            }
        }
        if (n == 1) {
            this.mainPane.getButtonsPanel().setVisible(false);
        } else if (!this.mainPane.getButtonsPanel().isVisible()) {
            this.mainPane.getButtonsPanel().setVisible(true);
        }
        this.mainPane.getButtonsPanel().setButtonNumber(n);
        if (n2 < 0 || n2 >= this.getChannelsPaneCount()) {
            n2 = 0;
        }
        this.setSelectedChannelsPane(this.getChannelsPane(n2));
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        super.setVisible(bl);
        if (bl && FantasiaPrefs.preferences().getBoolProperty("MainFrame.windowMaximized")) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private void addMenu() {
        String[] stringArray;
        this.setJMenuBar(this.menuBar);
        FantasiaMenu fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("actions"));
        JMenuItem jMenuItem = new JMenuItem(A4n.a4n.refresh);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        fantasiaMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.samplerInfo);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.resetSampler);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        JMenu jMenu = new JMenu(FantasiaI18n.i18n.getMenuLabel("actions.export"));
        fantasiaMenu.add(jMenu);
        int n = CC.getViewConfig().getDefaultModKey();
        jMenuItem = new JMenuItem(A4n.a4n.exportSamplerConfig);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.exportMidiInstrumentMaps);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.loadScript);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        fantasiaMenu.add(jMenuItem);
        for (String string : stringArray = FantasiaPrefs.preferences().getStringListProperty("recentLscpScripts")) {
            this.recentScripts.add(string);
        }
        this.updateRecentScriptsMenu();
        fantasiaMenu.add(this.recentScriptsMenu);
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.changeBackend);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, n));
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("actions.exit"));
        fantasiaMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onWindowClose();
            }
        });
        this.menuBar.add(fantasiaMenu);
        fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("edit"));
        this.menuBar.add(fantasiaMenu);
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("edit.addChannel"));
        fantasiaMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getSamplerModel().addBackendChannel();
            }
        });
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.createMidiDevice);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.createAudioDevice);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.editPreferences);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, n | 1));
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("view"));
        this.menuBar.add(fantasiaMenu);
        fantasiaMenu.add(this.cbmiToolBarVisible);
        this.cbmiToolBarVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showToolBar(MainFrame.this.cbmiToolBarVisible.getState());
            }
        });
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("toolBar.visible");
        this.cbmiToolBarVisible.setSelected(bl);
        this.showToolBar(bl);
        this.cbmiLeftSidePaneVisible.setAccelerator(KeyStroke.getKeyStroke(76, n | 1));
        fantasiaMenu.add(this.cbmiLeftSidePaneVisible);
        this.cbmiLeftSidePaneVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showSidePane(MainFrame.this.cbmiLeftSidePaneVisible.getState());
            }
        });
        bl = FantasiaPrefs.preferences().getBoolProperty("leftSidePane.visible");
        this.cbmiLeftSidePaneVisible.setSelected(bl);
        this.showSidePane(bl);
        this.cbmiRightSidePaneVisible.setAccelerator(KeyStroke.getKeyStroke(82, n | 1));
        fantasiaMenu.add(this.cbmiRightSidePaneVisible);
        this.cbmiRightSidePaneVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showDevicesPane(MainFrame.this.cbmiRightSidePaneVisible.getState());
            }
        });
        bl = FantasiaPrefs.preferences().getBoolProperty("rightSidePane.visible");
        this.cbmiRightSidePaneVisible.setSelected(bl);
        this.showDevicesPane(bl);
        fantasiaMenu.addSeparator();
        fantasiaMenu.add(this.cbmiMidiKeyboardVisible);
        this.cbmiMidiKeyboardVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.setMidiKeyboardVisible(MainFrame.this.cbmiMidiKeyboardVisible.getState());
            }
        });
        bl = FantasiaPrefs.preferences().getBoolProperty("midiKeyboard.visible");
        this.cbmiMidiKeyboardVisible.setSelected(bl);
        this.setMidiKeyboardVisible(bl);
        fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("channels"));
        jMenuItem = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("channels.newChannel"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getSamplerModel().addBackendChannel();
            }
        });
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        MenuManager.ChannelViewGroup channelViewGroup = new MenuManager.ChannelViewGroup();
        MenuManager.getMenuManager().registerChannelViewGroup(channelViewGroup);
        for (JRadioButtonMenuItem jRadioButtonMenuItem : channelViewGroup.getMenuItems()) {
            fantasiaMenu.add(jRadioButtonMenuItem);
        }
        fantasiaMenu.addSeparator();
        fantasiaMenu.add(new JMenuItem(A4n.a4n.moveChannelsOnTop));
        fantasiaMenu.add(new JMenuItem(A4n.a4n.moveChannelsUp));
        fantasiaMenu.add(new JMenuItem(A4n.a4n.moveChannelsDown));
        fantasiaMenu.add(new JMenuItem(A4n.a4n.moveChannelsAtBottom));
        fantasiaMenu.add(new ToPanelMenu());
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.selectAllChannels);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        fantasiaMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.deselectChannels);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, n | 1));
        fantasiaMenu.add(jMenuItem);
        this.menuBar.add(fantasiaMenu);
        fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("window"));
        this.menuBar.add(fantasiaMenu);
        jMenuItem = new JMenuItem(A4n.a4n.windowLSConsole);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.windowInstrumentsDb);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        final JMenuItem jMenuItem2 = new JMenuItem(FantasiaI18n.i18n.getMenuLabel("window.backendLog"));
        fantasiaMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.getBackendLogFrame().isVisible()) {
                    MainFrame.this.getBackendLogFrame().setVisible(false);
                }
                MainFrame.this.getBackendLogFrame().setVisible(true);
            }
        });
        jMenuItem2.setEnabled(CC.getBackendProcess() != null);
        CC.addBackendProcessListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMenuItem2.setEnabled(CC.getBackendProcess() != null);
            }
        });
        fantasiaMenu = new FantasiaMenu(FantasiaI18n.i18n.getMenuLabel("help"));
        jMenuItem = new JMenuItem(A4n.a4n.browseOnlineTutorial);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        fantasiaMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.helpAbout);
        jMenuItem.setIcon(null);
        fantasiaMenu.add(jMenuItem);
        this.menuBar.add(fantasiaMenu);
    }

    public RightSidePane getRightSidePane() {
        return this.rightSidePane;
    }

    @Override
    public A4n getA4n() {
        return A4n.a4n;
    }

    @Override
    public void insertChannelsPane(JSChannelsPane jSChannelsPane, int n) {
    }

    @Override
    public JSChannelsPane getSelectedChannelsPane() {
        return this.mainPane.getSelectedChannelsPane();
    }

    @Override
    public void setSelectedChannelsPane(JSChannelsPane jSChannelsPane) {
        this.mainPane.setSelectedChannelsPane(jSChannelsPane);
        this.fireChannelsPaneSelectionChanged();
    }

    @Override
    public void installJSamplerHome() {
        JSamplerHomeChooser jSamplerHomeChooser = new JSamplerHomeChooser(this);
        jSamplerHomeChooser.setVisible(true);
        if (jSamplerHomeChooser.isCancelled()) {
            return;
        }
        JSUtils.changeJSamplerHome(jSamplerHomeChooser.getJSamplerHome());
    }

    @Override
    public void showDetailedErrorMessage(Frame frame, String string, String string2) {
        JSDetailedErrorDlg jSDetailedErrorDlg = new JSDetailedErrorDlg(frame, (Icon)Res.iconWarning32, FantasiaI18n.i18n.getError("error"), string, string2);
        jSDetailedErrorDlg.setVisible(true);
    }

    @Override
    public void showDetailedErrorMessage(Dialog dialog, String string, String string2) {
        JSDetailedErrorDlg jSDetailedErrorDlg = new JSDetailedErrorDlg(dialog, (Icon)Res.iconWarning32, FantasiaI18n.i18n.getError("error"), string, string2);
        jSDetailedErrorDlg.setVisible(true);
    }

    @Override
    public Server getServer() {
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("manualServerSelectOnStartup");
        return this.getServer(bl);
    }

    @Override
    public Server getServer(boolean bl) {
        if (bl) {
            JSConnectDlg jSConnectDlg = new JSConnectDlg();
            jSConnectDlg.setVisible(true);
            return jSConnectDlg.getSelectedServer();
        }
        int n = FantasiaPrefs.preferences().getIntProperty("serverIndex");
        int n2 = CC.getServerList().getServerCount();
        if (n2 == 0) {
            return null;
        }
        if (n >= n2) {
            return CC.getServerList().getServer(0);
        }
        return CC.getServerList().getServer(n);
    }

    public Timer getGuiTimer() {
        return this.guiTimer;
    }

    @Override
    public LSConsoleModel getLSConsoleModel() {
        return this.getLSConsolePane().getModel();
    }

    protected LSConsolePane getLSConsolePane() {
        return this.getLSConsoleFrame().getLSConsolePane();
    }

    protected LSConsoleFrame getLSConsoleFrame() {
        return this.lsConsoleFrame;
    }

    public JSBackendLogFrame getBackendLogFrame() {
        return this.backendLogFrame;
    }

    protected boolean runScript() {
        File file = StdUtils.showOpenLscpFileChooser();
        if (file == null) {
            return false;
        }
        this.runScript(file);
        return true;
    }

    @Override
    public void runScript(String string) {
        this.runScript(new File(string));
    }

    private void runScript(File file) {
        String string;
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            HF.showErrorMessage(FantasiaI18n.i18n.getError("fileNotFound!", file.getAbsolutePath()));
            return;
        }
        String string2 = "#jsampler.fantasia: ";
        Vector<String> vector = new Vector<String>();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                this.getLSConsoleModel().setCommandLineText(string);
                this.getLSConsoleModel().execCommand();
                if (string.startsWith(string2)) {
                    vector.add(string.substring(string2.length()));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception);
            return;
        }
        string = file.getAbsolutePath();
        this.recentScripts.remove(string);
        this.recentScripts.insertElementAt(string, 0);
        this.updateRecentScriptsMenu();
        CC.getViewConfig().setSessionViewConfig(new SessionViewConfig(vector.toArray(new String[vector.size()])));
    }

    protected void clearRecentScripts() {
        this.recentScripts.removeAllElements();
        this.updateRecentScriptsMenu();
    }

    protected void updateRecentScriptsMenu() {
        int n = FantasiaPrefs.preferences().getIntProperty("recentLscpScripts.maxNumber");
        while (this.recentScripts.size() > n) {
            this.recentScripts.removeElementAt(this.recentScripts.size() - 1);
        }
        this.recentScriptsMenu.removeAll();
        for (String string : this.recentScripts) {
            JMenuItem jMenuItem = new JMenuItem(string);
            this.recentScriptsMenu.add(jMenuItem);
            jMenuItem.addActionListener(new RecentScriptHandler(string));
        }
        this.recentScriptsMenu.setEnabled(this.recentScripts.size() != 0);
    }

    private void showToolBar(boolean bl) {
        FantasiaPrefs.preferences().setBoolProperty("toolBar.visible", bl);
        this.standardBar.setVisible(bl);
    }

    private void showSidePane(boolean bl) {
        int n;
        FantasiaPrefs.preferences().setBoolProperty("leftSidePane.visible", bl);
        this.rootPane.remove(this.rightPane);
        this.rootPane.remove(this.hSplitPane);
        if (bl) {
            this.hSplitPane.setRightComponent(this.rightPane);
            this.rootPane.add(this.hSplitPane);
            n = FantasiaPrefs.preferences().getIntProperty("MainFrame.hSplitDividerLocation", 220);
            this.hSplitPane.setDividerLocation(n);
            this.hSplitPane.validate();
        } else {
            this.rootPane.add(this.rightPane);
        }
        n = this.getPreferredSize().width;
        int n2 = this.getSize().height;
        this.setSize(new Dimension(n, n2));
        this.rootPane.revalidate();
        this.rootPane.validate();
        this.rootPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.sidePanesVisibilityChanged();
            }
        });
    }

    private void showDevicesPane(boolean bl) {
        int n;
        int n2;
        FantasiaPrefs.preferences().setBoolProperty("rightSidePane.visible", bl);
        int n3 = this.leftSidePane.getWidth();
        int n4 = this.leftSidePane.getPreferredSize().height;
        if (n3 != 0) {
            this.leftSidePane.setPreferredSize(new Dimension(n3, n4));
        }
        if (bl) {
            n2 = FantasiaPrefs.preferences().getIntProperty("devicesPane.width", 200);
            n = this.rightSidePane.getPreferredSize().height;
            this.rightSidePane.setPreferredSize(new Dimension(n2, n));
        } else {
            n2 = this.rightSidePane.getWidth();
            if (n2 > 0 && n2 < 200) {
                n2 = 200;
            }
            if (n2 != 0) {
                FantasiaPrefs.preferences().setIntProperty("devicesPane.width", n2);
            }
        }
        this.hSplitPane.setResizeWeight(0.0);
        this.rightSidePane.setVisible(bl);
        this.hSplitPane.resetToPreferredSizes();
        n2 = this.getPreferredSize().width;
        n = this.getSize().height;
        this.setSize(new Dimension(n2, n));
        this.rootPane.validate();
        this.rootPane.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.sidePanesVisibilityChanged();
            }
        });
    }

    public void setMidiKeyboardVisible(boolean bl) {
        FantasiaPrefs.preferences().setBoolProperty("midiKeyboard.visible", bl);
        this.pianoKeyboardPane.setVisible(bl);
        if (this.cbmiMidiKeyboardVisible.isSelected() != bl) {
            this.cbmiMidiKeyboardVisible.setSelected(bl);
        }
        if (this.standardBar.btnMidiKeyboard.isSelected() != bl) {
            this.standardBar.btnMidiKeyboard.setSelected(bl);
        }
        if (this.pianoKeyboardPane.btnPower.isSelected() != bl) {
            this.pianoKeyboardPane.btnPower.setSelected(bl);
        }
        this.rootPane.validate();
        this.rootPane.repaint();
    }

    public void setMidiKeyboardHeight(int n) {
        Dimension dimension = this.pianoKeyboardPane.getPreferredSize();
        dimension = new Dimension(dimension.width, n);
        this.pianoKeyboardPane.setPreferredSize(dimension);
        this.pianoKeyboardPane.setMinimumSize(dimension);
        this.pianoKeyboardPane.revalidate();
        this.pianoKeyboardPane.repaint();
    }

    private void sidePanesVisibilityChanged() {
        boolean bl = this.cbmiLeftSidePaneVisible.isSelected();
        boolean bl2 = this.cbmiRightSidePaneVisible.isSelected();
        if (bl && bl2) {
            this.hSplitPane.setResizeWeight(0.5);
        } else if (bl && !bl2) {
            this.hSplitPane.setResizeWeight(1.0);
        }
        if (!bl && !bl2) {
            this.standardBar.showFantasiaLogo(false);
            if (this.isResizable()) {
                this.setResizable(false);
            }
        } else {
            this.standardBar.showFantasiaLogo(true);
            if (!this.isResizable()) {
                this.setResizable(true);
            }
        }
    }

    class BottomPane
    extends FantasiaPanel {
        BottomPane() {
            this.setLayout(new BoxLayout(this, 1));
            this.setOpaque(false);
            this.add(MainFrame.this.pianoKeyboardPane);
        }
    }

    class RootPane
    extends FantasiaSubPanel {
        private final Color color1 = new Color(0x454545);
        private final Color color2 = new Color(0x2E2E2E);

        RootPane() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(9, 10, 6, 10));
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintBorder(graphics2D, 0.0, -3.0, d2 - 1.0, d - 1.0, 6.0, false);
            this.paintComponent(graphics2D, 5.0, 1.0, d2 - 10.0, d - 6.0, this.color1, this.color2);
            graphics2D.setPaint(paint);
            graphics2D.setComposite(composite);
        }
    }

    private class FantasiaMenuBar
    extends JMenuBar {
        FantasiaMenuBar() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 6, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Composite composite = graphics2D.getComposite();
            double d = this.getSize().getHeight();
            double d2 = this.getSize().getWidth();
            FantasiaPainter.paintGradient(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, FantasiaPainter.color6, FantasiaPainter.color5);
            if (MainFrame.this.standardBar.isVisible()) {
                FantasiaPainter.Border border = new FantasiaPainter.Border(true, true, false, true);
                FantasiaPainter.paintBoldOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d + 1.0, border);
            } else {
                FantasiaPainter.Border border = new FantasiaPainter.Border(true, true, true, true);
                FantasiaPainter.paintBoldOuterBorder(graphics2D, 0.0, 0.0, d2 - 1.0, d - 1.0, border);
            }
            graphics2D.setPaint(paint);
            graphics2D.setComposite(composite);
        }
    }

    private static class FantasiaMenu
    extends JMenu {
        FantasiaMenu(String string) {
            super(string);
            this.setFont(this.getFont().deriveFont(1));
            this.setOpaque(false);
            this.setContentAreaFilled(false);
        }
    }

    private class RecentScriptHandler
    implements ActionListener {
        private String script;

        RecentScriptHandler(String string) {
            this.script = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.runScript(this.script);
            if (FantasiaPrefs.preferences().getBoolProperty("showLSConsoleWhenRunScript")) {
                A4n.a4n.windowLSConsole.actionPerformed(null);
            }
        }
    }

    public static class ToPanelMenu
    extends FantasiaMenu
    implements ListSelectionListener {
        public ToPanelMenu() {
            super(FantasiaI18n.i18n.getMenuLabel("channels.toPanel"));
            this.setEnabled(CC.getMainFrame().getSelectedChannelsPane().hasSelectedChannel());
            CC.getMainFrame().addChannelsPaneSelectionListener(this);
            for (int i = 0; i < CC.getMainFrame().getChannelsPaneCount(); ++i) {
                JSChannelsPane jSChannelsPane = CC.getMainFrame().getChannelsPane(i);
                this.add(new JMenuItem(new StdA4n.MoveChannelsToPanel(jSChannelsPane)));
                jSChannelsPane.addListSelectionListener(this);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(CC.getMainFrame().getSelectedChannelsPane().hasSelectedChannel());
        }
    }
}

