/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LengthUnit {
    MILLIMETER{
        private Locale formatLocale;
        private String name;
        private DecimalFormat lengthFormatWithUnit;
        private DecimalFormat lengthFormat;
        private DecimalFormat areaFormatWithUnit;

        public Format getFormatWithUnit() {
            this.checkLocaleChange();
            return this.lengthFormatWithUnit;
        }

        public Format getAreaFormatWithUnit() {
            this.checkLocaleChange();
            return this.areaFormatWithUnit;
        }

        public Format getFormat() {
            this.checkLocaleChange();
            return this.lengthFormat;
        }

        public String getName() {
            this.checkLocaleChange();
            return this.name;
        }

        private void checkLocaleChange() {
            if (!Locale.getDefault().equals(this.formatLocale)) {
                this.formatLocale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LengthUnit.class.getName());
                this.name = resourceBundle.getString("millimeterUnit");
                this.lengthFormatWithUnit = new MeterFamilyFormat("#,##0 " + this.name, 10.0f);
                this.lengthFormat = new MeterFamilyFormat("#,##0", 10.0f);
                String string = resourceBundle.getString("squareMeterUnit");
                this.areaFormatWithUnit = new SquareMeterAreaFormatWithUnit(string);
            }
        }

        public float getMagnetizedLength(float f, float f2) {
            return LengthUnit.getMagnetizedMeterLength(f, f2);
        }

        public float getMinimumLength() {
            return 0.1f;
        }

        public float getMaximumLength() {
            return 100000.0f;
        }

        public float centimeterToUnit(float f) {
            return f * 10.0f;
        }

        public float unitToCentimeter(float f) {
            return f / 10.0f;
        }
    }
    ,
    CENTIMETER{
        private Locale formatLocale;
        private String name;
        private DecimalFormat lengthFormatWithUnit;
        private DecimalFormat lengthFormat;
        private DecimalFormat areaFormatWithUnit;

        public Format getFormatWithUnit() {
            this.checkLocaleChange();
            return this.lengthFormatWithUnit;
        }

        public Format getAreaFormatWithUnit() {
            this.checkLocaleChange();
            return this.areaFormatWithUnit;
        }

        public Format getFormat() {
            this.checkLocaleChange();
            return this.lengthFormat;
        }

        public String getName() {
            this.checkLocaleChange();
            return this.name;
        }

        private void checkLocaleChange() {
            if (!Locale.getDefault().equals(this.formatLocale)) {
                this.formatLocale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LengthUnit.class.getName());
                this.name = resourceBundle.getString("centimeterUnit");
                this.lengthFormatWithUnit = new MeterFamilyFormat("#,##0.# " + this.name, 1.0f);
                this.lengthFormat = new MeterFamilyFormat("#,##0.#", 1.0f);
                String string = resourceBundle.getString("squareMeterUnit");
                this.areaFormatWithUnit = new SquareMeterAreaFormatWithUnit(string);
            }
        }

        public float getMagnetizedLength(float f, float f2) {
            return LengthUnit.getMagnetizedMeterLength(f, f2);
        }

        public float getMinimumLength() {
            return 0.1f;
        }

        public float getMaximumLength() {
            return 100000.0f;
        }

        public float centimeterToUnit(float f) {
            return f;
        }

        public float unitToCentimeter(float f) {
            return f;
        }
    }
    ,
    METER{
        private Locale formatLocale;
        private String name;
        private DecimalFormat lengthFormatWithUnit;
        private DecimalFormat lengthFormat;
        private DecimalFormat areaFormatWithUnit;

        public Format getFormatWithUnit() {
            this.checkLocaleChange();
            return this.lengthFormatWithUnit;
        }

        public Format getAreaFormatWithUnit() {
            this.checkLocaleChange();
            return this.areaFormatWithUnit;
        }

        public Format getFormat() {
            this.checkLocaleChange();
            return this.lengthFormat;
        }

        public String getName() {
            this.checkLocaleChange();
            return this.name;
        }

        private void checkLocaleChange() {
            if (!Locale.getDefault().equals(this.formatLocale)) {
                this.formatLocale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LengthUnit.class.getName());
                this.name = resourceBundle.getString("meterUnit");
                this.lengthFormatWithUnit = new MeterFamilyFormat("#,##0.00# " + this.name, 0.01f);
                this.lengthFormat = new MeterFamilyFormat("#,##0.00#", 0.01f);
                String string = resourceBundle.getString("squareMeterUnit");
                this.areaFormatWithUnit = new SquareMeterAreaFormatWithUnit(string);
            }
        }

        public float getMagnetizedLength(float f, float f2) {
            return LengthUnit.getMagnetizedMeterLength(f, f2);
        }

        public float getMinimumLength() {
            return 0.1f;
        }

        public float getMaximumLength() {
            return 100000.0f;
        }

        public float centimeterToUnit(float f) {
            return f / 100.0f;
        }

        public float unitToCentimeter(float f) {
            return f * 100.0f;
        }
    }
    ,
    INCH{
        private Locale formatLocale;
        private String name;
        private DecimalFormat lengthFormat;
        private DecimalFormat areaFormatWithUnit;

        public Format getFormatWithUnit() {
            this.checkLocaleChange();
            return this.lengthFormat;
        }

        public Format getFormat() {
            return this.getFormatWithUnit();
        }

        public Format getAreaFormatWithUnit() {
            this.checkLocaleChange();
            return this.areaFormatWithUnit;
        }

        public String getName() {
            this.checkLocaleChange();
            return this.name;
        }

        private void checkLocaleChange() {
            if (!Locale.getDefault().equals(this.formatLocale)) {
                this.formatLocale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LengthUnit.class.getName());
                this.name = resourceBundle.getString("inchUnit");
                final MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("footFormat"));
                final MessageFormat messageFormat2 = new MessageFormat(resourceBundle.getString("footInchFormat"));
                final MessageFormat messageFormat3 = new MessageFormat(resourceBundle.getString("footInchEighthFormat"));
                final String string = resourceBundle.getString("footInchSeparator");
                final NumberFormat numberFormat = NumberFormat.getIntegerInstance();
                final NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
                final char[] cArray = new char[]{'\u215b', '\u00bc', '\u215c', '\u00bd', '\u215d', '\u00be', '\u215e'};
                this.lengthFormat = new DecimalFormat("0.000\""){

                    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                        double d2 = Math.floor(LengthUnit.centimeterToFoot((float)d));
                        float f = LengthUnit.centimeterToInch((float)d - LengthUnit.footToCentimeter((float)d2));
                        if (f >= 11.9375f) {
                            d2 += 1.0;
                            f -= 12.0f;
                        }
                        fieldPosition.setEndIndex(fieldPosition.getEndIndex() + 1);
                        if (f >= 5.0E-4f) {
                            int n = (int)Math.floor(f);
                            float f2 = f - (float)n;
                            int n2 = Math.round(f2 * 8.0f);
                            if (n2 == 0 || n2 == 8) {
                                messageFormat2.format(new Object[]{d2, Float.valueOf((float)Math.round(f * 8.0f) / 8.0f)}, stringBuffer, fieldPosition);
                            } else {
                                messageFormat3.format(new Object[]{d2, n, Character.valueOf(cArray[n2 - 1])}, stringBuffer, fieldPosition);
                            }
                        } else {
                            messageFormat.format(new Object[]{d2}, stringBuffer, fieldPosition);
                        }
                        return stringBuffer;
                    }

                    public Number parse(String string2, ParsePosition parsePosition) {
                        Number number;
                        double d = 0.0;
                        ParsePosition parsePosition2 = new ParsePosition(parsePosition.getIndex());
                        this.skipWhiteSpaces(string2, parsePosition2);
                        int n = string2.indexOf(39, parsePosition.getIndex());
                        if (n != -1) {
                            number = numberFormat.parse(string2, parsePosition2);
                            if (number == null) {
                                parsePosition.setErrorIndex(parsePosition2.getErrorIndex());
                                return null;
                            }
                            this.skipWhiteSpaces(string2, parsePosition2);
                            if (parsePosition2.getIndex() != n) {
                                parsePosition.setErrorIndex(parsePosition2.getIndex());
                                return null;
                            }
                            d = LengthUnit.footToCentimeter(number.intValue());
                            parsePosition2 = new ParsePosition(n + 1);
                            this.skipWhiteSpaces(string2, parsePosition2);
                            if (parsePosition2.getIndex() < string2.length() && string.indexOf(string2.charAt(parsePosition2.getIndex())) >= 0) {
                                parsePosition2.setIndex(parsePosition2.getIndex() + 1);
                                this.skipWhiteSpaces(string2, parsePosition2);
                            }
                            if (parsePosition2.getIndex() == string2.length()) {
                                parsePosition.setIndex(string2.length());
                                return d;
                            }
                        }
                        if ((number = numberFormat2.parse(string2, parsePosition2)) == null) {
                            parsePosition.setErrorIndex(parsePosition2.getErrorIndex());
                            return null;
                        }
                        d += (double)LengthUnit.inchToCentimeter(number.floatValue());
                        this.skipWhiteSpaces(string2, parsePosition2);
                        if (parsePosition2.getIndex() == string2.length()) {
                            parsePosition.setIndex(string2.length());
                            return d;
                        }
                        if (string2.charAt(parsePosition2.getIndex()) == '\"') {
                            parsePosition.setIndex(parsePosition2.getIndex() + 1);
                            return d;
                        }
                        char c = string2.charAt(parsePosition2.getIndex());
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] != c) continue;
                            int n2 = string2.lastIndexOf(this.getDecimalFormatSymbols().getDecimalSeparator(), parsePosition2.getIndex() - 1);
                            if (n2 > n) {
                                return null;
                            }
                            d += (double)LengthUnit.inchToCentimeter((float)(i + 1) / 8.0f);
                            parsePosition.setIndex(parsePosition2.getIndex() + 1);
                            this.skipWhiteSpaces(string2, parsePosition);
                            if (parsePosition.getIndex() < string2.length() && string2.charAt(parsePosition.getIndex()) == '\"') {
                                parsePosition.setIndex(parsePosition.getIndex() + 1);
                            }
                            return d;
                        }
                        parsePosition.setIndex(parsePosition2.getIndex());
                        return d;
                    }

                    private void skipWhiteSpaces(String string2, ParsePosition parsePosition) {
                        while (parsePosition.getIndex() < string2.length() && Character.isWhitespace(string2.charAt(parsePosition.getIndex()))) {
                            parsePosition.setIndex(parsePosition.getIndex() + 1);
                        }
                    }
                };
                String string2 = resourceBundle.getString("squareFootUnit");
                this.areaFormatWithUnit = new SquareFootAreaFormatWithUnit("#,##0 " + string2);
            }
        }

        public float getMagnetizedLength(float f, float f2) {
            return LengthUnit.getMagnetizedInchLength(f, f2);
        }

        public float getMinimumLength() {
            return LengthUnit.inchToCentimeter(0.125f);
        }

        public float getMaximumLength() {
            return LengthUnit.inchToCentimeter(99974.4f);
        }

        public float centimeterToUnit(float f) {
            return 4.centimeterToInch(f);
        }

        public float unitToCentimeter(float f) {
            return 4.inchToCentimeter(f);
        }
    }
    ,
    INCH_DECIMALS{
        private Locale formatLocale;
        private String name;
        private DecimalFormat lengthFormat;
        private DecimalFormat areaFormatWithUnit;

        public Format getFormatWithUnit() {
            this.checkLocaleChange();
            return this.lengthFormat;
        }

        public Format getFormat() {
            return this.getFormatWithUnit();
        }

        public Format getAreaFormatWithUnit() {
            this.checkLocaleChange();
            return this.areaFormatWithUnit;
        }

        public String getName() {
            this.checkLocaleChange();
            return this.name;
        }

        private void checkLocaleChange() {
            if (!Locale.getDefault().equals(this.formatLocale)) {
                this.formatLocale = Locale.getDefault();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(LengthUnit.class.getName());
                this.name = resourceBundle.getString("inchUnit");
                final MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("inchDecimalsFormat"));
                final NumberFormat numberFormat = NumberFormat.getNumberInstance();
                this.lengthFormat = new DecimalFormat("0.###"){

                    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                        float f = LengthUnit.centimeterToInch((float)d);
                        fieldPosition.setEndIndex(fieldPosition.getEndIndex() + 1);
                        messageFormat.format(new Object[]{Float.valueOf(f)}, stringBuffer, fieldPosition);
                        return stringBuffer;
                    }

                    public Number parse(String string, ParsePosition parsePosition) {
                        ParsePosition parsePosition2 = new ParsePosition(parsePosition.getIndex());
                        this.skipWhiteSpaces(string, parsePosition2);
                        Number number = numberFormat.parse(string, parsePosition2);
                        if (number == null) {
                            parsePosition.setErrorIndex(parsePosition2.getErrorIndex());
                            return null;
                        }
                        double d = LengthUnit.inchToCentimeter(number.floatValue());
                        this.skipWhiteSpaces(string, parsePosition2);
                        if (parsePosition2.getIndex() < string.length() && string.charAt(parsePosition2.getIndex()) == '\"') {
                            parsePosition.setIndex(parsePosition2.getIndex() + 1);
                        } else {
                            parsePosition.setIndex(parsePosition2.getIndex());
                        }
                        return d;
                    }

                    private void skipWhiteSpaces(String string, ParsePosition parsePosition) {
                        while (parsePosition.getIndex() < string.length() && Character.isWhitespace(string.charAt(parsePosition.getIndex()))) {
                            parsePosition.setIndex(parsePosition.getIndex() + 1);
                        }
                    }
                };
                String string = resourceBundle.getString("squareFootUnit");
                this.areaFormatWithUnit = new SquareFootAreaFormatWithUnit("#,##0.## " + string);
            }
        }

        public float getMagnetizedLength(float f, float f2) {
            return LengthUnit.getMagnetizedInchLength(f, f2);
        }

        public float getMinimumLength() {
            return LengthUnit.inchToCentimeter(0.125f);
        }

        public float getMaximumLength() {
            return LengthUnit.inchToCentimeter(99974.4f);
        }

        public float centimeterToUnit(float f) {
            return 5.centimeterToInch(f);
        }

        public float unitToCentimeter(float f) {
            return 5.inchToCentimeter(f);
        }
    };


    public static float centimeterToInch(float f) {
        return f / 2.54f;
    }

    public static float centimeterToFoot(float f) {
        return f / 2.54f / 12.0f;
    }

    public static float inchToCentimeter(float f) {
        return f * 2.54f;
    }

    public static float footToCentimeter(float f) {
        return f * 2.54f * 12.0f;
    }

    public abstract Format getFormatWithUnit();

    public abstract Format getFormat();

    public abstract Format getAreaFormatWithUnit();

    public abstract String getName();

    public abstract float getMagnetizedLength(float var1, float var2);

    private static float getMagnetizedMeterLength(float f, float f2) {
        f2 *= 2.0f;
        float f3 = 0.1f;
        if (f2 > 100.0f) {
            f3 = 100.0f;
        } else if (f2 > 10.0f) {
            f3 = 10.0f;
        } else if (f2 > 5.0f) {
            f3 = 5.0f;
        } else if (f2 > 1.0f) {
            f3 = 1.0f;
        } else if (f2 > 0.5f) {
            f3 = 0.5f;
        }
        float f4 = (float)Math.round(f / f3) * f3;
        if (f4 == 0.0f && f > 0.0f) {
            return f;
        }
        return f4;
    }

    private static float getMagnetizedInchLength(float f, float f2) {
        f2 = LengthUnit.centimeterToInch(f2) * 2.0f;
        float f3 = 0.125f;
        if (f2 > 6.0f) {
            f3 = 6.0f;
        } else if (f2 > 3.0f) {
            f3 = 3.0f;
        } else if (f2 > 1.0f) {
            f3 = 1.0f;
        } else if (f2 > 0.5f) {
            f3 = 0.5f;
        } else if (f2 > 0.25f) {
            f3 = 0.25f;
        }
        float f4 = LengthUnit.inchToCentimeter((float)Math.round(LengthUnit.centimeterToInch(f) / f3) * f3);
        if (f4 == 0.0f && f > 0.0f) {
            return f;
        }
        return f4;
    }

    public abstract float getMinimumLength();

    public abstract float getMaximumLength();

    public float getMaximumElevation() {
        return this.getMaximumLength() / 10.0f;
    }

    public abstract float centimeterToUnit(float var1);

    public abstract float unitToCentimeter(float var1);

    private static class SquareFootAreaFormatWithUnit
    extends DecimalFormat {
        public SquareFootAreaFormatWithUnit(String string) {
            super(string);
        }

        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return super.format(d / 929.0304, stringBuffer, fieldPosition);
        }
    }

    private static class SquareMeterAreaFormatWithUnit
    extends DecimalFormat {
        public SquareMeterAreaFormatWithUnit(String string) {
            super("#,##0.## " + string);
        }

        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return super.format(d / 10000.0, stringBuffer, fieldPosition);
        }
    }

    private static class MeterFamilyFormat
    extends DecimalFormat {
        private final float unitMultiplier;

        public MeterFamilyFormat(String string, float f) {
            super(string);
            this.unitMultiplier = f;
        }

        public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return super.format(d * (double)this.unitMultiplier, stringBuffer, fieldPosition);
        }

        public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.format((double)l, stringBuffer, fieldPosition);
        }

        public Number parse(String string, ParsePosition parsePosition) {
            Number number = super.parse(string, parsePosition);
            if (number == null) {
                return null;
            }
            return Float.valueOf(number.floatValue() / this.unitMultiplier);
        }
    }
}

