CREATE TABLE BUSINESS_ENTITY
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  AUTHORIZED_NAME VARCHAR(255) NOT NULL,
  PUBLISHER_ID VARCHAR(20) NULL,
  OPERATOR VARCHAR(255) NOT NULL,
  LAST_UPDATE TIMESTAMP NOT NULL,
  PRIMARY KEY (BUSINESS_KEY)
);

CREATE TABLE BUSINESS_DESCR
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  BUSINESS_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,BUSINESS_DESCR_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE BUSINESS_CATEGORY
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CATEGORY_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(41) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,CATEGORY_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE BUSINESS_IDENTIFIER
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  IDENTIFIER_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(41) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,IDENTIFIER_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE BUSINESS_NAME
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  BUSINESS_NAME_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,BUSINESS_NAME_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE CONTACT
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  USE_TYPE VARCHAR(255) NULL,
  PERSON_NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE CONTACT_DESCR
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  CONTACT_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID,CONTACT_DESCR_ID),
  FOREIGN KEY (BUSINESS_KEY,CONTACT_ID)
    REFERENCES CONTACT (BUSINESS_KEY,CONTACT_ID)
);

CREATE TABLE ADDRESS
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  ADDRESS_ID INT NOT NULL,
  USE_TYPE VARCHAR(255) NULL,
  SORT_CODE VARCHAR(10) NULL,
  TMODEL_KEY VARCHAR(41) NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID,ADDRESS_ID),
  FOREIGN KEY (BUSINESS_KEY,CONTACT_ID)
    REFERENCES CONTACT (BUSINESS_KEY,CONTACT_ID)
);

CREATE TABLE ADDRESS_LINE
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  ADDRESS_ID INT NOT NULL,
  ADDRESS_LINE_ID INT NOT NULL,
  LINE VARCHAR(80) NOT NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID,ADDRESS_ID,ADDRESS_LINE_ID),
  FOREIGN KEY (BUSINESS_KEY,CONTACT_ID,ADDRESS_ID)
    REFERENCES ADDRESS (BUSINESS_KEY,CONTACT_ID,ADDRESS_ID)
);

CREATE TABLE EMAIL
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  EMAIL_ID INT NOT NULL,
  USE_TYPE VARCHAR(255) NULL,
  EMAIL_ADDRESS VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID,EMAIL_ID),
  FOREIGN KEY (BUSINESS_KEY,CONTACT_ID)
    REFERENCES CONTACT (BUSINESS_KEY,CONTACT_ID)
);

CREATE TABLE PHONE
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  CONTACT_ID INT NOT NULL,
  PHONE_ID INT NOT NULL,
  USE_TYPE VARCHAR(255) NULL,
  PHONE_NUMBER VARCHAR(50) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,CONTACT_ID,PHONE_ID),
  FOREIGN KEY (BUSINESS_KEY,CONTACT_ID)
    REFERENCES CONTACT (BUSINESS_KEY,CONTACT_ID)
);

CREATE TABLE DISCOVERY_URL
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  DISCOVERY_URL_ID INT NOT NULL,
  USE_TYPE VARCHAR(255) NOT NULL,
  URL VARCHAR(255) NOT NULL,
  PRIMARY KEY (BUSINESS_KEY,DISCOVERY_URL_ID),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE BUSINESS_SERVICE
(
  BUSINESS_KEY VARCHAR(41) NOT NULL,
  SERVICE_KEY VARCHAR(41) NOT NULL,
  LAST_UPDATE TIMESTAMP NOT NULL,
  PRIMARY KEY (SERVICE_KEY),
  FOREIGN KEY (BUSINESS_KEY)
    REFERENCES BUSINESS_ENTITY (BUSINESS_KEY)
);

CREATE TABLE SERVICE_DESCR
(
  SERVICE_KEY VARCHAR(41) NOT NULL,
  SERVICE_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (SERVICE_KEY,SERVICE_DESCR_ID),
  FOREIGN KEY (SERVICE_KEY)
    REFERENCES BUSINESS_SERVICE (SERVICE_KEY)
);

CREATE TABLE SERVICE_CATEGORY
(
  SERVICE_KEY VARCHAR(41) NOT NULL,
  CATEGORY_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(41) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (SERVICE_KEY,CATEGORY_ID),
  FOREIGN KEY (SERVICE_KEY)
    REFERENCES BUSINESS_SERVICE (SERVICE_KEY)
);

CREATE TABLE SERVICE_NAME
(
  SERVICE_KEY VARCHAR(41) NOT NULL,
  SERVICE_NAME_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  NAME VARCHAR(255) NOT NULL,
  PRIMARY KEY (SERVICE_KEY,SERVICE_NAME_ID),
  FOREIGN KEY (SERVICE_KEY)
    REFERENCES BUSINESS_SERVICE (SERVICE_KEY)
);

CREATE TABLE BINDING_TEMPLATE
(
  SERVICE_KEY VARCHAR(41) NOT NULL,
  BINDING_KEY VARCHAR(41) NOT NULL,
  ACCESS_POINT_TYPE VARCHAR(20) NULL,
  ACCESS_POINT_URL VARCHAR(2000) NULL,
  HOSTING_REDIRECTOR VARCHAR(255) NULL,
  LAST_UPDATE TIMESTAMP NOT NULL,
  PRIMARY KEY (BINDING_KEY),
  FOREIGN KEY (SERVICE_KEY)
    REFERENCES BUSINESS_SERVICE (SERVICE_KEY)
);

CREATE TABLE BINDING_CATEGORY
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  CATEGORY_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(41) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (BINDING_KEY,CATEGORY_ID),
  FOREIGN KEY (BINDING_KEY)
    REFERENCES BINDING_TEMPLATE (BINDING_KEY)
);

CREATE TABLE BINDING_DESCR
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  BINDING_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BINDING_KEY,BINDING_DESCR_ID),
  FOREIGN KEY (BINDING_KEY)
    REFERENCES BINDING_TEMPLATE (BINDING_KEY)
);

CREATE TABLE TMODEL_INSTANCE_INFO
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  TMODEL_INSTANCE_INFO_ID INT NOT NULL,
  TMODEL_KEY VARCHAR(41) NOT NULL,
  OVERVIEW_URL VARCHAR(255) NULL,
  INSTANCE_PARMS VARCHAR(255) NULL,
  PRIMARY KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID),
  FOREIGN KEY (BINDING_KEY)
    REFERENCES BINDING_TEMPLATE (BINDING_KEY)
);

CREATE TABLE TMODEL_INSTANCE_INFO_DESCR
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  TMODEL_INSTANCE_INFO_ID INT NOT NULL,
  TMODEL_INSTANCE_INFO_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID,TMODEL_INSTANCE_INFO_DESCR_ID),
  FOREIGN KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
    REFERENCES TMODEL_INSTANCE_INFO (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
);

CREATE TABLE INSTANCE_DETAILS_DESCR
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  TMODEL_INSTANCE_INFO_ID INT NOT NULL,
  INSTANCE_DETAILS_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID,INSTANCE_DETAILS_DESCR_ID),
  FOREIGN KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
    REFERENCES TMODEL_INSTANCE_INFO (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
);

CREATE TABLE INSTANCE_DETAILS_DOC_DESCR
(
  BINDING_KEY VARCHAR(41) NOT NULL,
  TMODEL_INSTANCE_INFO_ID INT NOT NULL,
  INSTANCE_DETAILS_DOC_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID,INSTANCE_DETAILS_DOC_DESCR_ID),
  FOREIGN KEY (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
    REFERENCES TMODEL_INSTANCE_INFO (BINDING_KEY,TMODEL_INSTANCE_INFO_ID)
);

CREATE TABLE TMODEL
(
  TMODEL_KEY VARCHAR(41) NOT NULL,
  AUTHORIZED_NAME VARCHAR(255) NOT NULL,
  PUBLISHER_ID VARCHAR(20) NULL,
  OPERATOR VARCHAR(255) NOT NULL,
  NAME VARCHAR(255) NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  OVERVIEW_URL VARCHAR(255) NULL,
  DELETED VARCHAR(5) NULL,
  LAST_UPDATE TIMESTAMP NOT NULL,
  PRIMARY KEY (TMODEL_KEY)
);

CREATE TABLE TMODEL_DESCR
(
  TMODEL_KEY VARCHAR(41) NOT NULL,
  TMODEL_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (TMODEL_KEY,TMODEL_DESCR_ID),
  FOREIGN KEY (TMODEL_KEY)
    REFERENCES TMODEL (TMODEL_KEY)
);

CREATE TABLE TMODEL_CATEGORY
(
  TMODEL_KEY VARCHAR(41) NOT NULL,
  CATEGORY_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(255) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (TMODEL_KEY,CATEGORY_ID),
  FOREIGN KEY (TMODEL_KEY)
    REFERENCES TMODEL (TMODEL_KEY)
);

CREATE TABLE TMODEL_IDENTIFIER
(
  TMODEL_KEY VARCHAR(41) NOT NULL,
  IDENTIFIER_ID INT NOT NULL,
  TMODEL_KEY_REF VARCHAR(255) NULL,
  KEY_NAME VARCHAR(255) NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  PRIMARY KEY (TMODEL_KEY,IDENTIFIER_ID),
  FOREIGN KEY (TMODEL_KEY)
    REFERENCES TMODEL (TMODEL_KEY)
);

CREATE TABLE TMODEL_DOC_DESCR
(
  TMODEL_KEY VARCHAR(41) NOT NULL,
  TMODEL_DOC_DESCR_ID INT NOT NULL,
  LANG_CODE VARCHAR(5) NULL,
  DESCR VARCHAR(255) NOT NULL,
  PRIMARY KEY (TMODEL_KEY,TMODEL_DOC_DESCR_ID),
  FOREIGN KEY (TMODEL_KEY)
    REFERENCES TMODEL (TMODEL_KEY)
);

CREATE TABLE PUBLISHER_ASSERTION
(
  FROM_KEY VARCHAR(41) NOT NULL,
  TO_KEY VARCHAR(41) NOT NULL,
  TMODEL_KEY VARCHAR(41) NOT NULL,
  KEY_NAME VARCHAR(255) NOT NULL,
  KEY_VALUE VARCHAR(255) NOT NULL,
  FROM_CHECK VARCHAR(5) NOT NULL,
  TO_CHECK VARCHAR(5) NOT NULL
);

CREATE TABLE PUBLISHER
(
  PUBLISHER_ID VARCHAR(20) NOT NULL,
  PUBLISHER_NAME VARCHAR(255) NOT NULL,
  EMAIL_ADDRESS VARCHAR(255) NULL,
  IS_ADMIN VARCHAR(5) NULL,
  IS_ENABLED VARCHAR(5) NULL,
  MAX_BUSINESSES INT NULL,
  MAX_SERVICES_PER_BUSINESS INT NULL,
  MAX_BINDINGS_PER_SERVICE INT NULL,
  MAX_TMODELS INT NULL,
  PRIMARY KEY (PUBLISHER_ID)
);

CREATE TABLE AUTH_TOKEN
(
  AUTH_TOKEN VARCHAR(51) NOT NULL,
  PUBLISHER_ID VARCHAR(20) NOT NULL,
  PUBLISHER_NAME VARCHAR(255) NOT NULL,
  CREATED TIMESTAMP NOT NULL,
  LAST_USED TIMESTAMP NOT NULL,
  NUMBER_OF_USES INT NOT NULL,
  TOKEN_STATE INT NOT NULL,
  PRIMARY KEY (AUTH_TOKEN)
);
