/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.spi;

import java.io.Serializable;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.profileservice.spi.ProfileKeyMetaMapper;

@MetaMapping(value=ProfileKeyMetaMapper.class)
public class ProfileKey
implements Comparable<ProfileKey>,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT = "default";
    public static final ProfileKey DEFAULT_PROFILE_KEY = new ProfileKey("default", "default", "default");
    private final String domain;
    private final String server;
    private final String name;
    private final int hashCode;

    public ProfileKey(String name) {
        this(DEFAULT, DEFAULT, name);
    }

    public ProfileKey(String domain, String server, String name) {
        if (domain == null) {
            domain = DEFAULT;
        }
        this.domain = domain;
        if (server == null) {
            server = DEFAULT;
        }
        this.server = server;
        if (name == null) {
            name = DEFAULT;
        }
        this.name = name;
        this.hashCode = domain.hashCode() + server.hashCode() + name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isDefaultKey() {
        return DEFAULT.equalsIgnoreCase(this.getDomain()) && DEFAULT.equalsIgnoreCase(this.getServer()) && DEFAULT.equalsIgnoreCase(this.getName());
    }

    @Override
    public int compareTo(ProfileKey pk) {
        int compareTo = this.domain.compareTo(pk.domain);
        if (compareTo == 0 && (compareTo = this.server.compareTo(pk.server)) == 0) {
            compareTo = this.name.compareTo(pk.name);
        }
        return compareTo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProfileKey) {
            return this.compareTo((ProfileKey)ProfileKey.class.cast(o)) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.getClass().getSimpleName());
        tmp.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        tmp.append('[');
        tmp.append("domain=");
        tmp.append(this.getDomain());
        tmp.append(", server=");
        tmp.append(this.getServer());
        tmp.append(", name=");
        tmp.append(this.getName());
        tmp.append(']');
        return tmp.toString();
    }
}

