/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.MBeanInvoker;

public class DynamicInterceptor
extends AbstractInterceptor {
    public static final String ADD_INTERCEPTOR = "addOperationInterceptor";
    public static final String REMOVE_INTERCEPTOR = "removeOperationInterceptor";
    MBeanInvoker invoker;

    public DynamicInterceptor(MBeanInvoker invoker) {
        this.setName("DynamicInterceptor");
        this.invoker = invoker;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        AbstractInterceptor next;
        String type = invocation.getType();
        if (type.equals("invoke")) {
            String name = invocation.getName();
            if (name.equals(ADD_INTERCEPTOR)) {
                Object[] args = invocation.getArgs();
                Class<?> retn = invocation.getReturnTypeClass();
                if (args.length == 1 && args[0] instanceof Interceptor && retn == null) {
                    this.invoker.addOperationInterceptor((Interceptor)args[0]);
                    return null;
                }
            } else if (name.equals(REMOVE_INTERCEPTOR)) {
                Object[] args = invocation.getArgs();
                Class<?> retn = invocation.getReturnTypeClass();
                if (args.length == 1 && args[0] instanceof Interceptor && retn == null) {
                    this.invoker.removeOperationInterceptor((Interceptor)args[0]);
                    return null;
                }
            }
        }
        if ((next = invocation.nextInterceptor()) != null) {
            return next.invoke(invocation);
        }
        return invocation.dispatch();
    }
}

