/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry.basic;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.dependency.spi.dispatch.LifecycleDispatchContext;
import org.jboss.kernel.plugins.registry.basic.BasicKernelBus;

public class LifecycleAwareKernelBus
extends BasicKernelBus {
    public Object invoke(Object name, final String methodName, final Object[] parameters, final String[] signature) throws Throwable {
        LifecycleDispatchContext ldc;
        ControllerState state;
        ControllerContext context = this.controller.getContext(name, null);
        if (context == null) {
            throw new IllegalArgumentException("No such context: " + name);
        }
        if (context instanceof LifecycleDispatchContext && (state = (ldc = (LifecycleDispatchContext)context).lifecycleInvocation(methodName, parameters, signature)) != null) {
            if (!state.equals((Object)context.getState())) {
                this.controller.change(context, state);
            }
            return null;
        }
        if (ControllerState.INSTALLED.equals((Object)context.getState())) {
            return this.execute(context, InvokeDispatchContext.class, new BasicKernelBus.Dispatcher<InvokeDispatchContext>(){

                @Override
                public Object dispatch(InvokeDispatchContext dispatchContext) throws Throwable {
                    return dispatchContext.invoke(methodName, parameters, signature);
                }

                public String toString() {
                    return "invoke";
                }
            });
        }
        throw new IllegalArgumentException("The invocation is not a lifecycle invocation or context is not fully installed: " + context);
    }
}

