/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.generated;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.bytecode.DuplicateMemberException;
import org.jboss.reflect.plugins.bytecode.BytecodeConstructorInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeFieldInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeMethodInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.SignatureKey;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.generated.ClassFileWriterContext;
import org.jboss.reflect.plugins.bytecode.accessor.generated.ErrorCheckingMemberFactory;
import org.jboss.reflect.plugins.bytecode.accessor.generated.GeneratedConstructorAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.generated.GeneratedFieldAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.generated.GeneratedMethodAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.generated.SecurityActions;
import org.jboss.reflect.plugins.bytecode.bytes.BytecodePrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratedMemberAccessorFactory {
    protected static final String OBJECT_NAME = Object.class.getName();
    protected static final String[] THROWABLE_EXCEPTIONS = new String[]{"java/lang/Throwable"};
    protected static final AtomicInteger counter = new AtomicInteger(0);
    private final Class<?> superClass;
    private final boolean debug;
    private String accessedMember;
    private static final ParentLoaderHandler PARENT_LOADER_HANDLER = AccessController.doPrivileged(new PrivilegedAction<ParentLoaderHandler>(){

        @Override
        public ParentLoaderHandler run() {
            ClassLoader loader;
            HashSet<ClassLoader> parents;
            ClassLoader reflectLoader = MethodAccessor.class.getClassLoader();
            if (reflectLoader == null) {
                reflectLoader = ClassLoader.getSystemClassLoader();
            }
            HashSet<ClassLoader> hashSet = parents = (loader = reflectLoader.getParent()) == null ? null : new HashSet<ClassLoader>();
            while (loader != null) {
                parents.add(loader);
                loader = loader.getParent();
            }
            return new ParentLoaderHandler(reflectLoader, parents);
        }
    });

    GeneratedMemberAccessorFactory(Class<?> superClass, boolean debug) {
        this.superClass = superClass;
        this.debug = debug;
    }

    public static MethodAccessor generateMethodAccessor(Class<?> superClass, BytecodeMethodInfo method, boolean debug) {
        GeneratedMethodAccessorFactory factory = new GeneratedMethodAccessorFactory(superClass, method, debug);
        Class<MethodAccessor> member = factory.makeClass(MethodAccessor.class, (BytecodeTypeInfo)method.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), method);
    }

    public static ConstructorAccessor generateConstructorAccessor(Class<?> superClass, BytecodeConstructorInfo constructor, boolean debug) {
        GeneratedConstructorAccessorFactory factory = new GeneratedConstructorAccessorFactory(superClass, constructor, debug);
        Class<ConstructorAccessor> member = factory.makeClass(ConstructorAccessor.class, (BytecodeTypeInfo)constructor.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), constructor);
    }

    public static FieldAccessor generateFieldAccessor(Class<?> superClass, BytecodeFieldInfo field, boolean debug) {
        GeneratedFieldAccessorFactory factory = new GeneratedFieldAccessorFactory(superClass, field, debug);
        Class<FieldAccessor> member = factory.makeClass(FieldAccessor.class, field.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), field);
    }

    protected <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> Class<T> makeClass(Class<T> expected, BytecodeTypeInfo target) {
        String name = this.getGeneratedClassName();
        ClassFileWriterContext<T> cfwc = new ClassFileWriterContext<T>(name, this.superClass.getName(), expected, this.getInterfaceNames());
        try {
            this.implementMethods(cfwc);
            if (this.debug) {
                this.debugWriteFile(cfwc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating " + expected.getSimpleName() + " for " + target.getName(), e);
        }
        ClassLoader cl = target.getClassLoaderInternal();
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return this.toClass(cfwc, target, cl, null);
    }

    private <T> Class<T> toClass(ClassFileWriterContext<T> cfwc, BytecodeTypeInfo target, ClassLoader cl, ProtectionDomain domain) {
        ClassLoader actualLoader = GeneratedMemberAccessorFactory.PARENT_LOADER_HANDLER.getActualLoader(cl);
        ReflectiveOperationException t = null;
        try {
            return cfwc.toClass(actualLoader, domain);
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        throw new RuntimeException("Error creating " + cfwc.getSimpleType() + " for " + target.getName() + " with classloader " + actualLoader + "(" + cl + ")", t);
    }

    void implementMethods(ClassFileWriterContext<?> cfcw) throws DuplicateMemberException {
        int i = 0;
        while (this.implementMethod(i++, cfcw)) {
        }
    }

    String getAccessedMember() {
        if (this.accessedMember == null) {
            this.accessedMember = this.initAccessedMember();
        }
        return this.accessedMember;
    }

    abstract boolean implementMethod(int var1, ClassFileWriterContext<?> var2);

    abstract String[] getInterfaceNames();

    abstract String getGeneratedClassName();

    abstract String initAccessedMember();

    int countParameterStackSize(int offset, SignatureKey signatureKey) {
        int stacksize = offset;
        String[] params = signatureKey.getParams();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            ++stacksize;
            if (!signatureKey.isDouble(i) && !signatureKey.isLong(i)) continue;
            ++stacksize;
        }
        return stacksize;
    }

    void debugWriteFile(final ClassFileWriterContext<?> cfwc) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    FileOutputStream fout = new FileOutputStream(cfwc.getName() + ".class");
                    BufferedOutputStream out = new BufferedOutputStream(fout);
                    try {
                        out.write(cfwc.getBytes());
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    String getBoxedType(String type) {
        if (type.startsWith("[")) {
            return type.replace('.', '/');
        }
        Boxing boxing = Boxing.getUnboxer(type);
        if (boxing != null) {
            return boxing.getClassName();
        }
        return type;
    }

    void castAndUnbox(ClassFileWriterContext<?> cfwc, String type) {
        if (type.equals(OBJECT_NAME)) {
            return;
        }
        cfwc.addCheckcast(ClassFileWriterContext.jvmClassName(this.getBoxedType(type)));
        Boxing unboxer = Boxing.getUnboxer(type);
        if (unboxer != null) {
            cfwc.addInvokeVirtual(unboxer.getClassName(), unboxer.getUnboxMethodName(), unboxer.getUnboxMethodDescriptor());
        }
    }

    void boxReturnValue(ClassFileWriterContext<?> cfwc, String type) {
        Boxing boxing = Boxing.BOXERS.get(type);
        if (boxing != null) {
            cfwc.addInvokeStatic(boxing.getClassName(), boxing.getBoxMethodName(), boxing.getBoxMethodDescriptor());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Boxing {
        static final Map<String, Boxing> BOXERS;
        private String className;
        private String unboxMethodName;
        private String unboxMethodDescriptor;
        private String boxMethodDescriptor;

        static void addEntry(Map<String, Boxing> map, BytecodePrimitive primitive) {
            String jvmClassName = ClassFileWriterContext.jvmClassName(primitive.getWrapperClassName());
            Boxing boxing = new Boxing(jvmClassName, primitive.getValueMethodName(), "()" + primitive.getArrayComponentName(), "(" + primitive.getArrayComponentName() + ")L" + jvmClassName + ";");
            map.put(primitive.getName(), boxing);
            map.put(primitive.getArrayComponentName(), boxing);
        }

        static Boxing getUnboxer(String primitive) {
            return BOXERS.get(primitive);
        }

        public Boxing(String className, String methodName, String unboxMethodDescriptor, String boxMethodDescriptor) {
            this.className = className;
            this.unboxMethodName = methodName;
            this.unboxMethodDescriptor = unboxMethodDescriptor;
            this.boxMethodDescriptor = boxMethodDescriptor;
        }

        String getClassName() {
            return this.className;
        }

        String getUnboxMethodName() {
            return this.unboxMethodName;
        }

        String getUnboxMethodDescriptor() {
            return this.unboxMethodDescriptor;
        }

        String getBoxMethodName() {
            return "valueOf";
        }

        String getBoxMethodDescriptor() {
            return this.boxMethodDescriptor;
        }

        static {
            HashMap<String, Boxing> map = new HashMap<String, Boxing>();
            Boxing.addEntry(map, BytecodePrimitive.BOOLEAN);
            Boxing.addEntry(map, BytecodePrimitive.BYTE);
            Boxing.addEntry(map, BytecodePrimitive.CHAR);
            Boxing.addEntry(map, BytecodePrimitive.DOUBLE);
            Boxing.addEntry(map, BytecodePrimitive.FLOAT);
            Boxing.addEntry(map, BytecodePrimitive.INT);
            Boxing.addEntry(map, BytecodePrimitive.LONG);
            Boxing.addEntry(map, BytecodePrimitive.SHORT);
            BOXERS = Collections.unmodifiableMap(map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentLoaderHandler {
        final ClassLoader reflectLoader;
        final Set<ClassLoader> parentLoaders;

        public ParentLoaderHandler(ClassLoader reflectLoader, Set<ClassLoader> parentLoaders) {
            if (reflectLoader == null) {
                throw new IllegalArgumentException("Null reflect loader");
            }
            this.reflectLoader = reflectLoader;
            this.parentLoaders = parentLoaders;
        }

        private ClassLoader getActualLoader(ClassLoader loader) {
            if (this.parentLoaders != null && this.parentLoaders.contains(loader)) {
                return this.reflectLoader;
            }
            return loader;
        }
    }
}

