/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.marshalling.Pair;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.AttachmentsImpl;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.ClientContext;
import org.jboss.remoting3.ClientContextImpl;
import org.jboss.remoting3.ClientImpl;
import org.jboss.remoting3.ClientListener;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionImpl;
import org.jboss.remoting3.CopyOnWriteHashMap;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.LocalConnectionProvider;
import org.jboss.remoting3.LocalRemoteRequestHandler;
import org.jboss.remoting3.OrderedExecutor;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.RequestHandlerFactory;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.ServiceRegistrationInfo;
import org.jboss.remoting3.ServiceRegistrationListener;
import org.jboss.remoting3.ServiceURI;
import org.jboss.remoting3.TerminatingLocalRequestHandler;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.security.SimpleClientCallbackHandler;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.ProtocolServiceType;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;
import org.jboss.xnio.WeakCloseable;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EndpointImpl
extends AbstractHandleableCloseable<Endpoint>
implements Endpoint {
    private static final Logger log;
    private final Attachments attachments = new AttachmentsImpl();
    private final String name;
    private final OptionMap optionMap;
    private final Lock serviceWriteLock;
    private final Lock serviceReadLock;
    private final Map<Registration, ServiceRegistrationListener> serviceListenerRegistrations = EndpointImpl.hashMap();
    private final Map<String, Map<String, ServiceRegistrationInfo>> localServiceIndex = EndpointImpl.hashMap();
    private final ConcurrentMap<String, ConnectionProvider> connectionProviders = EndpointImpl.concurrentMap();
    private final ConcurrentMap[] providerMaps = new ConcurrentMap[ProtocolServiceType.getServiceTypes().length];
    private final ConnectionProviderContext connectionProviderContext;
    private static final RemotingPermission REGISTER_SERVICE_PERM;
    private static final RemotingPermission CREATE_CLIENT_PERM;
    private static final RemotingPermission ADD_SERVICE_LISTENER_PERM;
    private static final RemotingPermission CONNECT_PERM;
    private static final RemotingPermission ADD_CONNECTION_PROVIDER_PERM;
    private static final RemotingPermission ADD_PROTOCOL_SERVICE_PERM;
    private static final RemotingPermission GET_CONNECTION_PROVIDER_INTERFACE_PERM;
    private final Executor executor;
    private static final Charset UTF_8;
    private static final Pair<String, String> EMPTY;

    static <K, V> ConcurrentMap<K, V> concurrentMap() {
        return new CopyOnWriteHashMap();
    }

    static <K, V> ConcurrentMap<K, V> concurrentMap(Object lock) {
        return new CopyOnWriteHashMap(lock);
    }

    static <K, V> ConcurrentMap<K, V> concurrentIdentityMap(Object lock) {
        return new CopyOnWriteHashMap(true, lock);
    }

    static <T> Set<T> concurrentSet(Object lock) {
        return Collections.newSetFromMap(EndpointImpl.concurrentMap(lock));
    }

    static <K, V> Map<K, V> hashMap() {
        return new HashMap();
    }

    static <T> Set<T> hashSet() {
        return new HashSet();
    }

    static <T> Queue<T> concurrentLinkedQueue() {
        return new ConcurrentLinkedQueue();
    }

    static <T> List<T> arrayList() {
        return new ArrayList();
    }

    EndpointImpl(Executor executor, String name, OptionMap optionMap) throws IOException {
        super(executor);
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.serviceWriteLock = rwl.writeLock();
        this.serviceReadLock = rwl.readLock();
        for (int i = 0; i < this.providerMaps.length; ++i) {
            this.providerMaps[i] = EndpointImpl.concurrentMap();
        }
        this.executor = executor;
        this.name = name;
        this.connectionProviderContext = new ConnectionProviderContextImpl();
        this.connectionProviders.put("local", new LocalConnectionProvider(this.connectionProviderContext));
        this.optionMap = optionMap;
    }

    protected Executor getOrderedExecutor() {
        return new OrderedExecutor(this.executor);
    }

    @Override
    protected Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    private <T> ConcurrentMap<String, T> getMapFor(ProtocolServiceType<T> type) {
        return this.providerMaps[type.getIndex()];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
        if (!this.optionMap.contains(Remoting.UNCLOSEABLE)) {
            super.close();
        }
    }

    <I, O> LocalRequestHandler createLocalRequestHandler(RequestListener<? super I, ? extends O> requestListener, ClientContextImpl clientContext, Class<I> requestClass, Class<O> replyClass) throws IOException {
        if (requestListener == null) {
            throw new IllegalArgumentException("requestListener is null");
        }
        if (requestClass == null) {
            throw new IllegalArgumentException("requestClass is null");
        }
        if (replyClass == null) {
            throw new IllegalArgumentException("replyClass is null");
        }
        this.checkOpen();
        final TerminatingLocalRequestHandler<I, O> localRequestHandler = new TerminatingLocalRequestHandler<I, O>(this.executor, requestListener, clientContext, requestClass, replyClass, requestListener.getClass().getClassLoader());
        final WeakCloseable lrhCloseable = new WeakCloseable(localRequestHandler);
        clientContext.addCloseHandler(new CloseHandler<ClientContext>(){

            @Override
            public void handleClose(ClientContext closed) {
                IoUtils.safeClose((Closeable)localRequestHandler);
            }
        });
        final HandleableCloseable.Key key = this.addCloseHandler(new CloseHandler<Endpoint>(){

            @Override
            public void handleClose(Endpoint closed) {
                IoUtils.safeClose((Closeable)lrhCloseable);
            }
        });
        localRequestHandler.addCloseHandler(new CloseHandler<LocalRequestHandler>(){

            @Override
            public void handleClose(LocalRequestHandler closed) {
                key.remove();
            }
        });
        return localRequestHandler;
    }

    @Override
    public Endpoint.ServiceBuilder<?, ?> serviceBuilder() {
        return new ServiceBuilderImpl();
    }

    @Override
    public <I, O> Endpoint.ServiceBuilder<I, O> serviceBuilder(Class<I> requestClass, Class<O> replyClass) {
        return this.serviceBuilder().setRequestType(requestClass).setReplyType(replyClass);
    }

    private static void logListenerError(Throwable t) {
        log.error(t, "Service listener threw an exception", new Object[0]);
    }

    <I, O> Client<I, O> createClient(final RemoteRequestHandler requestHandler, Class<I> requestType, Class<O> replyType, ClassLoader clientClassLoader) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CLIENT_PERM);
        }
        if (requestHandler == null) {
            throw new IllegalArgumentException("requestHandler is null");
        }
        if (requestType == null) {
            throw new IllegalArgumentException("requestType is null");
        }
        if (replyType == null) {
            throw new IllegalArgumentException("replyType is null");
        }
        this.checkOpen();
        ClientImpl<I, O> client = ClientImpl.create(requestHandler, this.executor, requestType, replyType, clientClassLoader);
        WeakCloseable lrhCloseable = new WeakCloseable(client);
        final HandleableCloseable.Key key = this.addCloseHandler(SpiUtils.closingCloseHandler((Closeable)lrhCloseable));
        client.addCloseHandler(new CloseHandler<Client>(){

            @Override
            public void handleClose(Client closed) {
                IoUtils.safeClose((Closeable)requestHandler);
                key.remove();
            }
        });
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration addServiceRegistrationListener(final ServiceRegistrationListener listener, Set<Endpoint.ListenerFlag> flags) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ServiceListenerRegistration
        extends AbstractHandleableCloseable<Registration>
        implements Registration {
            ServiceListenerRegistration() {
                super(EndpointImpl.this.executor, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void closeAction() {
                Lock lock = EndpointImpl.this.serviceWriteLock;
                lock.lock();
                try {
                    EndpointImpl.this.serviceListenerRegistrations.remove(this);
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void close() {
                try {
                    super.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        ServiceListenerRegistration registration;
        block9: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ADD_SERVICE_LISTENER_PERM);
            }
            registration = new ServiceListenerRegistration();
            Lock lock = this.serviceWriteLock;
            lock.lock();
            try {
                this.serviceListenerRegistrations.put(registration, listener);
                if (flags != null && flags.contains((Object)Endpoint.ListenerFlag.INCLUDE_OLD)) break block9;
                Lock readLock = this.serviceReadLock;
                readLock.lock();
                try {
                    lock.unlock();
                }
                finally {
                    lock = readLock;
                }
                Executor executor = this.executor;
                for (Map.Entry<String, Map<String, ServiceRegistrationInfo>> entry : this.localServiceIndex.entrySet()) {
                    for (final ServiceRegistrationInfo service : entry.getValue().values()) {
                        executor.execute(new Runnable(){

                            public void run() {
                                ServiceRegistrationListener.ServiceInfo serviceInfo = new ServiceRegistrationListener.ServiceInfo();
                                RequestHandlerFactory<?, ?> handlerFactory = service.getRequestHandlerFactory();
                                serviceInfo.setRequestClass(handlerFactory.getRequestClass());
                                serviceInfo.setReplyClass(handlerFactory.getReplyClass());
                                serviceInfo.setServiceClassLoader(handlerFactory.getServiceClassLoader());
                                serviceInfo.setGroupName(service.getGroupName());
                                serviceInfo.setOptionMap(service.getOptionMap());
                                serviceInfo.setRegistrationHandle(service.getHandle());
                                serviceInfo.setServiceType(service.getServiceType());
                                try {
                                    listener.serviceRegistered(registration, serviceInfo);
                                }
                                catch (Throwable t) {
                                    EndpointImpl.logListenerError(t);
                                }
                            }
                        });
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return registration;
    }

    @Override
    public <I, O> Client<I, O> createLocalClient(ClientListener<I, O> clientListener, Class<I> requestClass, Class<O> replyClass, OptionMap optionMap) throws IOException {
        return this.createLocalClient(clientListener, requestClass, replyClass, Thread.currentThread().getContextClassLoader(), optionMap);
    }

    @Override
    public <I, O> Client<I, O> createLocalClient(ClientListener<I, O> clientListener, Class<I> requestClass, Class<O> replyClass, ClassLoader clientClassLoader, OptionMap optionMap) throws IOException {
        ClientContextImpl context = new ClientContextImpl(this.executor, null);
        RequestListener<I, O> requestListener = clientListener.handleClientOpen(context, optionMap);
        LocalRequestHandler localRequestHandler = this.createLocalRequestHandler(requestListener, context, requestClass, replyClass);
        LocalRemoteRequestHandler remoteRequestHandler = new LocalRemoteRequestHandler(localRequestHandler, clientClassLoader, optionMap, this.optionMap, this.executor);
        return ClientImpl.create(remoteRequestHandler, this.executor, requestClass, replyClass, clientClassLoader);
    }

    @Override
    public IoFuture<? extends Connection> connect(URI destination) throws IOException {
        Pair<String, String> userRealm = this.getUserAndRealm(destination);
        String uriUserName = (String)userRealm.getA();
        String uriUserRealm = (String)userRealm.getB();
        OptionMap.Builder builder = OptionMap.builder();
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTH_USER_NAME, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new SimpleClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTH_USER_NAME), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    @Override
    public IoFuture<? extends Connection> connect(URI destination, OptionMap connectOptions) throws IOException {
        Pair<String, String> userRealm = this.getUserAndRealm(destination);
        String uriUserName = (String)userRealm.getA();
        String uriUserRealm = (String)userRealm.getB();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTH_USER_NAME, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new SimpleClientCallbackHandler((String)finalMap.get(RemotingOptions.AUTH_USER_NAME), (String)finalMap.get(RemotingOptions.AUTH_REALM), null));
    }

    private IoFuture<? extends Connection> doConnect(final URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        String scheme;
        ConnectionProvider connectionProvider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONNECT_PERM);
        }
        if ((connectionProvider = (ConnectionProvider)this.connectionProviders.get(scheme = destination.getScheme())) == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + scheme + "\" is installed");
        }
        final FutureResult futureResult = new FutureResult(this.executor);
        final Throwable mark = new Throwable();
        futureResult.addCancelHandler(connectionProvider.connect(destination, connectOptions, new Result<ConnectionHandlerFactory>(){

            public boolean setResult(ConnectionHandlerFactory result) {
                return futureResult.setResult((Object)new ConnectionImpl(EndpointImpl.this, result, EndpointImpl.this.connectionProviderContext, destination.toString()));
            }

            public boolean setException(IOException exception) {
                EndpointImpl.glueStackTraces(exception, mark, 1, "asynchronous invocation");
                return futureResult.setException(exception);
            }

            public boolean setCancelled() {
                return futureResult.setCancelled();
            }
        }, callbackHandler));
        return futureResult.getIoFuture();
    }

    static void glueStackTraces(Throwable exception, Throwable markerThrowable, int trimCount, String msg) {
        StackTraceElement[] est = exception.getStackTrace();
        StackTraceElement[] ust = markerThrowable.getStackTrace();
        StackTraceElement[] fst = Arrays.copyOf(est, est.length + ust.length);
        fst[est.length] = new StackTraceElement("..." + msg + "..", "", null, -1);
        System.arraycopy(ust, trimCount, fst, est.length + 1, ust.length - trimCount);
        exception.setStackTrace(fst);
    }

    @Override
    public IoFuture<? extends Connection> connect(URI destination, OptionMap connectOptions, CallbackHandler callbackHandler) throws IOException {
        Pair<String, String> userRealm = this.getUserAndRealm(destination);
        String uriUserName = (String)userRealm.getA();
        String uriUserRealm = (String)userRealm.getB();
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (uriUserName != null) {
            builder.set(RemotingOptions.AUTH_USER_NAME, (Object)uriUserName);
        }
        if (uriUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)uriUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, callbackHandler);
    }

    @Override
    public IoFuture<? extends Connection> connect(URI destination, OptionMap connectOptions, String userName, String realmName, char[] password) throws IOException {
        String actualUserName;
        Pair<String, String> userRealm = this.getUserAndRealm(destination);
        String uriUserName = (String)userRealm.getA();
        String uriUserRealm = (String)userRealm.getB();
        String string = userName != null ? userName : (actualUserName = uriUserName != null ? uriUserName : (String)connectOptions.get(RemotingOptions.AUTH_USER_NAME));
        String actualUserRealm = realmName != null ? realmName : (uriUserRealm != null ? uriUserRealm : (String)connectOptions.get(RemotingOptions.AUTH_REALM));
        OptionMap.Builder builder = OptionMap.builder().addAll(connectOptions);
        if (actualUserName != null) {
            builder.set(RemotingOptions.AUTH_USER_NAME, (Object)actualUserName);
        }
        if (actualUserRealm != null) {
            builder.set(RemotingOptions.AUTH_REALM, (Object)actualUserRealm);
        }
        OptionMap finalMap = builder.getMap();
        return this.doConnect(destination, finalMap, new SimpleClientCallbackHandler(actualUserName, actualUserRealm, password));
    }

    @Override
    public Registration addConnectionProvider(String uriScheme, ConnectionProviderFactory providerFactory) {
        ConnectionProviderContextImpl context;
        ConnectionProvider provider;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_CONNECTION_PROVIDER_PERM);
        }
        if (this.connectionProviders.putIfAbsent(uriScheme, provider = providerFactory.createInstance(context = new ConnectionProviderContextImpl())) != null) {
            throw new DuplicateRegistrationException("URI scheme '" + uriScheme + "' is already registered to a provider");
        }
        log.trace("Adding connection provider registration named '%s': %s", (Object)uriScheme, (Object)provider);
        MapRegistration handle = new MapRegistration(this.connectionProviders, uriScheme, provider);
        return handle;
    }

    @Override
    public <T> T getConnectionProviderInterface(String uriScheme, Class<T> expectedType) throws UnknownURISchemeException, ClassCastException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONNECTION_PROVIDER_INTERFACE_PERM);
        }
        if (!expectedType.isInterface()) {
            throw new IllegalArgumentException("Interface expected");
        }
        ConnectionProvider provider = (ConnectionProvider)this.connectionProviders.get(uriScheme);
        if (provider == null) {
            throw new UnknownURISchemeException("No connection provider for URI scheme \"" + uriScheme + "\" is installed");
        }
        return expectedType.cast(provider.getProviderInterface());
    }

    @Override
    public <T> Registration addProtocolService(ProtocolServiceType<T> type, String name, T provider) throws DuplicateRegistrationException {
        ConcurrentMap<String, T> map = this.getMapFor(type);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_PROTOCOL_SERVICE_PERM);
        }
        if (map.putIfAbsent(name, provider) != null) {
            throw new DuplicateRegistrationException(type.getDescription() + " '" + name + "' is already registered");
        }
        log.trace("Adding '%s' registration named '%s': %s", type, (Object)name, provider);
        return new MapRegistration(map, name, provider);
    }

    public String toString() {
        return "endpoint \"" + this.name + "\" <" + Integer.toHexString(this.hashCode()) + ">";
    }

    private static String uriDecode(String encoded) {
        char[] chars = encoded.toCharArray();
        int olen = chars.length;
        byte[] buf = new byte[olen];
        int c = 0;
        for (int i = 0; i < olen; ++i) {
            char ch = chars[i];
            if (ch == '%') {
                buf[c++] = (byte)(Character.digit(chars[++i], 16) << 4 | Character.digit(chars[++i], 16));
                continue;
            }
            if (ch < ' ' || ch > '\u007f') continue;
            buf[c++] = (byte)ch;
        }
        return new String(buf, 0, c, UTF_8);
    }

    private Pair<String, String> getUserAndRealm(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo == null) {
            return EMPTY;
        }
        int i = userInfo.indexOf(59);
        if (i == -1) {
            return Pair.create((Object)uri.getUserInfo(), null);
        }
        return Pair.create((Object)EndpointImpl.uriDecode(userInfo.substring(0, i)), (Object)EndpointImpl.uriDecode(userInfo.substring(i + 1)));
    }

    static {
        Logger.getLogger((String)"org.jboss.remoting").info("JBoss Remoting version %s", (Object)Version.VERSION);
        log = Logger.getLogger((String)"org.jboss.remoting.endpoint");
        REGISTER_SERVICE_PERM = new RemotingPermission("registerService");
        CREATE_CLIENT_PERM = new RemotingPermission("createClient");
        ADD_SERVICE_LISTENER_PERM = new RemotingPermission("addServiceListener");
        CONNECT_PERM = new RemotingPermission("connect");
        ADD_CONNECTION_PROVIDER_PERM = new RemotingPermission("addConnectionProvider");
        ADD_PROTOCOL_SERVICE_PERM = new RemotingPermission("addProtocolService");
        GET_CONNECTION_PROVIDER_INTERFACE_PERM = new RemotingPermission("getConnectionProviderInterface");
        UTF_8 = Charset.forName("UTF-8");
        EMPTY = Pair.create(null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionProviderContextImpl
    implements ConnectionProviderContext {
        private ConnectionProviderContextImpl() {
        }

        @Override
        public Executor getExecutor() {
            return EndpointImpl.this.executor;
        }

        @Override
        public void accept(ConnectionHandlerFactory connectionHandlerFactory) {
            connectionHandlerFactory.createInstance(new LocalConnectionContext(EndpointImpl.this.connectionProviderContext, new ConnectionImpl(EndpointImpl.this, connectionHandlerFactory, this, "client")));
        }

        @Override
        public <T> Iterable<Map.Entry<String, T>> getProtocolServiceProviders(ProtocolServiceType<T> serviceType) {
            return EndpointImpl.this.getMapFor(serviceType).entrySet();
        }

        @Override
        public <T> T getProtocolServiceProvider(ProtocolServiceType<T> serviceType, String name) {
            return (T)EndpointImpl.this.getMapFor(serviceType).get(name);
        }

        @Override
        public Endpoint getEndpoint() {
            return EndpointImpl.this;
        }
    }

    final class LocalConnectionContext
    implements ConnectionHandlerContext {
        private final ConnectionProviderContext connectionProviderContext;
        private final Connection connection;

        LocalConnectionContext(ConnectionProviderContext connectionProviderContext, Connection connection) {
            this.connectionProviderContext = connectionProviderContext;
            this.connection = connection;
        }

        public ConnectionProviderContext getConnectionProviderContext() {
            return this.connectionProviderContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalRequestHandler openService(String serviceType, String groupName, OptionMap optionMap) {
            Lock lock = EndpointImpl.this.serviceReadLock;
            lock.lock();
            try {
                LocalRequestHandler localRequestHandler;
                ServiceRegistrationInfo info;
                Map subMap = (Map)EndpointImpl.this.localServiceIndex.get(serviceType);
                if (groupName == null || groupName.length() == 0 || "*".equals(groupName)) {
                    Iterator i = subMap.values().iterator();
                    info = i.hasNext() ? (ServiceRegistrationInfo)i.next() : null;
                } else {
                    ServiceRegistrationInfo serviceRegistrationInfo = info = subMap == null ? null : (ServiceRegistrationInfo)subMap.get(groupName);
                }
                if (info == null) {
                    localRequestHandler = null;
                    return localRequestHandler;
                }
                localRequestHandler = info.getRequestHandlerFactory().createRequestHandler(this.connection, optionMap);
                return localRequestHandler;
            }
            finally {
                lock.unlock();
            }
        }

        public void remoteClosed() {
            IoUtils.safeClose((Closeable)this.connection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRegistration<T>
    extends AbstractHandleableCloseable<Registration>
    implements Registration {
        private final ConcurrentMap<String, T> map;
        private final String key;
        private final T value;

        private MapRegistration(ConcurrentMap<String, T> map, String key, T value) {
            super(EndpointImpl.this.executor, false);
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        protected void closeAction() {
            this.map.remove(this.key, this.value);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return String.format("Registration of '%s': %s", this.key, this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceBuilderImpl<I, O>
    implements Endpoint.ServiceBuilder<I, O> {
        private String groupName = "default";
        private String serviceType;
        private Class<I> requestType;
        private Class<O> replyType;
        private ClientListener<? super I, ? extends O> clientListener;
        private ClassLoader classLoader;
        private OptionMap optionMap = OptionMap.EMPTY;

        private ServiceBuilderImpl() {
        }

        @Override
        public Endpoint.ServiceBuilder<I, O> setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Override
        public Endpoint.ServiceBuilder<I, O> setServiceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public <N> Endpoint.ServiceBuilder<N, O> setRequestType(Class<N> newRequestType) {
            if (newRequestType == null) {
                throw new IllegalArgumentException("newRequestType is null");
            }
            this.clientListener = null;
            ServiceBuilderImpl castBuilder = this;
            castBuilder.requestType = newRequestType;
            return castBuilder;
        }

        @Override
        public <N> Endpoint.ServiceBuilder<I, N> setReplyType(Class<N> newReplyType) {
            if (newReplyType == null) {
                throw new IllegalArgumentException("newReplyType is null");
            }
            this.clientListener = null;
            ServiceBuilderImpl castBuilder = this;
            castBuilder.replyType = newReplyType;
            return castBuilder;
        }

        @Override
        public Endpoint.ServiceBuilder<I, O> setClientListener(ClientListener<? super I, ? extends O> clientListener) {
            if (this.requestType == null || this.replyType == null) {
                throw new IllegalArgumentException("Must configure both request and reply type before setting the client listener");
            }
            this.clientListener = clientListener;
            return this;
        }

        @Override
        public Endpoint.ServiceBuilder<I, O> setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public Endpoint.ServiceBuilder<I, O> setOptionMap(OptionMap optionMap) {
            if (optionMap == null) {
                throw new IllegalArgumentException("optionMap is null");
            }
            this.optionMap = optionMap;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Registration register() throws IOException {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(REGISTER_SERVICE_PERM);
            }
            if (this.groupName == null) {
                throw new IllegalArgumentException("groupName is null");
            }
            if (this.serviceType == null) {
                throw new IllegalArgumentException("serviceType is null");
            }
            if (this.requestType == null) {
                throw new IllegalArgumentException("requestType is null");
            }
            if (this.replyType == null) {
                throw new IllegalArgumentException("replyType is null");
            }
            if (this.clientListener == null) {
                throw new IllegalArgumentException("clientListener is null");
            }
            Integer metric = (Integer)this.optionMap.get(RemotingOptions.METRIC);
            if (metric != null && metric < 0) {
                throw new IllegalArgumentException("metric must be greater than or equal to zero");
            }
            ServiceURI.validateServiceType(this.serviceType);
            ServiceURI.validateGroupName(this.groupName);
            EndpointImpl.this.checkOpen();
            Lock lock = EndpointImpl.this.serviceWriteLock;
            lock.lock();
            try {
                Map submap;
                log.trace("Registering a service type '%s' group name '%s'", (Object)this.serviceType, (Object)this.groupName);
                String canonServiceType = this.serviceType.toLowerCase();
                String canonGroupName = this.groupName.toLowerCase();
                final Executor executor = EndpointImpl.this.executor;
                ClassLoader classLoader = this.classLoader == null ? this.clientListener.getClass().getClassLoader() : this.classLoader;
                Map registeredLocalServices = EndpointImpl.this.localServiceIndex;
                RequestHandlerFactory<? super I, ? extends O> handlerFactory = RequestHandlerFactory.create(executor, this.clientListener, this.requestType, this.replyType, classLoader);
                final ServiceRegistrationInfo registration = new ServiceRegistrationInfo(this.serviceType, this.groupName, EndpointImpl.this.name, this.optionMap, handlerFactory);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ServiceRegistration
                extends AbstractHandleableCloseable<Registration>
                implements Registration {
                    ServiceRegistration() {
                        super(executor2, false);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void closeAction() {
                        Lock lock = EndpointImpl.this.serviceWriteLock;
                        lock.lock();
                        try {
                            ServiceRegistrationInfo oldReg;
                            Map submap = (Map)EndpointImpl.this.localServiceIndex.get(ServiceBuilderImpl.this.serviceType);
                            if (submap != null && (oldReg = (ServiceRegistrationInfo)submap.get(ServiceBuilderImpl.this.groupName)) == registration) {
                                submap.remove(ServiceBuilderImpl.this.groupName);
                            }
                            log.trace("Removed service type '%s' group name '%s'", (Object)ServiceBuilderImpl.this.serviceType, (Object)ServiceBuilderImpl.this.groupName);
                        }
                        finally {
                            lock.unlock();
                        }
                    }

                    @Override
                    public void close() {
                        try {
                            super.close();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
                ServiceRegistration handle = new ServiceRegistration();
                registration.setHandle(handle);
                if (registeredLocalServices.containsKey(canonServiceType)) {
                    submap = (Map)registeredLocalServices.get(canonServiceType);
                    if (submap.containsKey(canonGroupName)) {
                        throw new ServiceRegistrationException("ListenerRegistration of service of type \"" + this.serviceType + "\" in group \"" + this.groupName + "\" duplicates an already-registered service's specification");
                    }
                } else {
                    submap = EndpointImpl.hashMap();
                    registeredLocalServices.put(canonServiceType, submap);
                }
                submap.put(canonGroupName, registration);
                Lock readLock = EndpointImpl.this.serviceReadLock;
                readLock.lock();
                try {
                    lock.unlock();
                }
                finally {
                    lock = readLock;
                }
                final Iterator serviceListenerRegistrations = EndpointImpl.this.serviceListenerRegistrations.entrySet().iterator();
                final ServiceRegistrationListener.ServiceInfo serviceInfo = new ServiceRegistrationListener.ServiceInfo();
                serviceInfo.setGroupName(this.groupName);
                serviceInfo.setServiceType(this.serviceType);
                serviceInfo.setOptionMap(this.optionMap);
                serviceInfo.setRegistrationHandle(handle);
                serviceInfo.setRequestClass(this.requestType);
                serviceInfo.setReplyClass(this.replyType);
                serviceInfo.setServiceClassLoader(classLoader);
                executor.execute(new Runnable(){

                    public void run() {
                        Iterator iter = serviceListenerRegistrations;
                        while (iter.hasNext()) {
                            Map.Entry slr = (Map.Entry)iter.next();
                            try {
                                ((ServiceRegistrationListener)slr.getValue()).serviceRegistered((Registration)slr.getKey(), serviceInfo.clone());
                            }
                            catch (Throwable t) {
                                EndpointImpl.logListenerError(t);
                            }
                        }
                    }
                });
                ServiceRegistration serviceRegistration = handle;
                return serviceRegistration;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

