/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.DataInput;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _ClassByteCodeAnnotationFilter {
    private static final int CP_INFO_CLASS = 7;
    private static final int CP_INFO_FIELD_REF = 9;
    private static final int CP_INFO_METHOD_REF = 10;
    private static final int CP_INFO_INTERFACE_REF = 11;
    private static final int CP_INFO_STRING = 8;
    private static final int CP_INFO_INTEGER = 3;
    private static final int CP_INFO_FLOAT = 4;
    private static final int CP_INFO_LONG = 5;
    private static final int CP_INFO_DOUBLE = 6;
    private static final int CP_INFO_NAME_AND_TYPE = 12;
    private static final int CP_INFO_UTF8 = 1;

    _ClassByteCodeAnnotationFilter() {
    }

    public boolean couldContainAnnotationsOnClassDef(DataInput in, Set<String> byteCodeAnnotationsNames) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            return false;
        }
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        if (majorVersion < 49) {
            return false;
        }
        int constantsPoolCount = in.readUnsignedShort();
        block9: for (int i = 1; i < constantsPoolCount; ++i) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    String name = in.readUTF();
                    if (!byteCodeAnnotationsNames.contains(name)) continue block9;
                    return true;
                }
                case 7: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                case 8: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block9;
                }
                case 5: 
                case 6: {
                    in.readInt();
                    in.readInt();
                    continue block9;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                default: {
                    i = constantsPoolCount;
                }
            }
        }
        return false;
    }
}

