/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryRemoveAction
extends AbstractTwoPhaseModificationAction<DeploymentActionContext>
implements DeploymentAction<DeploymentActionContext> {
    private ProfileKey key;
    private DeploymentRepository deploymentRepository;
    private String deploymentName;

    public RepositoryRemoveAction(ProfileKey key, DeploymentRepository repository, String deploymentName, DeploymentActionContext modificationContext) {
        super((ProfileModificationContext)modificationContext);
        this.key = key;
        this.deploymentRepository = repository;
        this.deploymentName = deploymentName;
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            ProfileDeployment deployment = this.deploymentRepository.getDeployment(this.deploymentName);
            deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
            this.deploymentRepository.removeDeployment(this.deploymentName);
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.DELETE, (ProfileKey)this.key));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }
}

