/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.plugins.deploy.actions.AbstractDeploymentAddAction;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.system.server.profileservice.repository.LegacyProfileDeploymentFactory;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryDistributeAction
extends AbstractDeploymentAddAction
implements DeploymentAction<DeploymentActionContext> {
    private final DeploymentRepository deploymentRepository;
    private final InputStream contentIS;
    private static final LegacyProfileDeploymentFactory deploymentFactory = LegacyProfileDeploymentFactory.getInstance();

    public RepositoryDistributeAction(DeploymentID dtID, InputStream is, MutableProfile profile, DeploymentRepository repository, DeploymentActionContext modificationContext) {
        super(dtID, profile, modificationContext);
        this.deploymentRepository = repository;
        this.contentIS = is;
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            String deploymentName = this.getDeploymentName();
            if (this.getProfile().hasDeployment(deploymentName)) {
                ProfileDeployment deployment = this.getProfile().getDeployment(deploymentName);
                deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
            }
            String repositoryName = this.deploymentRepository.addDeploymentContent(deploymentName, this.contentIS, this.getDeploymentID().getDeploymentOptions());
            VirtualFile vf = this.deploymentRepository.getDeploymentContent(repositoryName);
            ProfileKey key = this.getProfile().getKey();
            String profileName = key.getName();
            String repoDeploymentName = this.createDeploymentName(vf);
            this.deploymentRepository.lockDeploymentContent(repoDeploymentName);
            if (!this.deploymentRepository.getDeploymentNames().contains(repoDeploymentName)) {
                ProfileDeployment deployment = this.createDeployment(profileName, repoDeploymentName, vf);
                deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
                this.deploymentRepository.addDeployment(deployment.getName(), deployment);
            }
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.ADD, (ProfileKey)this.getProfile().getKey()));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
    }

    protected void doRollbackFromRollbackOnly() {
    }

    protected ProfileDeployment createDeployment(String profileName, String deploymentName, VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        return deploymentFactory.createProfileDeployment(profileName, deploymentName, file);
    }

    protected String createDeploymentName(VirtualFile vf) throws URISyntaxException {
        return LegacyProfileDeploymentFactory.createDeploymentName((VirtualFile)vf);
    }
}

