/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha.rpc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.ha.rpc.RpcResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRpcResponse<T>
implements RpcResponse<T> {
    private static final long serialVersionUID = -6410563421870835482L;
    private ClusterNode sender;
    private Throwable exception;
    private T result;

    public DefaultRpcResponse(ClusterNode sender) {
        this.sender = sender;
    }

    @Override
    public ClusterNode getSender() {
        return this.sender;
    }

    @Override
    public T getResult() {
        if (this.exception != null) {
            throw Utils.convertToUnchecked(this.exception);
        }
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.sender);
        boolean exists = this.result != null;
        out.writeBoolean(exists);
        if (exists) {
            out.writeObject(this.result);
        }
        exists = this.exception != null;
        out.writeBoolean(exists);
        if (exists) {
            out.writeObject(this.exception);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.sender = (ClusterNode)in.readObject();
        this.result = in.readBoolean() ? in.readObject() : null;
        this.exception = in.readBoolean() ? (Throwable)in.readObject() : null;
    }
}

