/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.virtual.deployment;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileCapability;
import org.jboss.profileservice.profile.metadata.helpers.AbstractProfileRequirement;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.profileservice.version.Version;
import org.jboss.profileservice.virtual.deployment.AbstractVirtualDeploymentRequirement;
import org.jboss.profileservice.virtual.deployment.AbstractVirtualFileArtifact;
import org.jboss.profileservice.virtual.deployment.ClassPathLocationMetaData;
import org.jboss.profileservice.virtual.deployment.MetaDataLocationMetaData;
import org.jboss.profileservice.virtual.deployment.VirtualMavenArtifactMetaData;

@XmlType(propOrder={"name", "artifact", "artifacts", "requires", "children"})
public class AbstractVirtualDeployment
extends AbstractProfileCapability
implements VirtualDeploymentMetaData {
    private static final long serialVersionUID = -1017243455955127135L;
    private VirtualArtifactMetaData artifact;
    private List<VirtualArtifactMetaData> artifacts;
    private List<VirtualDeploymentMetaData> children;
    private List<AbstractProfileRequirement> requires;

    public AbstractVirtualDeployment() {
    }

    public AbstractVirtualDeployment(String name) {
        super(name);
    }

    public AbstractVirtualDeployment(String name, Version version) {
        super(name, version);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @XmlElements(value={@XmlElement(name="file", type=AbstractVirtualFileArtifact.class)})
    public VirtualArtifactMetaData getArtifact() {
        return this.artifact;
    }

    public void setArtifact(VirtualArtifactMetaData artifact) {
        this.artifact = artifact;
    }

    @XmlElements(value={@XmlElement(name="meta-inf", type=MetaDataLocationMetaData.class), @XmlElement(name="classpath", type=ClassPathLocationMetaData.class), @XmlElement(name="file", type=AbstractVirtualFileArtifact.class), @XmlElement(name="artifact", type=VirtualMavenArtifactMetaData.class)})
    public List<VirtualArtifactMetaData> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<VirtualArtifactMetaData> artifacts) {
        this.artifacts = artifacts;
    }

    @XmlElement(name="virtual-deployment", type=AbstractVirtualDeployment.class)
    public List<VirtualDeploymentMetaData> getChildren() {
        return this.children;
    }

    public void setChildren(List<VirtualDeploymentMetaData> children) {
        this.children = children;
    }

    @XmlElement(name="requires", type=AbstractVirtualDeploymentRequirement.class)
    public List<AbstractProfileRequirement> getRequires() {
        return this.requires;
    }

    public void setRequires(List<AbstractProfileRequirement> requires) {
        this.requires = requires;
    }

    public boolean isConsistent(ProfileCapability other) {
        return true;
    }

    public boolean resolves(ProfileRequirement requirement) {
        if (requirement instanceof AbstractVirtualDeploymentRequirement) {
            AbstractVirtualDeploymentRequirement deployment = (AbstractVirtualDeploymentRequirement)requirement;
            if (!this.getName().equals(deployment.getName())) {
                return false;
            }
            return deployment.getVersionRange().isInRange(this.getVersion());
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractVirtualDeployment)) {
            return false;
        }
        return super.equals(obj);
    }

    static boolean equals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        return one.equals(two);
    }
}

