/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.metadata;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.profileservice.profile.metadata.ProfilesMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class ProfilesMetaDataFactory {
    public static final String PROFILES_SUFFIX = "-profiles.xml";
    private static final VirtualFileFilter filter = new ProfilesFilter();
    private static final MutableSchemaResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    private final Map<String, ProfileMetaData> profiles = new HashMap<String, ProfileMetaData>();
    private final Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassBinding(String nsUri, Class<?> clazz) {
        if (nsUri == null) {
            throw new IllegalArgumentException("null nsUri");
        }
        MutableSchemaResolver mutableSchemaResolver = resolver;
        synchronized (mutableSchemaResolver) {
            if (clazz == null) {
                resolver.removeLocationToClassMapping(nsUri);
            } else {
                resolver.mapLocationToClass(nsUri, clazz);
            }
        }
    }

    public void parse(URL rootURL) throws JBossXBException, IOException, URISyntaxException {
        VirtualFile root = VFS.getChild((URL)rootURL);
        for (VirtualFile vf : root.getChildren(filter)) {
            this.parse(vf);
        }
    }

    public Map<String, ProfileMetaData> getProfiles() {
        return this.profiles;
    }

    protected void processProfilesMetaData(ProfilesMetaData metaData) {
        List<ProfileMetaData> profiles = metaData.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            for (ProfileMetaData profile : profiles) {
                this.addProfileMetaData(profile);
            }
        }
    }

    protected String addProfileMetaData(ProfileMetaData metaData) {
        String profileName = metaData.getName();
        if (profileName == null) {
            throw new IllegalStateException("null profile name");
        }
        if ((profileName = profileName.trim()).isEmpty()) {
            throw new IllegalStateException("empty profile name");
        }
        if (this.profiles.containsKey(profileName)) {
            throw new IllegalStateException("duplicate profile name " + profileName);
        }
        this.profiles.put(profileName, metaData);
        return profileName;
    }

    protected void parse(VirtualFile vf) throws JBossXBException, IOException {
        InputStream is = null;
        try {
            is = vf.openStream();
            this.processProfilesMetaData(this.unmarshal(is, ProfilesMetaData.class));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse : " + vf.getPathName(), e);
        }
        finally {
            VFSUtils.safeClose((Closeable)is);
        }
    }

    protected <T> T unmarshal(InputStream is, Class<T> clazz) throws JBossXBException {
        return clazz.cast(this.unmarshaller.unmarshal(is, (SchemaBindingResolver)resolver));
    }

    static {
        resolver.mapURIToClass("urn:jboss:profileservice:profiles:1.0", ProfilesMetaData.class);
    }

    static class ProfilesFilter
    implements VirtualFileFilter {
        ProfilesFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.getName().endsWith(ProfilesMetaDataFactory.PROFILES_SUFFIX);
        }
    }
}

