/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.AbstractEventBus;
import org.jboss.profileservice.management.ModificationSession;
import org.jboss.profileservice.management.actions.BasicProfileModificationRequest;
import org.jboss.profileservice.management.event.ProfileLifeCycleEvent;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.action.ModificationStatus;
import org.jboss.profileservice.spi.action.ProfileModificationAction;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationRequest;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileConfiguration;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class AbstractActionController
extends AbstractEventBus
implements ActionController {
    private List<ProfileKey> profiles = new CopyOnWriteArrayList<ProfileKey>();
    private Map<String, ProfileKey> profilesByName = new ConcurrentHashMap<String, ProfileKey>();
    private Map<ProfileKey, ProfileWrapper> profilesByKey = new ConcurrentHashMap<ProfileKey, ProfileWrapper>();

    public List<ProfileKey> getActiveProfiles() {
        return Collections.unmodifiableList(this.profiles);
    }

    public ManagedProfile getManagedProfile(ProfileKey key) {
        ProfileKey resolved = this.profilesByName.get(key.getName());
        return resolved != null ? this.profilesByKey.get(resolved) : null;
    }

    public void addProfile(ManagedProfile context) {
        ProfileKey key = context.getProfileKey();
        String profileName = key.getName();
        if (this.profilesByName.containsKey(profileName)) {
            throw new IllegalArgumentException("duplicate profile " + key);
        }
        this.profiles.add(key);
        this.profilesByName.put(profileName, key);
        this.profilesByKey.put(key, new ProfileWrapper(context));
        this.fireModificationEvent(new ProfileLifeCycleEvent(key, ProfileLifeCycleEvent.LifeCycleState.INSTALLED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProfile(ManagedProfile context) {
        ProfileKey key = context.getProfileKey();
        this.fireModificationEvent(new ProfileLifeCycleEvent(key, ProfileLifeCycleEvent.LifeCycleState.UNINSTALLED));
        this.profiles.remove(key);
        this.profilesByName.remove(key.getName());
        ProfileWrapper wrapper = this.profilesByKey.remove(key);
        if (wrapper != null) {
            wrapper.lockWrite();
            try {
                wrapper.deactivate();
            }
            finally {
                wrapper.unlockWrite();
            }
        }
    }

    public ModificationStatus perform(ProfileKey key, ProfileModificationType type, List<ProfileModificationAction<ProfileModificationContext>> actions) {
        BasicProfileModificationRequest modifications = new BasicProfileModificationRequest(type);
        for (ProfileModificationAction<ProfileModificationContext> action : actions) {
            modifications.addAction(key, action);
        }
        return this.perform(modifications);
    }

    public ModificationStatus perform(ProfileModificationRequest actions) {
        ProfileModificationType type = actions.getType();
        if (type == ProfileModificationType.GET) {
            return this.performRead(actions);
        }
        return this.performWrite(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModificationStatus performRead(ProfileModificationRequest actions) {
        ArrayList<ProfileWrapper> profiles = new ArrayList<ProfileWrapper>();
        try {
            for (ProfileKey key : actions.getProfilesKeys()) {
                ProfileWrapper wrapper = this.profilesByKey.get(key);
                if (wrapper == null) {
                    throw new IllegalStateException("profile not registered" + key);
                }
                if (profiles.contains(wrapper)) continue;
                wrapper.lockRead();
                profiles.add(wrapper);
            }
            ModificationStatus modificationStatus = this.internalPerfom(actions);
            return modificationStatus;
        }
        finally {
            for (ProfileWrapper wrapper : profiles) {
                wrapper.unlockRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModificationStatus performWrite(ProfileModificationRequest actions) {
        ArrayList<ProfileWrapper> profiles = new ArrayList<ProfileWrapper>();
        try {
            for (ProfileKey key : actions.getProfilesKeys()) {
                ProfileWrapper wrapper = this.profilesByKey.get(key);
                if (wrapper == null) {
                    throw new IllegalStateException("profile not registered" + key);
                }
                if (profiles.contains(wrapper)) continue;
                wrapper.lockWrite();
                profiles.add(wrapper);
            }
            ModificationStatus modificationStatus = this.internalPerfom(actions);
            return modificationStatus;
        }
        finally {
            for (ProfileWrapper wrapper : profiles) {
                wrapper.unlockWrite();
            }
        }
    }

    ModificationStatus internalPerfom(ProfileModificationRequest actions) {
        ModificationSession session = new ModificationSession(actions, this);
        if (session.prepare()) {
            session.commit();
        } else {
            session.rollback();
        }
        return session.getResponse();
    }

    private static class ProfileWrapper
    implements ManagedProfile {
        private final ManagedProfile managed;
        private final ReentrantReadWriteLock lock;
        private volatile boolean active = true;

        ProfileWrapper(ManagedProfile profile) {
            this.managed = profile;
            this.lock = new ReentrantReadWriteLock(true);
        }

        public ProfileKey getProfileKey() {
            return this.getManaged().getProfileKey();
        }

        public Profile getProfile() {
            return this.getManaged().getProfile();
        }

        public ProfileMetaData getProfileMetaData() {
            return this.getManaged().getProfileMetaData();
        }

        public ManagedProfileConfiguration getConfiguration() {
            return this.getManaged().getConfiguration();
        }

        public ManagedProfileDeployer getManagedDeployer() {
            return this.getManaged().getManagedDeployer();
        }

        public ManagedDeployment getManagedDeployment(ProfileDeployment deployment) throws Exception {
            return this.getManaged().getManagedDeployment(deployment);
        }

        private ManagedProfile getManaged() {
            if (this.active) {
                return this.managed;
            }
            throw new IllegalStateException("profile in inactive state " + this.managed.getProfileKey());
        }

        void deactivate() {
            this.active = false;
        }

        void lockRead() {
            this.lock.readLock().lock();
        }

        void unlockRead() {
            this.lock.readLock().unlock();
        }

        void lockWrite() {
            this.lock.writeLock().lock();
        }

        void unlockWrite() {
            this.lock.writeLock().unlock();
        }
    }
}

