/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.injection;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.webservices.integration.injection.EJBBeanReferenceResolver;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.wsf.common.injection.resolvers.ResourceReferenceResolver;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMetaDataDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ReferenceResolver RESOURCE_RESOLVER = new ResourceReferenceResolver();
    private EjbReferenceResolver ejbReferenceResolver;

    public void setEjbReferenceResolver(EjbReferenceResolver resolver) {
        this.ejbReferenceResolver = resolver;
    }

    public EjbReferenceResolver getEjbReferenceResolver() {
        if (this.ejbReferenceResolver == null) {
            throw new IllegalStateException("No EjbReferenceResolver set by MC");
        }
        return this.ejbReferenceResolver;
    }

    public void start(Deployment dep) {
        block3: {
            Map<Class<? extends Annotation>, ReferenceResolver> resolvers;
            DeploymentUnit unit;
            block2: {
                unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
                JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getRequiredAttachment((Deployment)dep, JBossWebMetaData.class);
                resolvers = this.getResolvers(unit);
                if (!WSHelper.isJaxwsJseDeployment((Deployment)dep)) break block2;
                this.log.debug((Object)("Building injection meta data for JAXWS JSE webservice deployment: " + dep.getSimpleName()));
                EnvironmentEntriesMetaData envEntriesMD = jbossWebMD.getEnvironmentEntries();
                for (Endpoint endpoint : dep.getService().getEndpoints()) {
                    InjectionsMetaData injectionsMD = this.buildInjectionsMetaData(envEntriesMD, resolvers);
                    endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
                }
                break block3;
            }
            if (!WSHelper.isJaxwsEjbDeployment((Deployment)dep)) break block3;
            this.log.debug((Object)("Building injection meta data for JAXWS EJB3 webservice deployment: " + dep.getSimpleName()));
            WebServiceDeployment webServiceDeployment = ASHelper.getRequiredAttachment(unit, WebServiceDeployment.class);
            Service service = dep.getService();
            for (WebServiceDeclaration container : webServiceDeployment.getServiceEndpoints()) {
                String ejbName = container.getComponentName();
                Endpoint endpoint = service.getEndpointByName(ejbName);
                if (endpoint == null || !ASHelper.isWebServiceBean(container)) continue;
                EnvironmentEntriesMetaData ejbEnvEntries = this.getEnvironmentEntries(ejbName, unit);
                InjectionsMetaData injectionsMD = this.buildInjectionsMetaData(ejbEnvEntries, resolvers);
                endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
            }
        }
    }

    private EnvironmentEntriesMetaData getEnvironmentEntries(String ejbName, DeploymentUnit unit) {
        JBossMetaData jbossMD = ASHelper.getRequiredAttachment(unit, JBossMetaData.class);
        JBossEnterpriseBeansMetaData enterpriseBeansMDs = jbossMD.getEnterpriseBeans();
        return ((JBossEnterpriseBeanMetaData)enterpriseBeansMDs.get(ejbName)).getEnvironmentEntries();
    }

    private Map<Class<? extends Annotation>, ReferenceResolver> getResolvers(DeploymentUnit unit) {
        HashMap<Class<? extends Annotation>, ReferenceResolver> resolvers = new HashMap<Class<? extends Annotation>, ReferenceResolver>();
        resolvers.put(Resource.class, RESOURCE_RESOLVER);
        resolvers.put((Class<? extends Annotation>)EJB.class, (ReferenceResolver)new EJBBeanReferenceResolver(unit, this.getEjbReferenceResolver()));
        return resolvers;
    }

    private InjectionsMetaData buildInjectionsMetaData(EnvironmentEntriesMetaData envEntriesMD, Map<Class<? extends Annotation>, ReferenceResolver> resolvers) {
        LinkedList<InjectionMetaData> injectionMD = new LinkedList<InjectionMetaData>();
        injectionMD.addAll(this.buildInjectionMetaData(envEntriesMD));
        return new InjectionsMetaData(injectionMD, resolvers);
    }

    private List<InjectionMetaData> buildInjectionMetaData(EnvironmentEntriesMetaData envEntriesMD) {
        if (envEntriesMD == null || envEntriesMD.size() == 0) {
            return Collections.emptyList();
        }
        LinkedList<InjectionMetaData> retVal = new LinkedList<InjectionMetaData>();
        for (EnvironmentEntryMetaData envEntryMD : envEntriesMD) {
            Set injectionTargets = envEntryMD.getInjectionTargets();
            boolean hasInjectionTargets = injectionTargets != null && injectionTargets.size() > 0;
            if (!hasInjectionTargets) continue;
            String envEntryName = envEntryMD.getEnvEntryName();
            String envEntryValue = envEntryMD.getValue();
            String envEntryValueClass = envEntryMD.getType();
            for (ResourceInjectionTargetMetaData resourceInjectionTargetMD : injectionTargets) {
                String targetClass = resourceInjectionTargetMD.getInjectionTargetClass();
                String targetName = resourceInjectionTargetMD.getInjectionTargetName();
                InjectionMetaData injectionMD = new InjectionMetaData(targetClass, targetName, envEntryValueClass, envEntryName, envEntryValue != null);
                this.log.debug((Object)injectionMD);
                retVal.add(injectionMD);
            }
        }
        return retVal;
    }
}

