/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.management.util.DefaultContextStateMapper;
import org.jboss.profileservice.plugins.management.util.ManagedObjectRuntimeProcessor;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;

public class ManagedDeploymentProcessor
extends ManagedObjectRuntimeProcessor {
    private static final Logger log = Logger.getLogger(ManagedDeploymentProcessor.class);
    private static final ContextStateMapper<DeploymentState> deploymentStateMapper;

    public ManagedDeploymentProcessor(AbstractManagementProxyFactory proxyFactory) {
        super(proxyFactory);
    }

    public void processRootManagedDeployment(ManagedDeployment md, ProfileViewProcessingContext context) throws Exception {
        DeploymentState state = this.getDeploymentState(md);
        this.processManagedDeployment(md, state, 0, context);
    }

    public void processRootManagedDeployment(ManagedDeployment md, DeploymentState state, ProfileViewProcessingContext context) throws Exception {
        this.processManagedDeployment(md, state, 0, context);
    }

    public void processManagedDeployment(ManagedDeployment md, DeploymentState state, int level, ProfileViewProcessingContext context) throws Exception {
        boolean trace = log.isTraceEnabled();
        String name = md.getName();
        if (trace) {
            log.trace((Object)(name + " ManagedDeployment_" + level + ": " + md));
        }
        if (state != null && md instanceof ManagedDeploymentImpl) {
            ((ManagedDeploymentImpl)ManagedDeploymentImpl.class.cast(md)).setDeploymentState(state);
        }
        if (md != null && md.getComponents() != null) {
            for (ManagedComponent comp : md.getComponents().values()) {
                context.addManagedComponent(comp);
            }
        }
        Map mos = md.getManagedObjects();
        for (ManagedObject mo : mos.values()) {
            this.processManagedObject(mo, md, context);
        }
        context.addManagedDeployment(md);
        List mdChildren = md.getChildren();
        if (mdChildren != null && !mdChildren.isEmpty()) {
            for (ManagedDeployment mdChild : mdChildren) {
                this.processManagedDeployment(mdChild, state, level + 1, context);
            }
        }
    }

    protected DeploymentState getDeploymentState(ManagedDeployment md) {
        String name;
        DeploymentState state = md.getDeploymentState();
        if (state == DeploymentState.UNKNOWN && (name = md.getName()) != null) {
            state = this.getMappedState(name, deploymentStateMapper);
        }
        return state;
    }

    static {
        HashMap<String, DeploymentState> deploymentMappings = new HashMap<String, DeploymentState>();
        deploymentMappings.put("**ERROR**", DeploymentState.FAILED);
        deploymentMappings.put("Not Installed", DeploymentState.STOPPED);
        deploymentMappings.put("Installed", DeploymentState.STARTED);
        deploymentStateMapper = new DefaultContextStateMapper<DeploymentState>(deploymentMappings, DeploymentState.STARTING, DeploymentState.STOPPING, DeploymentState.FAILED, DeploymentState.UNKNOWN);
    }
}

