/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.managed.ManagedProfile;

public abstract class AbstractDeploymentLifeCycleAction
extends AbstractTwoPhaseModificationAction<DeploymentActionContext>
implements DeploymentAction<DeploymentActionContext> {
    static final Logger log = Logger.getLogger((String)"org.jboss.profileservice.deployment.action");
    private final Collection<String> deploymentNames;
    private final ManagedProfile managed;
    private final List<DeploymentState> deployments = new ArrayList<DeploymentState>();

    public AbstractDeploymentLifeCycleAction(ManagedProfile managed, Collection<String> names, DeploymentActionContext modificationContext) {
        super((ProfileModificationContext)modificationContext);
        this.deploymentNames = names;
        this.managed = managed;
    }

    protected DeploymentState addDeployment(ProfileDeployment deployment) {
        DeploymentState state = new DeploymentState(deployment);
        this.deployments.add(state);
        return state;
    }

    public Collection<String> getDeploymentNames() {
        return this.deploymentNames;
    }

    protected List<DeploymentState> getDeployments() {
        return this.deployments;
    }

    protected ManagedProfile getManagedProfile() {
        return this.managed;
    }

    protected String[] resolvedNames() {
        HashSet<String> set = new HashSet<String>();
        for (DeploymentState state : this.deployments) {
            set.add(state.getName());
        }
        return set.toArray(new String[set.size()]);
    }

    static class DeploymentState {
        private final ProfileDeployment deployment;
        private final boolean deployed;

        public DeploymentState(ProfileDeployment deployment) {
            this.deployment = deployment;
            this.deployed = deployment.getDeploymentInfo().isDeployed();
        }

        public ProfileDeployment getDeployment() {
            return this.deployment;
        }

        public String getName() {
            return this.deployment.getName();
        }

        public boolean isDeployed() {
            return this.deployed;
        }
    }
}

