/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsf.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jsf.deployer.JSFImplMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.web.deployers.MergedJBossWebMetaDataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFSharedWebMetaDataDeployer
extends AbstractSimpleVFSRealDeployer<JSFImplMetaData> {
    public JSFSharedWebMetaDataDeployer() {
        super(JSFImplMetaData.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addRequiredInput(JBossWebMetaData.class);
        this.addInput(MergedJBossWebMetaDataDeployer.WEB_ORDER_ATTACHMENT_NAME);
        this.addInput(MergedJBossWebMetaDataDeployer.WEB_OVERLAYS_ATTACHMENT_NAME);
        this.addInput(MergedJBossWebMetaDataDeployer.WEB_SCIS_ATTACHMENT_NAME);
        this.setOutput(JBossWebMetaData.class);
    }

    public void deploy(VFSDeploymentUnit unit, JSFImplMetaData jsfImpl) throws DeploymentException {
        JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        this.mergeWebMetaData(webMetaData, jsfImpl.getSharedWebXml());
    }

    private void mergeWebMetaData(JBossWebMetaData webMetaData, Web30MetaData jsfImplWebMetaData) {
        if (jsfImplWebMetaData.getFilters() != null) {
            FiltersMetaData filters = webMetaData.getFilters();
            if (filters == null) {
                filters = new FiltersMetaData();
            }
            filters.addAll((Collection)jsfImplWebMetaData.getFilters());
            webMetaData.setFilters(filters);
        }
        if (jsfImplWebMetaData.getFilterMappings() != null) {
            ArrayList filterMappings = webMetaData.getFilterMappings();
            if (filterMappings == null) {
                filterMappings = new ArrayList();
            }
            filterMappings.addAll(jsfImplWebMetaData.getFilterMappings());
            webMetaData.setFilterMappings(filterMappings);
        }
        if (jsfImplWebMetaData.getServlets() != null) {
            JBossServletsMetaData servlets = webMetaData.getServlets();
            if (servlets == null) {
                servlets = new JBossServletsMetaData();
            }
            ServletsMetaData servletsMD = jsfImplWebMetaData.getServlets();
            servlets.addAll(this.makeJBossServletsMetaData(servletsMD));
            webMetaData.setServlets(servlets);
        }
        if (jsfImplWebMetaData.getServletMappings() != null) {
            ArrayList servletMappings = webMetaData.getServletMappings();
            if (servletMappings == null) {
                servletMappings = new ArrayList();
            }
            servletMappings.addAll(jsfImplWebMetaData.getServletMappings());
            webMetaData.setServletMappings(servletMappings);
        }
        if (jsfImplWebMetaData.getContextParams() != null) {
            ArrayList contextParams = webMetaData.getContextParams();
            if (contextParams == null) {
                contextParams = new ArrayList();
            }
            contextParams.addAll(jsfImplWebMetaData.getContextParams());
            webMetaData.setContextParams(contextParams);
        }
        if (jsfImplWebMetaData.getListeners() != null) {
            ArrayList listeners = webMetaData.getListeners();
            if (listeners == null) {
                listeners = new ArrayList();
            }
            listeners.addAll(jsfImplWebMetaData.getListeners());
            webMetaData.setListeners(listeners);
        }
    }

    private Collection<JBossServletMetaData> makeJBossServletsMetaData(ServletsMetaData servletsMD) {
        HashSet<JBossServletMetaData> servletSet = new HashSet<JBossServletMetaData>();
        for (ServletMetaData servletMD : servletsMD) {
            JBossServletMetaData jbossMD = new JBossServletMetaData();
            servletSet.add(jbossMD.merge(servletMD));
        }
        return servletSet;
    }
}

