/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.jboss.remoting3.stream.StreamContext;
import org.jboss.remoting3.stream.StreamHandler;
import org.jboss.remoting3.stream.StreamHandlerFactory;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputStreamHandlerFactory
implements StreamHandlerFactory<InputStream, StreamChannel> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.stream.inputstream");

    @Override
    public StreamHandler<InputStream, StreamChannel> createStreamHandler(InputStream localInstance, StreamContext streamContext) throws IOException {
        return new Handler(localInstance, streamContext);
    }

    private static class LocalRunnable
    implements Runnable {
        private static final int MIN_BUFFER_SIZE = 512;
        private static final int MAX_BUFFER_SIZE = 1024;
        private final StreamChannel channel;
        private final InputStream localInstance;

        public LocalRunnable(StreamChannel channel, InputStream instance) {
            this.channel = channel;
            this.localInstance = instance;
        }

        public void run() {
            try {
                byte[] bytes = new byte[1024];
                ByteBuffer buf = ByteBuffer.wrap(bytes);
                while (true) {
                    int pos;
                    int cnt = 0;
                    while ((pos = buf.position()) < 512 && (cnt = this.localInstance.read(bytes, pos, buf.remaining())) != -1) {
                    }
                    buf.flip();
                    do {
                        int wcnt;
                        if ((wcnt = this.channel.write(buf)) != 0) continue;
                        this.channel.awaitWritable();
                    } while (buf.hasRemaining());
                    if (cnt == -1) {
                        this.channel.close();
                    }
                    buf.clear();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e, "Failed to read input stream data", new Object[0]);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyInputStream
    extends InputStream {
        private final IoFuture<? extends StreamChannel> futureChannel;

        public ProxyInputStream(IoFuture<? extends StreamChannel> futureChannel) {
            this.futureChannel = futureChannel;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res;
            StreamChannel channel = (StreamChannel)this.futureChannel.get();
            do {
                if ((res = channel.read(ByteBuffer.wrap(b, off, len))) != 0) continue;
                channel.awaitReadable();
            } while (res == 0);
            return res;
        }

        @Override
        public void close() throws IOException {
            ((StreamChannel)this.futureChannel.get()).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    implements StreamHandler<InputStream, StreamChannel> {
        private static final long serialVersionUID = 731898100063706343L;
        private final StreamContext streamContext;
        private final transient InputStream localInstance;

        private Handler(InputStream instance, StreamContext context) {
            this.localInstance = instance;
            this.streamContext = context;
        }

        @Override
        public ChannelListener<StreamChannel> getLocalHandler() {
            return new ChannelListener<StreamChannel>(){

                public void handleEvent(StreamChannel channel) {
                    channel.getCloseSetter().set((ChannelListener)new ChannelListener<StreamChannel>(){

                        public void handleEvent(StreamChannel channel) {
                            IoUtils.safeClose((Closeable)Handler.this.localInstance);
                        }
                    });
                    Handler.this.streamContext.execute(new LocalRunnable(channel, Handler.this.localInstance));
                }
            };
        }

        @Override
        public ChannelListener<Channel> getRemoteHandler() {
            return IoUtils.nullChannelListener();
        }

        @Override
        public InputStream getRemoteProxy(IoFuture<? extends StreamChannel> futureChannel) {
            return new ProxyInputStream(futureChannel);
        }
    }
}

