/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.marshalling.ProviderDescriptor;
import org.jboss.remoting3.remote.ClientOpenListener;
import org.jboss.remoting3.remote.ServerOpenListener;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.jboss.remoting3.spi.ProtocolServiceType;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.Connector;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;
import org.jboss.xnio.channels.ConnectedStreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteConnectionProvider
implements ConnectionProvider {
    private final ConnectionProviderContext connectionProviderContext;
    private final Connector<InetSocketAddress, ? extends ConnectedStreamChannel<InetSocketAddress>> connector;
    private final ProviderInterface providerInterface = new ProviderInterface();
    private final ProviderDescriptor providerDescriptor;

    RemoteConnectionProvider(ConnectionProviderContext connectionProviderContext, Connector<InetSocketAddress, ? extends ConnectedStreamChannel<InetSocketAddress>> connector) {
        this.connectionProviderContext = connectionProviderContext;
        this.connector = connector;
        ProviderDescriptor providerDescriptor = connectionProviderContext.getProtocolServiceProvider(ProtocolServiceType.MARSHALLER_PROVIDER_DESCRIPTOR, "river");
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("River marshalling protocol is not installed");
        }
        this.providerDescriptor = providerDescriptor;
    }

    @Override
    public Cancellable connect(URI uri, OptionMap connectOptions, Result<ConnectionHandlerFactory> result, CallbackHandler callbackHandler) throws IllegalArgumentException {
        IoFuture futureChannel;
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException("No host name specified");
        }
        int port = uri.getPort();
        if (port < 1) {
            throw new IllegalArgumentException("Port number must be specified");
        }
        AccessControlContext acc = AccessController.getContext();
        try {
            futureChannel = this.connector.connectTo((Object)new InetSocketAddress(InetAddress.getByName(host), port), (ChannelListener)new ClientOpenListener(connectOptions, this.connectionProviderContext, result, callbackHandler, this.providerDescriptor, acc), null);
        }
        catch (UnknownHostException e) {
            result.setException((IOException)e);
            return IoUtils.nullCancellable();
        }
        return futureChannel;
    }

    @Override
    public NetworkServerProvider getProviderInterface() {
        return this.providerInterface;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProviderInterface
    implements NetworkServerProvider {
        private ProviderInterface() {
        }

        @Override
        public ChannelListener<ConnectedStreamChannel<InetSocketAddress>> getServerListener(OptionMap optionMap, ServerAuthenticationProvider authenticationProvider) {
            return new ServerOpenListener(optionMap, RemoteConnectionProvider.this.connectionProviderContext, RemoteConnectionProvider.this.providerDescriptor, authenticationProvider);
        }
    }
}

