/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.xnio.Pool;
import org.jboss.xnio.log.Logger;

final class OutboundReplyBufferWriter
implements NioByteOutput.BufferWriter {
    private final AtomicBoolean first = new AtomicBoolean(true);
    private final int id;
    private final boolean exception;
    private final InboundRequest inboundRequest;
    private static final Logger log = Loggers.main;

    OutboundReplyBufferWriter(InboundRequest inboundRequest, int id, boolean exception) {
        this.inboundRequest = inboundRequest;
        this.id = id;
        this.exception = exception;
    }

    public ByteBuffer getBuffer() {
        RemoteConnectionHandler connectionHandler = this.inboundRequest.getRemoteConnectionHandler();
        Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
        ByteBuffer buffer = (ByteBuffer)bufferPool.allocate();
        log.trace("Allocated buffer %s for %s", (Object)buffer, (Object)this);
        buffer.putInt(0);
        buffer.put(this.exception ? (byte)52 : 51);
        buffer.putInt(this.id);
        boolean isFirst = this.first.getAndSet(false);
        if (isFirst) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
        log.trace("Prepopulated buffer %s for %s", (Object)buffer, (Object)this);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ByteBuffer buffer, boolean eof) throws IOException {
        RemoteConnectionHandler connectionHandler = this.inboundRequest.getRemoteConnectionHandler();
        try {
            this.inboundRequest.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        try {
            if (eof) {
                buffer.put(7, (byte)(buffer.get(3) | 2));
            }
            log.trace("Sending buffer %s for %s", (Object)buffer, (Object)this);
            connectionHandler.getRemoteConnection().sendBlocking(buffer, eof);
        }
        finally {
            connectionHandler.getBufferPool().free((Object)buffer);
        }
    }

    public void flush() throws IOException {
        this.inboundRequest.getRemoteConnectionHandler().getRemoteConnection().flushBlocking();
    }

    public String toString() {
        return "Outbound reply buffer writer for " + this.inboundRequest;
    }
}

