/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.TypedProxyPushSupplierImplMBean;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventTypeHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedEventComm.TypedPushConsumer;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierPOATie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements TypedProxyPushSupplierOperations,
ITypedProxy,
TypedProxyPushSupplierImplMBean {
    private TypedPushConsumer pushConsumer_;
    private Object typedConsumer_;
    private static final TypeCode TYPE_CODE_VOID = ORB.init().get_primitive_tc(TCKind.tk_void);
    private final String supportedInterface_;
    private long timeSpent_ = 0L;

    public TypedProxyPushSupplierImpl(ITypedAdmin iTypedAdmin, ConsumerAdmin consumerAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) throws ConfigurationException {
        super(iTypedAdmin, oRB, pOA, configuration, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
        this.supportedInterface_ = iTypedAdmin.getSupportedInterface();
    }

    public void disconnect_push_supplier() {
        this.destroy();
    }

    public void connect_typed_push_consumer(TypedPushConsumer typedPushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_push_supplier");
        this.checkIsNotConnected();
        this.connectClient(typedPushConsumer);
        this.pushConsumer_ = typedPushConsumer;
        this.typedConsumer_ = this.pushConsumer_.get_typed_consumer();
        if (!this.typedConsumer_._is_a(this.supportedInterface_)) {
            throw new TypeError();
        }
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_TYPED;
    }

    public void isIDLAssignable(String string) throws IllegalArgumentException {
        if (this.typedConsumer_._is_a(string)) {
            return;
        }
        if (string.indexOf("Pull") > 0) {
            int n = string.indexOf("Pull");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string.substring(n + 4));
            if (this.typedConsumer_._is_a(stringBuffer.toString())) {
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushEvent() {
        Message message = this.getMessageNoBlock();
        if (message != null) {
            try {
                boolean bl = this.deliverMessageWithRetry(message);
                return bl;
            }
            finally {
                message.dispose();
            }
        }
        return false;
    }

    private boolean deliverMessageWithRetry(Message message) {
        try {
            String string;
            Property[] propertyArray = message.toTypedEvent();
            if ("operation".equals(propertyArray[0].name)) {
                string = propertyArray[0].value.extract_string();
            } else if ("event_type".equals(propertyArray[0].name)) {
                string = EventTypeHelper.extract((Any)propertyArray[0].value).type_name;
                String string2 = EventTypeHelper.extract((Any)propertyArray[0].value).domain_name;
                this.isIDLAssignable(string2);
            } else {
                throw new IllegalArgumentException();
            }
            int n = string.lastIndexOf("::");
            String string3 = string.substring(n + 2);
            Request request = this.typedConsumer_._request(string3);
            NVList nVList = request.arguments();
            for (int i = 1; i < propertyArray.length; ++i) {
                nVList.add_value(propertyArray[i].name, propertyArray[i].value, 1);
            }
            request.set_return_type(TYPE_CODE_VOID);
            try {
                this.deliverMessageInternal(request);
                return true;
            }
            catch (Exception exception) {
                PushTypedOperation pushTypedOperation = new PushTypedOperation(request);
                this.handleFailedPushOperation(pushTypedOperation, exception);
                return false;
            }
        }
        catch (NoTranslationException noTranslationException) {
            this.logger_.info("No Translation possible", (Throwable)noTranslationException);
            return true;
        }
    }

    private void deliverMessageInternal(Request request) {
        long l = System.currentTimeMillis();
        request.invoke();
        this.timeSpent_ += System.currentTimeMillis() - l;
        this.resetErrorCounter();
    }

    protected void disconnectClient() {
        if (this.pushConsumer_ != null) {
            this.pushConsumer_.disconnect_push_consumer();
            this.pushConsumer_ = null;
        }
    }

    public Servant newServant() {
        return new TypedProxyPushSupplierPOATie(this);
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    private class PushTypedOperation
    implements PushOperation {
        private final Request request_;

        public PushTypedOperation(Request request) {
            this.request_ = request;
        }

        public void invokePush() throws Disconnected {
            TypedProxyPushSupplierImpl.this.deliverMessageInternal(this.request_);
        }

        public void dispose() {
        }
    }
}

