/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.jboss.metadata.ejb.util.Child;
import org.jboss.metadata.ejb.util.ChildClassAdapter;
import org.jboss.metadata.ejb.util.Parent;

public class ChildrenList<E, P>
extends AbstractList<E>
implements Serializable {
    private static ChildClassAdapter<?, ?> defaultChildClassAdapter = new ChildClassAdapter<Child<Parent>, Parent<?>>(){

        @Override
        public Parent<?> getParent(Child<Parent> child) {
            return child.getParent();
        }

        @Override
        public void setParent(Child<Parent> child, Parent<?> parent) {
            child.setParent(parent);
        }
    };
    private ChildClassAdapter<E, P> childClassAdapter;
    private List<E> delegate;
    private P parent;

    public ChildrenList(P parent) {
        this(parent, defaultChildClassAdapter);
    }

    public ChildrenList(P parent, ChildClassAdapter<E, P> childClassAdapter) {
        this.childClassAdapter = childClassAdapter;
        this.delegate = new ArrayList();
        this.parent = parent;
    }

    @Override
    public boolean add(E e) {
        boolean success = this.delegate.add(e);
        if (success) {
            this.childClassAdapter.setParent(e, this.parent);
        }
        return success;
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

