/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class DefaultJNDIBindingPolicyFactory {
    private static final String DEFAULT_JNDI_BINDING_CLASS_NAME = BasicJndiBindingPolicy.class.getName();

    public static DefaultJndiBindingPolicy getDefaultJNDIBindingPolicy() {
        ClassLoader tccl = DefaultJNDIBindingPolicyFactory.getTCCL();
        return DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy(tccl);
    }

    public static DefaultJndiBindingPolicy getDefaultJNDIBindingPolicy(ClassLoader cl) {
        return DefaultJNDIBindingPolicyFactory.getJNDIBindingPolicy(DEFAULT_JNDI_BINDING_CLASS_NAME, cl);
    }

    public static DefaultJndiBindingPolicy getJNDIBindingPolicy(String jndiBindingPolicyClassName) {
        ClassLoader tccl = DefaultJNDIBindingPolicyFactory.getTCCL();
        return DefaultJNDIBindingPolicyFactory.getJNDIBindingPolicy(jndiBindingPolicyClassName, tccl);
    }

    public static DefaultJndiBindingPolicy getJNDIBindingPolicy(String jndiBindingPolicyClassName, ClassLoader cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Classloader cannot be null while creating a jndi binding policy: " + jndiBindingPolicyClassName);
        }
        if (jndiBindingPolicyClassName == null || jndiBindingPolicyClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("JNDI binding policy classname cannot be null or empty string: " + jndiBindingPolicyClassName);
        }
        try {
            Class<?> jndiBindingPolicyOnMetaDataClass = Class.forName(jndiBindingPolicyClassName, true, cl);
            if (!DefaultJndiBindingPolicy.class.isAssignableFrom(jndiBindingPolicyOnMetaDataClass)) {
                throw new RuntimeException("JNDI binding class: " + jndiBindingPolicyClassName + " does not implement " + DefaultJndiBindingPolicy.class);
            }
            return (DefaultJndiBindingPolicy)jndiBindingPolicyOnMetaDataClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load jndi binding policy: " + jndiBindingPolicyClassName, cnfe);
        }
        catch (InstantiationException ine) {
            throw new RuntimeException("Could not create an instance of jndi binding policy: " + jndiBindingPolicyClassName, ine);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException while trying to create an instance of jndi binding policy: " + jndiBindingPolicyClassName, iae);
        }
    }

    private static ClassLoader getTCCL() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl;
    }
}

