/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util.reference;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
        if (System.getSecurityManager() == null) {
            return GetDeclaredMethodAction.NON_PRIVILEGED.getDeclaredMethod(clazz, methodName, arguments);
        }
        return GetDeclaredMethodAction.PRIVILEGED.getDeclaredMethod(clazz, methodName, arguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetDeclaredMethodAction {
        public static final GetDeclaredMethodAction PRIVILEGED = new GetDeclaredMethodAction(){

            @Override
            public Method getDeclaredMethod(final Class<?> clazz, final String methodName, final Class<?> ... arguments) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                        @Override
                        public Method run() throws Exception {
                            return clazz.getDeclaredMethod(methodName, arguments);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception exception = e.getException();
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, exception);
                }
            }
        };
        public static final GetDeclaredMethodAction NON_PRIVILEGED = new GetDeclaredMethodAction(){

            @Override
            public Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
                try {
                    return clazz.getDeclaredMethod(methodName, arguments);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Error getting method " + methodName + " from class " + clazz, e);
                }
            }
        };

        public Method getDeclaredMethod(Class<?> var1, String var2, Class<?> ... var3);
    }
}

