/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.TcpChannelSource;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioXnio;

final class NioTcpConnector
implements TcpConnector {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.connector");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final InetSocketAddress src;
    private final OptionMap optionMap;

    private NioTcpConnector(NioXnio nioXnio, Executor executor, OptionMap optionMap, InetSocketAddress src) {
        if (nioXnio == null) {
            throw new NullPointerException("nioXnio is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.nioXnio = nioXnio;
        this.executor = executor;
        this.src = src;
        this.optionMap = optionMap;
    }

    private void configureStream(Socket socket) throws SocketException {
        OptionMap optionMap = this.optionMap;
        if (optionMap.contains(Options.KEEP_ALIVE)) {
            socket.setKeepAlive((Boolean)optionMap.get(Options.KEEP_ALIVE));
        }
        if (optionMap.contains(Options.TCP_OOB_INLINE)) {
            socket.setOOBInline((Boolean)optionMap.get(Options.TCP_OOB_INLINE));
        }
        if (optionMap.contains(Options.RECEIVE_BUFFER)) {
            socket.setReceiveBufferSize((Integer)optionMap.get(Options.RECEIVE_BUFFER));
        }
        if (optionMap.contains(Options.REUSE_ADDRESSES)) {
            socket.setReuseAddress((Boolean)optionMap.get(Options.REUSE_ADDRESSES));
        }
        if (optionMap.contains(Options.SEND_BUFFER)) {
            socket.setSendBufferSize((Integer)optionMap.get(Options.SEND_BUFFER));
        }
        if (optionMap.contains(Options.TCP_NODELAY)) {
            socket.setTcpNoDelay((Boolean)optionMap.get(Options.TCP_NODELAY));
        }
    }

    public IoFuture<TcpChannel> connectTo(InetSocketAddress dest, ChannelListener<? super TcpChannel> openListener, ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return this.doConnectTo(dest, openListener, bindListener);
    }

    public TcpChannelSource createChannelSource(final InetSocketAddress dest) {
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        return new TcpChannelSource(){

            public IoFuture<TcpChannel> open(ChannelListener<? super TcpChannel> handler) {
                return NioTcpConnector.this.doConnectTo(dest, (ChannelListener<? super TcpChannel>)handler, (ChannelListener<? super BoundChannel<InetSocketAddress>>)null);
            }
        };
    }

    private static InetSocketAddress getNonNull(InetSocketAddress addr) {
        if (addr == null) {
            return new InetSocketAddress(0);
        }
        return addr;
    }

    private IoFuture<TcpChannel> doConnectTo(InetSocketAddress dest, ChannelListener<? super TcpChannel> openListener, ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener) {
        try {
            InetSocketAddress src = NioTcpConnector.getNonNull(this.src);
            log.trace("Connecting from %s to %s", (Object)src, (Object)dest);
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            Executor executor = this.executor;
            NioXnio nioXnio = this.nioXnio;
            NioTcpChannel channel = new NioTcpChannel(nioXnio, socketChannel, executor, this.optionMap.get(Options.MANAGE_CONNECTIONS, true), src, dest);
            nioXnio.addManaged(channel);
            this.configureStream(socket);
            socket.bind(src);
            if (bindListener != null) {
                IoUtils.invokeChannelListener((Executor)executor, channel.getBoundChannel(), bindListener);
            }
            if (socketChannel.connect(dest)) {
                log.trace("Connection from %s to %s is up (immediate)", (Object)src, (Object)dest);
                executor.execute(IoUtils.getChannelListenerTask((Channel)((Object)channel), openListener));
                return new FinishedIoFuture((Object)channel);
            }
            ConnectionHandler connectionHandler = new ConnectionHandler(executor, channel, socketChannel, nioXnio, openListener);
            connectionHandler.handle.resume(8);
            return connectionHandler.futureResult.getIoFuture();
        }
        catch (IOException e) {
            return new FailedIoFuture(e);
        }
    }

    public String toString() {
        return String.format("TCP connector (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    static TcpConnector create(NioXnio nioXnio, Executor executor, OptionMap optionMap, InetSocketAddress src) {
        return new NioTcpConnector(nioXnio, executor, optionMap, src);
    }

    private final class ConnectionHandler
    implements Runnable {
        private final FutureResult<TcpChannel> futureResult;
        private final NioTcpChannel channel;
        private final SocketChannel socketChannel;
        private final NioHandle handle;
        private final ChannelListener<? super TcpChannel> openListener;

        public ConnectionHandler(Executor executor, NioTcpChannel channel, final SocketChannel socketChannel, NioXnio nioXnio, ChannelListener<? super TcpChannel> openListener) throws IOException {
            this.channel = channel;
            this.socketChannel = socketChannel;
            this.openListener = openListener;
            this.handle = nioXnio.addConnectHandler(socketChannel, this, true);
            this.futureResult = new FutureResult(executor);
            this.futureResult.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    if (ConnectionHandler.this.futureResult.setCancelled()) {
                        IoUtils.safeClose((Closeable)socketChannel);
                    }
                    return this;
                }
            });
        }

        @Override
        public void run() {
            SocketChannel socketChannel = this.socketChannel;
            FutureResult<TcpChannel> futureResult = this.futureResult;
            NioHandle handle = this.handle;
            try {
                if (socketChannel.finishConnect()) {
                    log.trace("Connection is up (deferred)");
                    NioTcpChannel channel = this.channel;
                    if (futureResult.setResult((Object)channel)) {
                        IoUtils.invokeChannelListener((Channel)((Object)channel), this.openListener);
                    }
                } else {
                    log.trace("Connection is not yet up (deferred)");
                    handle.resume(8);
                    return;
                }
                handle.cancelKey();
            }
            catch (IOException e) {
                futureResult.setException(e);
                handle.cancelKey();
            }
            catch (Exception e) {
                String message = e.getMessage();
                IOException ioexception = new IOException("Connection failed unexpectedly: " + message);
                ioexception.setStackTrace(e.getStackTrace());
                futureResult.setException(ioexception);
                handle.cancelKey();
            }
        }
    }
}

