/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins.metadata;

import java.util.Collections;
import java.util.Set;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.ExportPackages;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.helpers.AbstractCapability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCapability
extends AbstractCapability
implements ExportPackages {
    private static final long serialVersionUID = 948069557003560933L;
    private SplitPackagePolicy splitPolicy = SplitPackagePolicy.Error;

    public PackageCapability() {
    }

    public PackageCapability(String name) {
        super(name);
    }

    public PackageCapability(String name, Object version) {
        super(name, version);
    }

    public PackageCapability(String name, Object version, SplitPackagePolicy splitPolicy) {
        super(name, version);
        this.splitPolicy = splitPolicy;
    }

    public SplitPackagePolicy getSplitPackagePolicy() {
        return this.splitPolicy;
    }

    public void setSplitPackagePolicy(SplitPackagePolicy policy) {
        this.splitPolicy = policy;
    }

    @Override
    public boolean resolves(Module reqModule, Requirement requirement) {
        ClassFilter filter;
        if (!(requirement instanceof PackageRequirement)) {
            return false;
        }
        PackageRequirement requirePackage = (PackageRequirement)requirement;
        if (requirePackage.isWildcard() ? !(filter = requirePackage.toClassFilter()).matchesPackageName(this.getName()) : !this.getName().equals(requirePackage.getName())) {
            return false;
        }
        return requirePackage.getVersionRange().isInRange(this.getVersion());
    }

    @Override
    public Set<String> getPackageNames(Module module) {
        return Collections.singleton(this.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageCapability)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SplitPackagePolicy {
        First,
        Last,
        Error;

    }
}

