/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.injection;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.TomcatInjectionContainer;

public class JBossDelegatingInjectionProvider
implements InjectionProvider {
    protected TomcatInjectionContainer injectionContainer = null;
    private static final Logger log = Logger.getLogger(InjectionProvider.class);

    public JBossDelegatingInjectionProvider() {
        Object context = FacesContext.getCurrentInstance().getExternalContext().getContext();
        if (context instanceof ServletContext && context != null) {
            ServletContext servletContext = (ServletContext)context;
            this.injectionContainer = (TomcatInjectionContainer)servletContext.getAttribute(InstanceManager.class.getName());
        }
        if (this.injectionContainer == null) {
            log.debug((Object)"JSF injection not available for this web deployment.");
        }
    }

    protected JBossDelegatingInjectionProvider(TomcatInjectionContainer injectionContainer) {
        this.injectionContainer = injectionContainer;
        if (injectionContainer == null) {
            log.debug((Object)"JSF injection not available for this web deployment.");
        }
    }

    public void inject(Object object) throws InjectionProviderException {
        if (!this.checkInjectionContainer()) {
            return;
        }
        try {
            this.injectionContainer.processInjectors(object);
        }
        catch (Throwable t) {
            throw new InjectionProviderException("unable to process injections.", t);
        }
    }

    public void invokePostConstruct(Object object) throws InjectionProviderException {
        if (!this.checkInjectionContainer()) {
            return;
        }
        try {
            this.injectionContainer.postConstruct(object);
        }
        catch (Throwable t) {
            throw new InjectionProviderException("unable to process invokePostConstruct.", t);
        }
    }

    public void invokePreDestroy(Object object) throws InjectionProviderException {
        if (!this.checkInjectionContainer()) {
            return;
        }
        try {
            this.injectionContainer.preDestroy(object);
        }
        catch (Throwable t) {
            throw new InjectionProviderException("unable to process invokePreDestroy.", t);
        }
    }

    private boolean checkInjectionContainer() {
        return this.injectionContainer != null;
    }
}

