/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetDataModel
extends DataModel<Map<String, Object>> {
    private int _currentIndex = -1;
    private ResultSet _resultSet = null;
    private ResultSetMetaData _resultSetMetadata = null;
    private boolean _currentRowUpdated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    @Override
    public Map<String, Object> getRowData() {
        if (this._resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("the requested row is not available in the ResultSet - you have scrolled beyond the end.");
        }
        try {
            return new WrapResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    @Override
    public int getRowIndex() {
        return this._currentIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._resultSet;
    }

    @Override
    public boolean isRowAvailable() {
        if (this._resultSet == null) {
            return false;
        }
        if (this._currentIndex < 0) {
            return false;
        }
        try {
            return this._resultSet.absolute(this._currentIndex + 1);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("you cannot set the rowIndex to anything less than 0");
        }
        if (this._currentRowUpdated && this._resultSet != null) {
            try {
                if (!this._resultSet.rowDeleted()) {
                    this._resultSet.updateRow();
                }
                this.setCurrentRowUpdated(false);
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        int old = this._currentIndex;
        this._currentIndex = rowIndex;
        if (this._resultSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this._currentIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this._currentIndex, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listeners[i] == null) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this._resultSetMetadata = null;
            this._resultSet = null;
            this.setRowIndex(-1);
        } else {
            this._resultSetMetadata = null;
            this._resultSet = (ResultSet)data;
            this._currentIndex = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getResultSetMetadata() {
        if (this._resultSetMetadata == null) {
            try {
                this._resultSetMetadata = this._resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        return this._resultSetMetadata;
    }

    private void setCurrentRowUpdated(boolean currentRowUpdated) {
        this._currentRowUpdated = currentRowUpdated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetValuesIterator
    implements Iterator<Object> {
        private WrapResultSetMap _wrapMap;
        private Iterator<String> _keyIterator;

        public WrapResultSetValuesIterator(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        @Override
        public Object next() {
            return this._wrapMap.get(this._keyIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this map");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetValues
    extends AbstractCollection<Object> {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetValues(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        @Override
        public boolean contains(Object value) {
            return this._wrapMap.containsValue(value);
        }

        @Override
        public Iterator<Object> iterator() {
            return new WrapResultSetValuesIterator(this._wrapMap);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        @Override
        public int size() {
            return this._wrapMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetKeysIterator
    implements Iterator<String> {
        private Iterator<String> _keyIterator = null;

        public WrapResultSetKeysIterator(WrapResultSetMap map) {
            this._keyIterator = map.getUnderlyingKeys();
        }

        @Override
        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        @Override
        public String next() {
            return this._keyIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this iterator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetKeys
    extends AbstractSet<String> {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetKeys(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        @Override
        public boolean add(String o) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        @Override
        public boolean contains(Object obj) {
            return this._wrapMap.containsKey(obj);
        }

        @Override
        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return new WrapResultSetKeysIterator(this._wrapMap);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        @Override
        public int size() {
            return this._wrapMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetEntry
    implements Map.Entry<String, Object> {
        private WrapResultSetMap _wrapMap;
        private String _entryKey;

        public WrapResultSetEntry(WrapResultSetMap wrapMap, String entryKey) {
            this._wrapMap = wrapMap;
            this._entryKey = entryKey;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry cmpEntry = (Map.Entry)o;
            if (this._entryKey == null ? cmpEntry.getKey() != null : !this._entryKey.equals(cmpEntry.getKey())) {
                return false;
            }
            Object value = this._wrapMap.get(this._entryKey);
            Object cmpValue = cmpEntry.getValue();
            return value == null ? cmpValue != null : value.equals(cmpValue);
        }

        @Override
        public String getKey() {
            return this._entryKey;
        }

        @Override
        public Object getValue() {
            return this._wrapMap.get(this._entryKey);
        }

        @Override
        public int hashCode() {
            int result = this._entryKey != null ? this._entryKey.hashCode() : 0;
            result = 29 * result + (this._wrapMap.get(this._entryKey) != null ? this._wrapMap.get(this._entryKey).hashCode() : 0);
            return result;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this._wrapMap.get(this._entryKey);
            this._wrapMap.put(this._entryKey, value);
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetEntriesIterator
    implements Iterator<Map.Entry<String, Object>> {
        private WrapResultSetMap _wrapMap = null;
        private Iterator<String> _keyIterator = null;

        public WrapResultSetEntriesIterator(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            return new WrapResultSetEntry(this._wrapMap, this._keyIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("It is not allowed to remove from this iterator");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapResultSetEntries
    extends AbstractSet<Map.Entry<String, Object>> {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetEntries(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        @Override
        public boolean add(Map.Entry<String, Object> o) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, Object>> c) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (!this._wrapMap.containsKey(key)) {
                return false;
            }
            Object value = e.getValue();
            Object cmpValue = this._wrapMap.get(key);
            return value == null ? cmpValue == null : value.equals(cmpValue);
        }

        @Override
        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new WrapResultSetEntriesIterator(this._wrapMap);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        @Override
        public int size() {
            return this._wrapMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrapResultSetMap
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = -4321143404567038922L;
        private int _currentIndex;

        public WrapResultSetMap(Comparator<String> comparator) throws SQLException {
            super(comparator);
            this._currentIndex = ResultSetDataModel.this._currentIndex;
            ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
            int columnCount = ResultSetDataModel.this.getResultSetMetadata().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                super.put(ResultSetDataModel.this.getResultSetMetadata().getColumnName(i), ResultSetDataModel.this.getResultSetMetadata().getColumnName(i));
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this map");
        }

        @Override
        public boolean containsValue(Object value) {
            for (String key : this.keySet()) {
                Object object = this.get(key);
                if (object == null) {
                    return value == null;
                }
                if (!object.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new WrapResultSetEntries(this);
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            return this.basicGet(key);
        }

        private Object basicGet(Object key) {
            try {
                ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
                return ResultSetDataModel.this._resultSet.getObject((String)this.getUnderlyingKey(key));
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public Set<String> keySet() {
            return new WrapResultSetKeys(this);
        }

        @Override
        public Object put(String key, Object value) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException("underlying result set does not provide this key");
            }
            try {
                ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
                Object oldValue = ResultSetDataModel.this._resultSet.getObject((String)this.getUnderlyingKey(key));
                if (oldValue == null ? value == null : oldValue.equals(value)) {
                    return oldValue;
                }
                ResultSetDataModel.this._resultSet.updateObject((String)this.getUnderlyingKey(key), value);
                ResultSetDataModel.this.setCurrentRowUpdated(true);
                return oldValue;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("It is not allowed to remove entries from this set.");
        }

        @Override
        public Collection<Object> values() {
            return new WrapResultSetValues(this);
        }

        Object getUnderlyingKey(Object key) {
            return super.get(key);
        }

        Iterator<String> getUnderlyingKeys() {
            return super.keySet().iterator();
        }
    }
}

