/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.component._MessageUtils;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;

public class UIViewParameter
extends UIInput {
    public static final String COMPONENT_FAMILY = "javax.faces.ViewParameter";
    public static final String COMPONENT_TYPE = "javax.faces.ViewParameter";
    private static final String DELEGATE_FAMILY = "javax.faces.Input";
    private static final String DELEGATE_RENDERER_TYPE = "javax.faces.Text";
    private static Renderer _delegateRenderer;

    public UIViewParameter() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "javax.faces.ViewParameter";
    }

    public void decode(FacesContext context) {
        String value = context.getExternalContext().getRequestParameterMap().get(this.getName());
        if (value != null) {
            this.setSubmittedValue(value);
        }
    }

    public void encodeAll(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setSubmittedValue(this.getStringValue(context));
    }

    public String getName() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.name));
    }

    public String getStringValue(FacesContext context) {
        if (this.getValueExpression("value") != null) {
            return this.getStringValueFromModel(context);
        }
        return (String)this.getLocalValue();
    }

    public String getStringValueFromModel(FacesContext context) throws ConverterException {
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Object value = ve.getValue(context.getELContext());
        if (value instanceof String) {
            return (String)value;
        }
        Converter converter = this.getConverter();
        if (converter == null) {
            if (value == null) {
                return null;
            }
            converter = context.getApplication().createConverter(value.getClass());
            if (converter == null) {
                return value.toString();
            }
        }
        return converter.getAsString(context, this, value);
    }

    public String getSubmittedValue() {
        return (String)super.getSubmittedValue();
    }

    public boolean isImmediate() {
        return false;
    }

    public boolean isRendered() {
        return super.isRendered();
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.getSubmittedValue() == null && this.isRequired()) {
            FacesMessage message;
            String required = this.getRequiredMessage();
            if (required != null) {
                message = new FacesMessage(FacesMessage.SEVERITY_ERROR, required, required);
            } else {
                Object label = _MessageUtils.getLabel(context, this);
                message = _MessageUtils.getMessage(context, context.getViewRoot().getLocale(), FacesMessage.SEVERITY_ERROR, "javax.faces.component.UIInput.REQUIRED", new Object[]{label});
            }
            this.setValid(false);
            context.addMessage(this.getClientId(context), message);
            context.validationFailed();
            context.renderResponse();
            return;
        }
        super.processValidators(context);
    }

    public void setName(String name) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.name), name);
    }

    public void updateModel(FacesContext context) {
        super.updateModel(context);
        if (this.getValueExpression("value") == null && this.isValid() && this.isLocalValueSet()) {
            context.getExternalContext().getRequestMap().put(this.getName(), this.getLocalValue());
        }
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) {
        return UIViewParameter.getDelegateRenderer(context).getConvertedValue(context, this, submittedValue);
    }

    private static Renderer getDelegateRenderer(FacesContext context) {
        if (_delegateRenderer == null) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
            RenderKit kit = factory.getRenderKit(context, "HTML_BASIC");
            _delegateRenderer = kit.getRenderer(DELEGATE_FAMILY, DELEGATE_RENDERER_TYPE);
        }
        return _delegateRenderer;
    }

    public static class Reference {
        private int _index;
        private UIViewParameter _param;
        private Object _state;
        private String _viewId;

        public Reference(FacesContext context, UIViewParameter param, int indexInParent, String viewIdAtTimeOfConstruction) {
            this._param = param;
            this._viewId = viewIdAtTimeOfConstruction;
            this._index = indexInParent;
            this._state = param.saveState(context);
        }

        public UIViewParameter getUIViewParameter(FacesContext context) {
            if (context.getViewRoot().getViewId().equals(this._viewId)) {
                return (UIViewParameter)this._param.getParent().getChildren().get(this._index);
            }
            this._param.restoreState(context, this._state);
            return this._param;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        name;

    }
}

