/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.switchboard.resource.provider;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.logging.Logger;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.jboss.environment.JBossMessageDestinationRefType;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDestinationReferenceResourceProvider
implements MCBasedResourceProvider<JBossMessageDestinationRefType> {
    private static Logger logger = Logger.getLogger(MessageDestinationReferenceResourceProvider.class);
    private MessageDestinationReferenceResolver messageDestinationResolver;

    public Class<JBossMessageDestinationRefType> getEnvironmentEntryType() {
        return JBossMessageDestinationRefType.class;
    }

    public Resource provide(DeploymentUnit unit, JBossMessageDestinationRefType messageDestRef) {
        String lookupName = messageDestRef.getLookupName();
        if (lookupName != null && !lookupName.trim().isEmpty()) {
            return new LinkRefResource(lookupName);
        }
        String mappedName = messageDestRef.getMappedName();
        if (mappedName != null && !mappedName.trim().isEmpty()) {
            return new LinkRefResource(mappedName);
        }
        String jndiName = messageDestRef.getJNDIName();
        if (jndiName != null && !jndiName.trim().isEmpty()) {
            return new LinkRefResource(jndiName);
        }
        String messageDestLink = messageDestRef.getMessageDestinationLink();
        if (messageDestLink != null && !messageDestLink.trim().isEmpty()) {
            if (this.messageDestinationResolver == null) {
                logger.warn((Object)("Cannot resolve message-destination link: " + messageDestLink + " for message-destination-ref: " + messageDestRef.getName() + " due to absence of a " + MessageDestinationReferenceResolver.class.getName()));
            } else {
                DeploymentUnit dependentDU = unit;
                if (unit.isComponent()) {
                    dependentDU = unit.getParent();
                }
                String resolvedJNDIName = this.messageDestinationResolver.resolveMessageDestinationJndiName(dependentDU, messageDestLink);
                logger.debug((Object)("Resolved jndi-name: " + resolvedJNDIName + " for message-destination link: " + messageDestLink + " in message-destination-ref: " + messageDestRef.getName()));
                if (resolvedJNDIName != null && !resolvedJNDIName.trim().isEmpty()) {
                    return new LinkRefResource(resolvedJNDIName);
                }
            }
        }
        throw new RuntimeException("Cannot provide a resource for message-destination-ref: " + messageDestRef.getName() + " in unit: " + unit);
    }

    public void setMessageDestinationLinkResolver(MessageDestinationReferenceResolver resolver) {
        this.messageDestinationResolver = resolver;
    }
}

