/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.concurrency.aop.interceptor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.concurrency.impl.EJBReadWriteLock;
import org.jboss.ejb3.effigy.AccessTimeoutEffigy;
import org.jboss.ejb3.effigy.SessionBeanEffigy;
import org.jboss.ejb3.effigy.aop.EJBInvocation;
import org.jboss.logging.Logger;

public class ContainerManagedConcurrencyInterceptor
implements Interceptor {
    private static Logger logger = Logger.getLogger(ContainerManagedConcurrencyInterceptor.class);
    private ReadWriteLock readWriteLock = new EJBReadWriteLock();
    private static final long DEFAULT_MAX_TIMEOUT_VALUE = 5L;
    private static final TimeUnit DEFAULT_MAX_TIMEOUT_UNIT = TimeUnit.MINUTES;

    private AccessTimeoutEffigy getAccessTimeout(MethodInvocation invocation) {
        return this.getEffigy((EJBInvocation)invocation).getAccessTimeout(invocation.getMethod());
    }

    private SessionBeanEffigy getEffigy(EJBInvocation invocation) {
        return (SessionBeanEffigy)invocation.getEffigy();
    }

    private java.util.concurrent.locks.Lock getLock(Invocation invocation) {
        LockType lockType = this.getLockType(invocation);
        switch (lockType) {
            case READ: {
                return this.readWriteLock.readLock();
            }
            case WRITE: {
                return this.readWriteLock.writeLock();
            }
        }
        throw new IllegalStateException("Illegal lock type " + lockType + " on " + invocation);
    }

    private LockType getLockType(Invocation invocation) {
        Lock lock = (Lock)invocation.resolveAnnotation(Lock.class);
        if (lock == null) {
            lock = (Lock)invocation.resolveClassAnnotation(Lock.class);
        }
        if (lock == null) {
            return LockType.WRITE;
        }
        return lock.value();
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        boolean success;
        java.util.concurrent.locks.Lock lock = this.getLock(invocation);
        long time = 5L;
        TimeUnit unit = DEFAULT_MAX_TIMEOUT_UNIT;
        AccessTimeoutEffigy timeout = this.getAccessTimeout((MethodInvocation)invocation);
        if (timeout != null) {
            if (timeout.getTimeout() < 0L) {
                logger.debug((Object)("Ignoring a negative @AccessTimeout value: " + timeout.getTimeout() + " and timeout unit: " + timeout.getUnit().name() + ". Will default to timeout value: " + 5L + " and timeout unit: " + DEFAULT_MAX_TIMEOUT_UNIT.name()));
            } else {
                time = timeout.getTimeout();
                unit = timeout.getUnit();
            }
        }
        if (!(success = lock.tryLock(time, unit))) {
            throw new ConcurrentAccessTimeoutException("EJB 3.1 PFD2 4.8.5.5.1 concurrent access timeout on " + invocation + " - could not obtain lock within " + time + unit.name());
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

