/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.MethodInfo;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;

public class ConstructorUtils {
    private ConstructorUtils() {
    }

    public static void addDefaultConstructor(ClassFile file, Bytecode initialValueBytecode) {
        ConstructorUtils.addConstructor("()V", new String[0], file, initialValueBytecode);
    }

    public static void addConstructor(String descriptor, String[] exceptions, ClassFile file, Bytecode initialValueBytecode) {
        try {
            MethodInfo ctor = new MethodInfo(file.getConstPool(), "<init>", descriptor);
            ctor.setAccessFlags(1);
            ExceptionsAttribute exAt = new ExceptionsAttribute(file.getConstPool());
            exAt.setExceptions(exceptions);
            ctor.setExceptionsAttribute(exAt);
            Bytecode b = new Bytecode(file.getConstPool());
            String[] params = DescriptorUtils.descriptorStringToParameterArray(descriptor);
            b.add(42);
            int localVariableCount = BytecodeUtils.loadParameters(b, descriptor);
            b.addInvokespecial(file.getSuperclass(), "<init>", descriptor);
            b.addAload(0);
            b.addIconst(1);
            b.addPutfield(file.getName(), "constructed", "Z");
            b.addOpcode(177);
            CodeAttribute ca = b.toCodeAttribute();
            ca.iterator().insert(initialValueBytecode.get());
            ctor.setCodeAttribute(ca);
            ca.setMaxLocals(localVariableCount);
            ca.computeMaxStack();
            file.addMethod(ctor);
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        catch (DuplicateMemberException e) {
            throw new RuntimeException(e);
        }
    }
}

